/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.DAVCBean;
import com.sun.web.admin.beans.DAVCollection;
import com.sun.web.admin.beans.DAVException;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.MiscUtil;
import com.sun.web.admin.util.SlashUtil;
import com.sun.web.admin.util.XmlConfig;
import com.sun.web.admin.util.XmlNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DAV {
    private String rootDir_;
    private String lockDB_;
    private int minLockTimeout_ = 0;
    private int rqstBodySize_ = 8192;
    private String propDepth_ = "1";
    private boolean enabled_ = true;
    private XmlNode davNode_ = null;
    private XmlNode vsNode_ = null;
    private String vsID_;
    private XmlNode rootNode_ = null;
    private String instanceName_;
    private String instanceDir_;
    private List davCollections_;
    private boolean useBackup_ = true;
    private boolean defaultLockDB_ = true;
    private boolean defaultLockTimeout_ = true;
    public static final int MIN_LOCK_TIME_OUT = 0;
    public static final int MAX_RQST_BODY_SIZE = 8192;
    public static final String PROP_DEPTH = "1";

    private DAV() {
    }

    DAV(XmlNode xmlNode, XmlNode xmlNode2, XmlNode xmlNode3, String string, String string2, String string3, String string4) throws IllegalArgumentException, DAVException {
        this(xmlNode, xmlNode2, xmlNode3, string, string2, string3, string4, 0, 8192, PROP_DEPTH, true);
    }

    DAV(XmlNode xmlNode, XmlNode xmlNode2, XmlNode xmlNode3, String string, String string2, String string3, String string4, int n, int n2, String string5, boolean bl) throws IllegalArgumentException, DAVException {
        this.initialize(string, string2, string3, string4, n, n2, string5, bl);
        if (this.instanceName_.equals("https-admserv")) {
            this.useBackup_ = false;
        }
        if (xmlNode3 != null) {
            this.rootNode_ = xmlNode3;
        }
        String string6 = null;
        string6 = this.useBackup_ ? this.instanceDir_ + "/conf_bk/server.xml" : this.instanceDir_ + "/config/server.xml";
        if (xmlNode2 == null) {
            this.getNode(string6);
        } else {
            this.davNode_ = xmlNode2;
            this.vsNode_ = xmlNode;
            this.davCollections_ = this.getCollections();
        }
    }

    public boolean addCollection(DAVCollection dAVCollection) throws Exception {
        return this.addCollection(dAVCollection, null, null);
    }

    public boolean addCollection(DAVCollection dAVCollection, String string, String string2) throws Exception {
        if (this.davCollections_ == null) {
            this.davCollections_ = new ArrayList();
        }
        XmlNode xmlNode = null;
        if (string == null && string2 == null && !this.contains(dAVCollection)) {
            xmlNode = this.createNewChild(dAVCollection);
            this.davCollections_.add(xmlNode);
            this.writeToServerXML();
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < this.davCollections_.size(); ++i) {
            String string3 = null;
            String string4 = null;
            xmlNode = (XmlNode)this.davCollections_.get(i);
            XmlNode xmlNode2 = xmlNode.findChildNode("sourceuri");
            if (xmlNode2 != null) {
                string4 = xmlNode2.getValue();
            }
            if ((xmlNode2 = xmlNode.findChildNode("uri")) != null) {
                string3 = xmlNode2.getValue();
            }
            if (string3.equals(string) || string3.equals(dAVCollection.getURI())) {
                XmlNode xmlNode3 = new XmlNode(this.davNode_, "DAVCOLLECTION", "", "", 0);
                xmlNode3.addChild("uri", dAVCollection.getURI(), "", 0, true);
                if (dAVCollection.getSourceURI() != null && !dAVCollection.getSourceURI().equals("")) {
                    xmlNode3.addChild("sourceuri", dAVCollection.getSourceURI(), "", 0, true);
                }
                if (!(dAVCollection.getLockDB() == null || dAVCollection.getLockDB().equals("") || dAVCollection.getLockDB().equals(this.lockDB_) || dAVCollection.getLockDB().equals("default"))) {
                    xmlNode3.addChild("lockdb", dAVCollection.getLockDB(), "", 0, true);
                }
                if (dAVCollection.getMinLockTimeout() != -1 && dAVCollection.getMinLockTimeout() != this.minLockTimeout_) {
                    xmlNode3.addChild("minlocktimeout", Integer.toString(dAVCollection.getMinLockTimeout()), "", 0, true);
                }
                if (dAVCollection.getMinLockTimeout() == -1 && dAVCollection.getMinLockTimeout() != this.minLockTimeout_) {
                    xmlNode3.addChild("minlocktimeout", "infinity", "", 0, true);
                }
                if (dAVCollection.getRequestSize() != 8192 && dAVCollection.getRequestSize() != this.rqstBodySize_) {
                    xmlNode3.addChild("maxxmlrequestbodysize", Integer.toString(dAVCollection.getRequestSize()), "", 0, true);
                }
                if (!dAVCollection.getPropDepth().equals(this.propDepth_)) {
                    xmlNode3.addChild("maxpropdepth", dAVCollection.getPropDepth(), "", 0, true);
                }
                xmlNode3.addChild("enabled", Boolean.toString(dAVCollection.enabled()), "", 0, true);
                this.davNode_.removeChild(xmlNode);
                this.davNode_.addChild(xmlNode3);
                this.writeToServerXML();
            }
            bl = false;
        }
        return true;
    }

    public void removeCollection(DAVCollection dAVCollection) throws Exception {
        XmlNode xmlNode = null;
        int n = 0;
        while (true) {
            xmlNode = (XmlNode)this.davCollections_.get(n);
            XmlNode xmlNode2 = xmlNode.findChildNode("uri");
            String string = xmlNode2.getValue();
            xmlNode2 = xmlNode.findChildNode("sourceuri");
            String string2 = null;
            if (xmlNode2 != null) {
                string2 = xmlNode2.getValue();
            }
            boolean bl = false;
            if (string.equals(dAVCollection.getURI())) {
                if (string2 == null && dAVCollection.getSourceURI() == null) {
                    bl = true;
                }
                if (string2 != null && dAVCollection.getSourceURI() != null && string2.equals(dAVCollection.getSourceURI())) {
                    bl = true;
                }
                if (bl) {
                    this.davCollections_.remove(xmlNode);
                    this.davNode_.removeChild(xmlNode);
                    this.writeToServerXML();
                    return;
                }
            }
            ++n;
        }
    }

    public static Enumeration listCollections(String string, String string2, String string3) {
        Vector<DAVCBean> vector = new Vector<DAVCBean>();
        String string4 = SlashUtil.de_slashes(string) + '/' + string2;
        String string5 = null;
        string5 = string2.equals("https-admserv") ? string4 + "/config/server.xml" : string4 + "/conf_bk/server.xml";
        try {
            Iterator iterator;
            XmlConfig xmlConfig = new XmlConfig(string5);
            XmlNode xmlNode = xmlConfig.parseConfig();
            XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(xmlNode);
            String string6 = xmlNodeWrapper.getParentClassName(string3);
            XmlNode xmlNode2 = xmlNodeWrapper.getVSNode(string6, string3);
            if (xmlNode2 != null && (iterator = xmlNode2.iterate("DAV")).hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator.next();
                String string7 = xmlNode3.getString("lockdb", null);
                String string8 = xmlNode3.getString("minlocktimeout", null);
                String string9 = xmlNode3.getString("maxxmlrequestbodysize", null);
                String string10 = xmlNode3.getString("maxpropdepth", null);
                Iterator iterator2 = xmlNode3.iterate("DAVCOLLECTION");
                while (iterator2.hasNext()) {
                    String string11;
                    String string12;
                    String string13;
                    String string14;
                    XmlNode xmlNode4 = (XmlNode)iterator2.next();
                    String string15 = xmlNode4.getString("uri", null);
                    String string16 = xmlNode4.getString("sourceuri", null);
                    String string17 = xmlNode4.getString("lockdb", null);
                    if (string17 == null) {
                        string17 = string7 != null ? string7 : SlashUtil.de_slashes(string4) + "/lock-db/" + string3;
                    }
                    if ((string14 = xmlNode4.getString("minlocktimeout", null)) == null) {
                        string14 = string8;
                    }
                    if (string14.equals("infinity")) {
                        string14 = "-1";
                    }
                    if ((string13 = xmlNode4.getString("maxxmlrequestbodysize", null)) == null) {
                        string13 = string9;
                    }
                    if ((string12 = xmlNode4.getString("maxpropdepth", null)) == null) {
                        string12 = string10;
                    }
                    if ((string11 = xmlNode4.getString("enabled", null)) == null) {
                        string11 = "true";
                    }
                    boolean bl = true;
                    int n = 0;
                    int n2 = 8192;
                    if (string14 != null && !string14.equals("")) {
                        n = Integer.parseInt(string14);
                    }
                    if (string13 != null && !string13.equals("")) {
                        n2 = Integer.parseInt(string13);
                    }
                    if (string11 != null && !string11.equals("")) {
                        bl = Boolean.valueOf(string11);
                    }
                    DAVCBean dAVCBean = new DAVCBean(string3, string15, string16, string17, n, n2, string12, bl);
                    vector.add(dAVCBean);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("---- DAV.listCollections : " + exception.getMessage());
        }
        return vector.elements();
    }

    public static Enumeration listURIs(String string, String string2, String string3, boolean bl) {
        Vector<String> vector = new Vector<String>();
        String string4 = SlashUtil.de_slashes(string) + '/' + string2;
        String string5 = null;
        string5 = string2.equals("https-admserv") ? string4 + "/config/server.xml" : string4 + "/conf_bk/server.xml";
        try {
            Iterator iterator;
            XmlConfig xmlConfig = new XmlConfig(string5);
            XmlNode xmlNode = xmlConfig.parseConfig();
            XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(xmlNode);
            String string6 = xmlNodeWrapper.getParentClassName(string3);
            XmlNode xmlNode2 = xmlNodeWrapper.getVSNode(string6, string3);
            if (xmlNode2 != null && (iterator = xmlNode2.iterate("DAV")).hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator.next();
                Iterator iterator2 = xmlNode3.iterate("DAVCOLLECTION");
                while (iterator2.hasNext()) {
                    XmlNode xmlNode4 = (XmlNode)iterator2.next();
                    String string7 = xmlNode4.getString("uri", null);
                    String string8 = xmlNode4.getString("sourceuri", null);
                    if (bl) {
                        vector.add(string8);
                        continue;
                    }
                    vector.add(string7);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("---- DAV.listURIs : " + exception.getMessage());
        }
        return vector.elements();
    }

    public static void deleteCollectionForURI(String string, String string2, String string3, String string4) throws Exception {
        Iterator iterator;
        String string5;
        String string6 = SlashUtil.de_slashes(string) + '/' + string2;
        String string7 = null;
        string7 = string2.equals("https-admserv") ? string6 + "/config/server.xml" : string6 + "/conf_bk/server.xml";
        XmlConfig xmlConfig = new XmlConfig(string7);
        XmlNode xmlNode = xmlConfig.parseConfig();
        XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(xmlNode);
        XmlNode xmlNode2 = xmlNodeWrapper.getVSNode(string5 = xmlNodeWrapper.getParentClassName(string3), string3);
        if (xmlNode2 != null && (iterator = xmlNode2.iterate("DAV")).hasNext()) {
            XmlNode xmlNode3 = (XmlNode)iterator.next();
            Iterator iterator2 = xmlNode3.iterate("DAVCOLLECTION");
            while (iterator2.hasNext()) {
                XmlNode xmlNode4 = (XmlNode)iterator2.next();
                String string8 = xmlNode4.getString("uri", null);
                String string9 = xmlNode4.getString("sourceuri", null);
                if (!string8.equals(string4)) continue;
                xmlNode3.removeChild(xmlNode4);
                MiscUtil.writeToServerXML(string6, string, xmlNode, true);
                break;
            }
        }
    }

    protected XmlNode createNewChild(DAVCollection dAVCollection) {
        XmlNode xmlNode = null;
        if (dAVCollection != null) {
            xmlNode = new XmlNode(this.davNode_, "DAVCOLLECTION", "", "", 0);
            xmlNode.addChild("uri", dAVCollection.getURI(), "", 0, true);
            if (dAVCollection.getSourceURI() != null && !dAVCollection.getSourceURI().equals("")) {
                xmlNode.addChild("sourceuri", dAVCollection.getSourceURI(), "", 0, true);
            }
            if (!dAVCollection.getLockDB().equals(this.lockDB_) && !dAVCollection.getLockDB().equals("default")) {
                xmlNode.addChild("lockdb", dAVCollection.getLockDB(), "", 0, true);
            }
            if (dAVCollection.getMinLockTimeout() != this.minLockTimeout_ && dAVCollection.getMinLockTimeout() != -1) {
                xmlNode.addChild("minlocktimeout", Integer.toString(dAVCollection.getMinLockTimeout()), "", 0, true);
            }
            if (dAVCollection.getMinLockTimeout() == -1 && dAVCollection.getMinLockTimeout() != this.minLockTimeout_) {
                xmlNode.addChild("minlocktimeout", "infinity", "", 0, true);
            }
            if (dAVCollection.getRequestSize() != this.rqstBodySize_) {
                xmlNode.addChild("maxxmlrequestbodysize", Integer.toString(dAVCollection.getRequestSize()), "", 0, true);
            }
            if (!dAVCollection.getPropDepth().equals(this.propDepth_)) {
                xmlNode.addChild("maxpropdepth", dAVCollection.getPropDepth(), "", 0, true);
            }
            xmlNode.addChild("enabled", Boolean.toString(dAVCollection.enabled()), "", 0, true);
            this.davNode_.addChild(xmlNode);
        }
        return xmlNode;
    }

    public static String initDAV(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String string9 = null;
        String string10 = SlashUtil.de_slashes(string2) + "/" + string3;
        string9 = string3.equals("https-admserv") ? string10 + "/config/" + "server.xml" : string10 + "/conf_bk/" + "server.xml";
        XmlNode xmlNode = new XmlConfig(string9).parseConfig();
        XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(xmlNode);
        XmlNode xmlNode2 = xmlNodeWrapper.getVSNode(string4, string);
        XmlNode xmlNode3 = null;
        if (xmlNode2 == null) {
            return null;
        }
        Iterator iterator = xmlNode2.iterate("DAV");
        if (iterator.hasNext()) {
            xmlNode3 = (XmlNode)iterator.next();
            if (bl2) {
                String string11 = xmlNode3.getString("lockdb", null);
                stringBuffer.append("lockdb=");
                stringBuffer.append(string11);
                stringBuffer.append("|");
                string11 = xmlNode3.getString("minlocktimeout", null);
                stringBuffer.append("minlocktimeout=");
                if (string11 == null) {
                    string11 = "0";
                }
                if (string11.equals("infinity")) {
                    string11 = "-1";
                }
                stringBuffer.append(string11);
                stringBuffer.append("|");
                string11 = xmlNode3.getString("maxxmlrequestbodysize", null);
                stringBuffer.append("maxxmlrequestbodysize=");
                stringBuffer.append(string11);
                stringBuffer.append("|");
                string11 = xmlNode3.getString("maxpropdepth", null);
                stringBuffer.append("maxpropdepth=");
                stringBuffer.append(string11);
                stringBuffer.append("|");
                string11 = xmlNode3.getString("enabled", null);
                stringBuffer.append("enabled=");
                stringBuffer.append(string11);
            } else {
                if (string5 != null) {
                    xmlNode3.setAttribute("lockdb", string5);
                }
                if (string6 != null) {
                    if (string6.equals("-1") || string6.equals("infinity")) {
                        string6 = "infinity";
                    }
                    xmlNode3.setAttribute("minlocktimeout", string6);
                }
                if (string7 != null) {
                    xmlNode3.setAttribute("maxxmlrequestbodysize", string7);
                }
                if (string8 != null) {
                    xmlNode3.setAttribute("maxpropdepth", string8);
                }
                xmlNode3.setAttribute("enabled", Boolean.toString(bl));
            }
        } else if (!bl2) {
            xmlNode3 = DAV.createDAVNodeForVS(xmlNode2, string5, Integer.parseInt(string6), Integer.parseInt(string7), string8, bl, string10);
            if (xmlNode3 != null) {
                xmlNode2.addChild(xmlNode3);
            } else {
                throw new Exception("DAV.initDAV, failed creating DAV Element for VS : " + string);
            }
        }
        if (!bl2) {
            MiscUtil.writeToServerXML(string10, string2, xmlNode, true);
        }
        return stringBuffer.toString();
    }

    protected static XmlNode createDAVNodeForVS(XmlNode xmlNode, String string, int n, int n2, String string2, boolean bl, String string3) {
        XmlNode xmlNode2 = null;
        xmlNode2 = new XmlNode(xmlNode, "DAV", "", "", 0);
        if (string.equalsIgnoreCase("default")) {
            String string4 = xmlNode.findChildNode("id").getValue();
            string = SlashUtil.de_slashes(string3) + "/lock-db/" + string4;
        }
        xmlNode2.addChild("lockdb", string, "", 0, true);
        if (n == -1) {
            xmlNode2.addChild("minlocktimeout", "infinity", "", 0, true);
        } else {
            xmlNode2.addChild("minlocktimeout", Integer.toString(n), "", 0, true);
        }
        xmlNode2.addChild("maxxmlrequestbodysize", Integer.toString(n2), "", 0, true);
        xmlNode2.addChild("maxpropdepth", string2, "", 0, true);
        xmlNode2.addChild("enabled", Boolean.toString(bl), "", 0, true);
        return xmlNode2;
    }

    public static HashMap getVSDAVMap(String string, String string2, String string3) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string4 = null;
        String string5 = SlashUtil.de_slashes(string) + '/' + string2;
        string4 = string2.equals("https-admserv") ? string5 + "/config/server.xml" : string5 + "/conf_bk/server.xml";
        XmlConfig xmlConfig = new XmlConfig(string4);
        XmlNode xmlNode = xmlConfig.parseConfig();
        XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(xmlNode);
        XmlNode xmlNode2 = xmlNodeWrapper.getClassNode(string3);
        XmlNode[] xmlNodeArray = xmlNodeWrapper.getAllVSNodes(xmlNode2);
        for (int i = 0; i < xmlNodeArray.length; ++i) {
            XmlNode xmlNode3;
            XmlNode xmlNode4 = xmlNodeArray[i];
            String string6 = xmlNode4.findChildNode("id").getValue();
            String string7 = "false";
            Iterator iterator = xmlNode4.iterate("DAV");
            if (iterator.hasNext() && (xmlNode3 = (XmlNode)iterator.next()) != null) {
                string7 = xmlNode3.getString("enabled", null);
            }
            hashMap.put(string6, string7);
        }
        return hashMap;
    }

    public static void configureDAVforVS(String string, String string2, String[] stringArray, boolean[] blArray) {
        Object var4_4 = null;
        String string3 = SlashUtil.de_slashes(string) + '/' + string2;
        String string4 = null;
        string4 = string2.equals("https-admserv") ? string3 + "/config/server.xml" : string3 + "/conf_bk/server.xml";
        int n = 0;
        try {
            XmlConfig xmlConfig = new XmlConfig(string4);
            XmlNode xmlNode = xmlConfig.parseConfig();
            for (n = 0; n < stringArray.length; ++n) {
                DAV.returnDAVNodeforVS(xmlNode, string3, string2, stringArray[n], blArray[n], false);
            }
            MiscUtil.writeToServerXML(string3, string, xmlNode, true);
        }
        catch (Exception exception) {
            System.out.println("DAV.returnDAVforVS, vsid : " + stringArray[n] + " --> " + exception.getMessage());
        }
    }

    public static XmlNode returnDAVNodeforVS(XmlNode xmlNode, String string, String string2, String string3, boolean bl, boolean bl2) throws Exception {
        Object object;
        Object object2;
        XmlNode xmlNode2 = null;
        if (xmlNode == null) {
            object2 = null;
            object2 = string2.equals("https-admserv") ? string + "/config/server.xml" : string + "/conf_bk/server.xml";
            object = new XmlConfig((String)object2);
            xmlNode = ((XmlConfig)object).parseConfig();
        }
        if ((object = ((XmlNodeWrapper)(object2 = new XmlNodeWrapper(xmlNode))).getParentClassName(string3)) == null) {
            return null;
        }
        XmlNode xmlNode3 = ((XmlNodeWrapper)object2).getVSNode((String)object, string3);
        if (xmlNode3 != null) {
            Iterator iterator = xmlNode3.iterate("DAV");
            if (iterator.hasNext()) {
                xmlNode2 = (XmlNode)iterator.next();
                XmlNode xmlNode4 = xmlNode2.findChildNode("enabled");
                if (bl2) {
                    return xmlNode2;
                }
                if (xmlNode4 != null) {
                    xmlNode4.setValue(Boolean.toString(bl));
                }
            } else {
                xmlNode2 = new XmlNode(xmlNode3, "DAV", "", "", 0);
                String string4 = SlashUtil.de_slashes(string) + "/lock-db/" + string3;
                xmlNode2.addChild("lockdb", string4, "", 0, true);
                xmlNode2.addChild("minlocktimeout", Integer.toString(0), "", 0, true);
                xmlNode2.addChild("maxxmlrequestbodysize", Integer.toString(8192), "", 0, true);
                xmlNode2.addChild("maxpropdepth", PROP_DEPTH, "", 0, true);
                xmlNode2.addChild("enabled", Boolean.toString(bl), "", 0, true);
                xmlNode3.addChild(xmlNode2);
            }
        }
        return xmlNode2;
    }

    protected void writeToServerXML() throws DAVException {
        try {
            MiscUtil.writeToServerXML(this.instanceDir_, this.rootDir_, this.rootNode_, this.useBackup_);
        }
        catch (Exception exception) {
            throw new DAVException("Error writing to server.xml : " + exception.getMessage());
        }
    }

    private void initialize(String string, String string2, String string3, String string4, int n, int n2, String string5, boolean bl) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("DAV::initialize, Empty server-root directory");
        }
        this.rootDir_ = SlashUtil.de_slashes(string);
        if (this.rootDir_.length() == 0) {
            throw new IllegalArgumentException("DAV::initialize, Empty server-root directory");
        }
        if (string2 != null) {
            this.instanceName_ = string2.trim();
            if (this.instanceName_.length() == 0) {
                throw new IllegalArgumentException("DAV::initalize, Empty server instance name");
            }
        } else {
            throw new IllegalArgumentException("DAV::initalize, Empty server instance name");
        }
        this.instanceDir_ = this.rootDir_ + '/' + this.instanceName_;
        if (string3 != null) {
            this.vsID_ = string3.trim();
            if (this.vsID_.length() == 0) {
                throw new IllegalArgumentException("DAV::initialize, empty VS id");
            }
        } else {
            throw new IllegalArgumentException("DAV::initialize, empty VS id");
        }
        if (string4 != null) {
            this.lockDB_ = string4.trim();
            if (this.lockDB_.length() != 0 && !this.lockDB_.equalsIgnoreCase("default")) {
                this.defaultLockDB_ = false;
            }
        }
        if (this.defaultLockDB_) {
            this.lockDB_ = SlashUtil.de_slashes(this.instanceDir_) + "/lock-db/" + this.vsID_;
        }
        this.minLockTimeout_ = n;
        if (this.minLockTimeout_ != 0) {
            this.defaultLockTimeout_ = false;
        }
        this.rqstBodySize_ = n2;
        this.propDepth_ = string5;
        this.enabled_ = bl;
    }

    private XmlNode getNode(String string) throws DAVException {
        XmlNode xmlNode;
        if (!MiscUtil.isFile(string)) {
            throw new DAVException("DAV:getNode, invalid filename to parse server xml config from");
        }
        if (this.rootNode_ == null) {
            try {
                this.rootNode_ = new XmlConfig(string).parseConfig();
            }
            catch (Exception exception) {
                throw new DAVException("DAV:getNode, Could not parse server.xml");
            }
        }
        XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(this.rootNode_);
        String string2 = xmlNodeWrapper.getParentClassName(this.vsID_);
        this.vsNode_ = xmlNode = xmlNodeWrapper.getVSNode(string2, this.vsID_);
        Iterator iterator = xmlNode.iterate("DAV");
        if (iterator.hasNext()) {
            this.davNode_ = (XmlNode)iterator.next();
            this.davCollections_ = this.getCollections();
        } else {
            this.davNode_ = DAV.createDAVNodeForVS(xmlNode, this.lockDB_, this.minLockTimeout_, this.rqstBodySize_, this.propDepth_, this.enabled_, this.instanceDir_);
            this.davCollections_ = new ArrayList();
        }
        return this.davNode_;
    }

    private boolean contains(DAVCollection dAVCollection) {
        if (this.davCollections_ != null && this.davCollections_.size() != 0) {
            for (int i = 0; i < this.davCollections_.size(); ++i) {
                XmlNode xmlNode = (XmlNode)this.davCollections_.get(i);
                XmlNode xmlNode2 = xmlNode.findChildNode("uri");
                if (!dAVCollection.getURI().equals(xmlNode2.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private List getCollections() {
        ArrayList<XmlNode> arrayList = new ArrayList<XmlNode>();
        Iterator iterator = this.davNode_.iterate("DAVCOLLECTION");
        while (iterator.hasNext()) {
            XmlNode xmlNode = (XmlNode)iterator.next();
            arrayList.add(xmlNode);
        }
        return arrayList;
    }

    public String getLockDB() {
        return SlashUtil.de_slashes(this.lockDB_);
    }

    public int getMinLockTimeout() {
        return this.minLockTimeout_;
    }

    public String getPropDepth() {
        return this.propDepth_;
    }

    public int getRequestSize() {
        return this.rqstBodySize_;
    }

    public boolean enabled() {
        return this.enabled_;
    }

    public XmlNode getDAVNode() {
        return this.davNode_;
    }

    public XmlNode getVSNode() {
        return this.vsNode_;
    }
}

