/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.SlashUtil;
import com.sun.web.admin.util.ValidateUtil;
import com.sun.web.admin.util.XmlNode;
import java.io.IOException;
import java.util.Iterator;

public class JavaConfig {
    private XmlNodeWrapper wrapperXmlNode_ = null;
    private String serverRoot_ = null;
    private String instanceName_ = null;
    private String serverXml_ = null;
    private String javaHome_ = "";
    private String debugEnabled_ = "";
    private String debugOptions_ = "";
    private String classpathSuffix_ = "";
    private String ignoreEnvClasspath_ = "";
    private String nativeLibPathPrefix_ = "";
    private String nativeLibPathSuffix_ = "";
    private String[] jvmOptions_ = null;
    private String profilerEnabled_ = "";
    private String profilerClasspath_ = "";
    private String profilerNativeLibPath_ = "";
    private String[] profilerJVMOptions_ = null;

    public void init(String string, String string2) throws Exception {
        this.serverRoot_ = string.trim();
        this.instanceName_ = string2.trim();
        XmlNode xmlNode = AdminConfig.getInstance(this.serverRoot_, this.instanceName_);
        this.wrapperXmlNode_ = new XmlNodeWrapper(xmlNode);
        this.serverXml_ = this.serverRoot_ + "/" + this.instanceName_ + "/" + "conf_bk" + "/" + "server.xml";
    }

    public void initializeJVMGeneral() {
        XmlNode xmlNode = this.wrapperXmlNode_.getJavaConfigRootNode();
        this.javaHome_ = xmlNode.getString("javahome", "").trim();
        this.debugEnabled_ = xmlNode.getString("debug", "").trim();
        this.debugOptions_ = xmlNode.getString("debugoptions", "").trim();
    }

    public void initializeJVMOptions() {
        XmlNode xmlNode = this.wrapperXmlNode_.getJavaConfigRootNode();
        int n = 0;
        Iterator iterator = xmlNode.iterate("JVMOPTIONS");
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        this.jvmOptions_ = new String[n];
        iterator = xmlNode.iterate("JVMOPTIONS");
        int n2 = 0;
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            this.jvmOptions_[n2] = xmlNode2.getValue();
            ++n2;
        }
    }

    public void initializeJVMPathSettings() {
        XmlNode xmlNode = this.wrapperXmlNode_.getJavaConfigRootNode();
        this.classpathSuffix_ = xmlNode.getString("classpathsuffix", "").trim();
        this.ignoreEnvClasspath_ = xmlNode.getString("envclasspathignored", "").trim();
        this.nativeLibPathPrefix_ = xmlNode.getString("nativelibrarypathprefix", "").trim();
        this.nativeLibPathSuffix_ = xmlNode.getString("nativelibrarypathsuffix", "").trim();
    }

    public void initializeProfiler() {
        XmlNode xmlNode = this.wrapperXmlNode_.getJavaConfigRootNode();
        XmlNode xmlNode2 = this.wrapperXmlNode_.getProfilerNode();
        if (xmlNode2 != null) {
            this.profilerEnabled_ = xmlNode2.getString("enabled", "").trim();
            this.profilerClasspath_ = xmlNode2.getString("classpath", "").trim();
            this.profilerNativeLibPath_ = xmlNode2.getString("nativelibrarypath", "").trim();
            int n = 0;
            Iterator iterator = xmlNode2.iterate("JVMOPTIONS");
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            this.profilerJVMOptions_ = new String[n];
            iterator = xmlNode2.iterate("JVMOPTIONS");
            int n2 = 0;
            while (iterator.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator.next();
                this.profilerJVMOptions_[n2] = xmlNode3.getValue();
                ++n2;
            }
        }
    }

    public String getJavaHome() {
        return this.javaHome_;
    }

    public boolean isDebugEnabled() {
        if (this.debugEnabled_.equals("false") || this.debugEnabled_.equals("off") || this.debugEnabled_.equals("no") || this.debugEnabled_.equals("0")) {
            return false;
        }
        return this.debugEnabled_.equals("true") || this.debugEnabled_.equals("on") || this.debugEnabled_.equals("yes") || this.debugEnabled_.equals("1");
    }

    public String getDebugOptions() {
        return this.debugOptions_;
    }

    public void setJavaHome(String string) {
    }

    public void setDebugEnabled(boolean bl) {
    }

    public void setDebugOptions(String string) {
    }

    public String getClassPathSuffix() {
        return this.classpathSuffix_;
    }

    public boolean isEnvClasspathIgnored() {
        if (this.ignoreEnvClasspath_.equals("false") || this.ignoreEnvClasspath_.equals("off") || this.ignoreEnvClasspath_.equals("no") || this.ignoreEnvClasspath_.equals("0")) {
            return false;
        }
        return this.ignoreEnvClasspath_.equals("true") || this.ignoreEnvClasspath_.equals("on") || this.ignoreEnvClasspath_.equals("yes") || this.ignoreEnvClasspath_.equals("1");
    }

    public String getNativeLibPathPrefix() {
        return this.nativeLibPathPrefix_;
    }

    public String getNativeLibPathSuffix() {
        return this.nativeLibPathSuffix_;
    }

    public String[] getJVMOptions() {
        return this.jvmOptions_;
    }

    public boolean isProfilerEnabled() {
        if (this.profilerEnabled_.equals("false") || this.profilerEnabled_.equals("off") || this.profilerEnabled_.equals("no") || this.profilerEnabled_.equals("0")) {
            return false;
        }
        return this.profilerEnabled_.equals("true") || this.profilerEnabled_.equals("on") || this.profilerEnabled_.equals("yes") || this.profilerEnabled_.equals("1");
    }

    public String getProfilerClasspath() {
        return this.profilerClasspath_;
    }

    public String getProfilerNativeLibPath() {
        return this.profilerNativeLibPath_;
    }

    public String[] getProfilerJVMOptions() {
        return this.profilerJVMOptions_;
    }

    public boolean setJVMGeneralParameters(String string, String string2, String string3) {
        XmlNode xmlNode = this.wrapperXmlNode_.getJavaConfigRootNode();
        if (string != null) {
            this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "javahome", string);
        }
        if (string2 != null) {
            this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "debug", string2);
        }
        if (string3 != null) {
            this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "debugoptions", string3);
        }
        return true;
    }

    public boolean setJVMOptionParameter(String string) {
        XmlNode xmlNode = this.wrapperXmlNode_.getJavaConfigRootNode();
        if (string != null) {
            this.wrapperXmlNode_.updateOrCreateElement(xmlNode, "JVMOPTIONS", string);
        }
        return true;
    }

    public boolean removeJVMOptionParameter(String string) {
        XmlNode xmlNode = this.wrapperXmlNode_.getJavaConfigRootNode();
        if (string != null) {
            this.wrapperXmlNode_.removeElement(xmlNode, "JVMOPTIONS", string);
        }
        return true;
    }

    public boolean setJVMPathSettingsParameters(String string, String string2, String string3, String string4) {
        XmlNode xmlNode = this.wrapperXmlNode_.getJavaConfigRootNode();
        if (string != null) {
            if (!ValidateUtil.isWhitespace(string)) {
                this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "classpathsuffix", SlashUtil.de_slashes(string.trim()));
            } else {
                xmlNode.removeChild("classpathsuffix");
            }
        }
        if (string2 != null) {
            this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "envclasspathignored", string2);
        }
        if (string3 != null) {
            if (!ValidateUtil.isWhitespace(string3)) {
                this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "nativelibrarypathprefix", SlashUtil.de_slashes(string3.trim()));
            } else {
                xmlNode.removeChild("nativelibrarypathprefix");
            }
        }
        if (string4 != null) {
            if (!ValidateUtil.isWhitespace(string4)) {
                this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "nativelibrarypathsuffix", SlashUtil.de_slashes(string4.trim()));
            } else {
                xmlNode.removeChild("nativelibrarypathsuffix");
            }
        }
        return true;
    }

    public boolean setJVMProfilerGeneralParameters(String string, String string2, String string3) {
        XmlNode xmlNode = this.wrapperXmlNode_.getProfilerNode();
        if (xmlNode == null) {
            XmlNode xmlNode2 = this.wrapperXmlNode_.getJavaConfigRootNode();
            XmlNode xmlNode3 = new XmlNode(xmlNode2, "PROFILER", "", "", 0);
            if (string != null && !string.equals("")) {
                xmlNode3.addChild("classpath", string, "", 0, true);
            }
            if (string2 != null && !string2.equals("")) {
                xmlNode3.addChild("nativelibrarypath", string2, "", 0, true);
            }
            xmlNode3.addChild("enabled", string3, "", 0, true);
            xmlNode2.addChild(xmlNode3);
            return true;
        }
        if (string3 != null) {
            this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "enabled", string3);
        }
        if (string != null) {
            if (string.equals("")) {
                xmlNode.removeChild("classpath");
            } else {
                this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "classpath", string);
            }
        }
        if (string2 != null) {
            if (string2.equals("")) {
                xmlNode.removeChild("nativelibrarypath");
            } else {
                this.wrapperXmlNode_.updateOrCreateAttribute(xmlNode, "nativelibrarypath", string2);
            }
        }
        return true;
    }

    public boolean setProfilerJVMOptionParameter(String string) {
        XmlNode xmlNode = this.wrapperXmlNode_.getProfilerNode();
        if (string != null) {
            this.wrapperXmlNode_.updateOrCreateElement(xmlNode, "JVMOPTIONS", string);
        }
        return true;
    }

    public boolean removeProfilerJVMOptionParameter(String string) {
        XmlNode xmlNode = this.wrapperXmlNode_.getProfilerNode();
        if (string != null) {
            this.wrapperXmlNode_.removeElement(xmlNode, "JVMOPTIONS", string);
        }
        return true;
    }

    public boolean removeJVMProfiler() {
        XmlNode xmlNode;
        XmlNode xmlNode2 = this.wrapperXmlNode_.getJavaConfigRootNode();
        if (xmlNode2 != null && (xmlNode = this.wrapperXmlNode_.getProfilerNode()) != null) {
            xmlNode2.removeChild(xmlNode);
        }
        return true;
    }

    public boolean saveXMLConfiguration() throws IOException {
        XmlNode xmlNode = null;
        if (this.wrapperXmlNode_ != null) {
            xmlNode = this.wrapperXmlNode_.getServerRootNode();
        }
        AdminConfig.writeXmlToFile(xmlNode, this.serverRoot_, this.serverXml_);
        return true;
    }
}

