/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.Ciphers;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.ValidateUtil;
import com.sun.web.admin.util.XmlNode;

public class ListenSocket {
    private static final String defaultServerCertNickname_ = "Server-Cert";
    private static final Ciphers defaultSsl2Ciphers = new Ciphers("-rc4,-rc4export,-rc2,-rc2export,-desede3,-des");
    private static final Ciphers defaultSsl3TlsCiphers = new Ciphers("-rsa_rc4_128_sha,+rsa_rc4_128_md5,-rsa_rc4_56_sha,-rsa_rc4_40_md5,+rsa_3des_sha,+rsa_des_sha,-rsa_des_56_sha,-rsa_rc2_40_md5,-rsa_null_md5,-fortezza,-fortezza_rc4_128_sha,-fortezza_null,+fips_3des_sha,-fips_des_sha");
    private XmlNodeWrapper wrapperXmlNode_ = null;
    private String serverRoot_ = null;
    private String instanceName_ = null;
    private String lsId_ = null;
    private XmlNode lsNode_ = null;
    private XmlNode sslNode_ = null;
    private Ciphers ssl2Ciphers_ = null;
    private Ciphers ssl3TlsCiphers_ = null;

    public void init(String string, String string2, String string3) throws Exception {
        this.serverRoot_ = string.trim();
        this.instanceName_ = string2.trim();
        this.lsId_ = string3.trim();
        XmlNode xmlNode = AdminConfig.getInstance(this.serverRoot_, this.instanceName_);
        this.wrapperXmlNode_ = new XmlNodeWrapper(xmlNode);
        this.lsNode_ = this.wrapperXmlNode_.getLSNode(this.lsId_);
        if (this.lsNode_ != null) {
            this.sslNode_ = this.lsNode_.findChildNode("SSLPARAMS");
            if (this.sslNode_ != null) {
                this.ssl2Ciphers_ = new Ciphers(this.sslNode_.getString("ssl2ciphers", null));
                this.ssl3TlsCiphers_ = new Ciphers(this.sslNode_.getString("ssl3tlsciphers", null));
            }
        }
    }

    public boolean exists() {
        return this.lsNode_ != null;
    }

    public String getId() {
        return this.lsId_;
    }

    public String getIp() {
        return this.lsNode_.getString("ip", "any");
    }

    public void setIp(String string) {
        this.lsNode_.setAttribute("ip", string);
    }

    public String getPort() {
        return this.lsNode_.getString("port", "");
    }

    public void setPort(String string) {
        this.lsNode_.setAttribute("port", string);
    }

    public String getFamily() {
        return this.lsNode_.getString("family", "");
    }

    public void setFamily(String string) {
        if (string == null || string.length() < 1) {
            this.lsNode_.removeChild("family");
        } else {
            this.lsNode_.setAttribute("family", string);
        }
    }

    public int getNumAcceptorThreads() {
        int n;
        try {
            n = Integer.parseInt(this.lsNode_.getString("acceptorthreads", "1"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 1;
        }
        return n;
    }

    public void setNumAcceptorThreads(int n) {
        if (n > 0) {
            this.lsNode_.setAttribute("acceptorthreads", Integer.toString(n));
        } else {
            this.lsNode_.removeChild("acceptorthreads");
        }
    }

    public String getServerName() {
        return this.lsNode_.getString("servername", "");
    }

    public void setServerName(String string) {
        this.lsNode_.setAttribute("servername", string);
    }

    public String getDefaultVsId() {
        return this.lsNode_.getString("defaultvs", "");
    }

    public void setDefaultVsId(String string) {
        this.lsNode_.setAttribute("defaultvs", string);
    }

    public boolean isSecurityEnabled() {
        return this.sslNode_ != null && ValidateUtil.isTrue(this.lsNode_.getString("security", "false"));
    }

    public void setSecurityEnabled(boolean bl) {
        if (bl) {
            this.lsNode_.setAttribute("security", "on");
            if (this.sslNode_ == null) {
                this.sslNode_ = this.lsNode_.addChild("SSLPARAMS");
                this.setServerCertNickname(defaultServerCertNickname_);
                this.setSsl2Enabled(false);
                this.setDefaultSsl2Ciphers();
                this.setSsl3Enabled(true);
                this.setTlsEnabled(true);
                this.setDefaultSsl3TlsCiphers();
                this.setTlsRollbackEnabled(true);
                this.setClientAuthEnabled(false);
            }
        } else {
            this.lsNode_.setAttribute("security", "off");
            if (this.sslNode_ != null) {
                this.lsNode_.removeChild(this.sslNode_);
                this.sslNode_ = null;
            }
        }
    }

    public String getServerCertNickname() {
        return this.sslNode_.getString("servercertnickname", defaultServerCertNickname_);
    }

    public void setServerCertNickname(String string) {
        this.sslNode_.setAttribute("servercertnickname", string);
    }

    public boolean isSsl2Enabled() {
        return ValidateUtil.isTrue(this.sslNode_.getString("ssl2", "false"));
    }

    public void setSsl2Enabled(boolean bl) {
        this.sslNode_.setAttribute("ssl2", bl ? "on" : "off");
    }

    public boolean isSsl2CipherEnabled(String string) {
        return this.ssl2Ciphers_.isCipherEnabled(string);
    }

    public boolean enableSsl2Cipher(String string) {
        if (!defaultSsl2Ciphers.isCipherKnown(string)) {
            return false;
        }
        if (!this.ssl2Ciphers_.isCipherEnabled(string)) {
            this.ssl2Ciphers_.enableCipher(string);
            this.sslNode_.setAttribute("ssl2ciphers", this.ssl2Ciphers_.toString());
        }
        return true;
    }

    public boolean disableSsl2Cipher(String string) {
        if (!defaultSsl2Ciphers.isCipherKnown(string)) {
            return false;
        }
        if (!this.ssl2Ciphers_.isCipherDisabled(string)) {
            this.ssl2Ciphers_.disableCipher(string);
            this.sslNode_.setAttribute("ssl2ciphers", this.ssl2Ciphers_.toString());
        }
        return true;
    }

    public void setDefaultSsl2Ciphers() {
        this.sslNode_.setAttribute("ssl2ciphers", "-rc4,-rc4export,-rc2,-rc2export,-desede3,-des");
        this.ssl2Ciphers_ = new Ciphers("-rc4,-rc4export,-rc2,-rc2export,-desede3,-des");
    }

    public boolean isSsl3Enabled() {
        return ValidateUtil.isTrue(this.sslNode_.getString("ssl3", "true"));
    }

    public void setSsl3Enabled(boolean bl) {
        this.sslNode_.setAttribute("ssl3", bl ? "on" : "off");
    }

    public boolean isTlsEnabled() {
        return ValidateUtil.isTrue(this.sslNode_.getString("tls", "true"));
    }

    public void setTlsEnabled(boolean bl) {
        this.sslNode_.setAttribute("tls", bl ? "on" : "off");
    }

    public boolean isSsl3TlsCipherEnabled(String string) {
        return this.ssl3TlsCiphers_.isCipherEnabled(string);
    }

    public boolean enableSsl3TlsCipher(String string) {
        if (!defaultSsl3TlsCiphers.isCipherKnown(string)) {
            return false;
        }
        if (!this.ssl3TlsCiphers_.isCipherEnabled(string)) {
            this.ssl3TlsCiphers_.enableCipher(string);
            this.sslNode_.setAttribute("ssl3tlsciphers", this.ssl3TlsCiphers_.toString());
        }
        return false;
    }

    public boolean disableSsl3TlsCipher(String string) {
        if (!defaultSsl3TlsCiphers.isCipherKnown(string)) {
            return false;
        }
        if (!this.ssl3TlsCiphers_.isCipherDisabled(string)) {
            this.ssl3TlsCiphers_.disableCipher(string);
            this.sslNode_.setAttribute("ssl3tlsciphers", this.ssl3TlsCiphers_.toString());
        }
        return false;
    }

    public void setDefaultSsl3TlsCiphers() {
        this.sslNode_.setAttribute("ssl3tlsciphers", "-rsa_rc4_128_sha,+rsa_rc4_128_md5,-rsa_rc4_56_sha,-rsa_rc4_40_md5,+rsa_3des_sha,+rsa_des_sha,-rsa_des_56_sha,-rsa_rc2_40_md5,-rsa_null_md5,-fortezza,-fortezza_rc4_128_sha,-fortezza_null,+fips_3des_sha,-fips_des_sha");
        this.ssl3TlsCiphers_ = new Ciphers("-rsa_rc4_128_sha,+rsa_rc4_128_md5,-rsa_rc4_56_sha,-rsa_rc4_40_md5,+rsa_3des_sha,+rsa_des_sha,-rsa_des_56_sha,-rsa_rc2_40_md5,-rsa_null_md5,-fortezza,-fortezza_rc4_128_sha,-fortezza_null,+fips_3des_sha,-fips_des_sha");
    }

    public boolean isTlsRollbackEnabled() {
        return ValidateUtil.isTrue(this.sslNode_.getString("tlsrollback", "true"));
    }

    public void setTlsRollbackEnabled(boolean bl) {
        this.sslNode_.setAttribute("tlsrollback", bl ? "on" : "off");
    }

    public boolean isClientAuthEnabled() {
        return ValidateUtil.isTrue(this.sslNode_.getString("clientauth", "false"));
    }

    public void setClientAuthEnabled(boolean bl) {
        this.sslNode_.setAttribute("clientauth", bl ? "on" : "off");
    }
}

