/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.ValidateUtil;
import com.sun.web.admin.util.XmlNode;
import java.util.Arrays;

public class ListenSockets {
    private XmlNodeWrapper wrapperXmlNode_ = null;
    private String servername = null;
    private String[] lslist = null;
    private String[] iplist = null;
    private String[] portlist = null;
    private String[] servernamelist = null;
    private String[] defaultvslist = null;
    private String[] defaultvsclasslist = null;
    private boolean[] securitylist = null;

    public void init(String string, String string2) throws IllegalArgumentException, Exception {
        XmlNode xmlNode = AdminConfig.getInstance(string, string2);
        this.wrapperXmlNode_ = new XmlNodeWrapper(xmlNode);
        XmlNode[] xmlNodeArray = this.wrapperXmlNode_.getAllListenSocketNodes();
        int n = xmlNodeArray != null ? xmlNodeArray.length : 0;
        this.lslist = new String[n];
        this.iplist = new String[n];
        this.portlist = new String[n];
        this.servernamelist = new String[n];
        this.defaultvslist = new String[n];
        this.defaultvsclasslist = new String[n];
        this.securitylist = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.lslist[i] = xmlNodeArray[i].getString("id", "null");
            this.iplist[i] = xmlNodeArray[i].getString("ip", "null");
            this.portlist[i] = xmlNodeArray[i].getString("port", "null");
            this.servernamelist[i] = xmlNodeArray[i].getString("servername", "null");
            this.defaultvslist[i] = xmlNodeArray[i].getString("defaultvs", "null");
            this.defaultvsclasslist[i] = this.wrapperXmlNode_.getParentClassName(this.defaultvslist[i]);
            this.securitylist[i] = this.isSecure(xmlNodeArray[i]);
        }
        this.servername = string2;
        if (this.servername.startsWith("https-")) {
            this.servername = this.servername.substring("https-".length());
        }
    }

    private boolean isSecure(XmlNode xmlNode) throws IllegalArgumentException {
        String string = xmlNode.getString("security", "null");
        return ValidateUtil.isTrue(string);
    }

    public String[] getListenSockets() {
        return this.lslist;
    }

    public String[] getIps() {
        return this.iplist;
    }

    public String[] getPorts() {
        return this.portlist;
    }

    public String[] getDefaultVSList() {
        return this.defaultvslist;
    }

    public String[] getDefaultVSClassList() {
        return this.defaultvsclasslist;
    }

    public boolean[] getSecurityList() {
        return this.securitylist;
    }

    public int getNumSecurityEnabled() {
        int n = 0;
        for (int i = 0; i < this.securitylist.length; ++i) {
            if (!this.securitylist[i]) continue;
            ++n;
        }
        return n;
    }

    public String getSuggestedId() {
        int n;
        String string = "ls";
        int[] nArray = new int[this.lslist.length];
        for (n = 0; n < nArray.length; ++n) {
            if (this.lslist[n].startsWith(string)) {
                try {
                    nArray[n] = Integer.parseInt(this.lslist[n].substring(string.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    nArray[n] = 0;
                }
                continue;
            }
            nArray[n] = 0;
        }
        Arrays.sort(nArray);
        n = 1;
        while (true) {
            for (int i = 0; i < nArray.length && nArray[i] <= n; ++i) {
                if (nArray[i] != n) continue;
                ++n;
            }
            String string2 = string + n;
            if (this.wrapperXmlNode_.isElementIdAvailable("LS", string2)) {
                return string2;
            }
            ++n;
        }
    }

    public String getSuggestedServerName() {
        if (this.servernamelist.length > 0) {
            return this.servernamelist[0];
        }
        return this.servername;
    }
}

