/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.util;

import com.sun.web.admin.util.DTDOrder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class XmlNode {
    private XmlNode root;
    boolean isModified;
    XmlNode parentNode;
    private ArrayList childList;
    private String xmlFile;
    private int lineNo;
    String name;
    String value;
    boolean attrFlag = false;

    public XmlNode() {
        this(null, null, null, null, 0);
    }

    public XmlNode(XmlNode xmlNode, String string, String string2, String string3, int n) {
        this.root = xmlNode;
        this.name = string;
        this.value = string2;
        this.xmlFile = string3;
        this.lineNo = n;
    }

    public boolean isAttr() {
        return this.attrFlag;
    }

    public void setAttr(boolean bl) {
        this.attrFlag = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public XmlNode getParentNode() {
        return this.parentNode;
    }

    public XmlNode getFirstChild() {
        if (this.childList != null && this.childList.size() > 0) {
            return (XmlNode)this.childList.get(0);
        }
        return null;
    }

    public void append(XmlNode xmlNode) {
        if (xmlNode == null || xmlNode.childList == null) {
            return;
        }
        for (int i = 0; i < xmlNode.childList.size(); ++i) {
            XmlNode xmlNode2 = (XmlNode)xmlNode.childList.get(i);
            if (this.childList == null) {
                this.childList = new ArrayList();
            }
            this.childList.add(xmlNode2);
        }
    }

    public XmlNode addChild(String string, String string2, String string3, int n, boolean bl) {
        XmlNode xmlNode = this.addChild(string, string2, string3, n);
        xmlNode.setAttr(bl);
        return xmlNode;
    }

    public XmlNode setAttribute(String string, String string2, String string3, int n) {
        XmlNode xmlNode = this.findChildNode(string);
        if (xmlNode != null) {
            xmlNode.setValue(string2);
            return xmlNode;
        }
        XmlNode xmlNode2 = new XmlNode(this, string, string2, string3, n);
        if (this.childList == null) {
            this.childList = new ArrayList();
        }
        int n2 = 0;
        int n3 = this.childList.size();
        for (n2 = 0; n2 < n3 && ((XmlNode)this.childList.get(n2)).isAttr(); ++n2) {
        }
        if (n2 < n3) {
            this.childList.add(n2, xmlNode2);
        } else {
            this.childList.add(xmlNode2);
        }
        xmlNode2.parentNode = this;
        xmlNode2.setAttr(true);
        return xmlNode2;
    }

    public XmlNode setAttribute(String string, String string2) {
        return this.setAttribute(string, string2, this.xmlFile, this.lineNo);
    }

    public XmlNode addChild(String string, String string2, String string3, int n) {
        XmlNode xmlNode = new XmlNode(this, string, string2, string3, n);
        if (this.childList == null) {
            this.childList = new ArrayList();
        }
        this.childList.add(xmlNode);
        xmlNode.parentNode = this;
        return xmlNode;
    }

    public XmlNode addChild(String string, String string2) {
        return this.addChild(string, string2, this.xmlFile, this.lineNo);
    }

    public XmlNode addChild(String string) {
        return this.addChild(string, null, this.xmlFile, this.lineNo);
    }

    public XmlNode addChild(XmlNode xmlNode) {
        if (this.childList == null) {
            this.childList = new ArrayList();
        }
        String string = xmlNode.getName();
        if (!xmlNode.isAttr()) {
            int n = 0;
            int n2 = this.childList.size();
            for (n = 0; n < n2; ++n) {
                XmlNode xmlNode2 = (XmlNode)this.childList.get(n);
                String string2 = xmlNode2.getName();
                if (!xmlNode2.isAttr() && DTDOrder.precedes(string2, string)) break;
            }
            if (n < n2) {
                this.childList.add(n, xmlNode);
            } else {
                this.childList.add(xmlNode);
            }
        } else {
            this.childList.add(xmlNode);
        }
        xmlNode.parentNode = this;
        return xmlNode;
    }

    public XmlNode removeChild(XmlNode xmlNode) {
        int n;
        if (this.childList == null || xmlNode == null || (n = this.childList.indexOf(xmlNode)) == -1) {
            return null;
        }
        return (XmlNode)this.childList.remove(n);
    }

    public XmlNode removeChild(String string) {
        XmlNode xmlNode = this.findChildNode(string);
        if (xmlNode != null) {
            this.removeChild(xmlNode);
        }
        return xmlNode;
    }

    public void destroy() {
        if (this.childList != null) {
            for (int i = 0; i < this.childList.size(); ++i) {
                ((XmlNode)this.childList.get(i)).destroy();
            }
            this.childList.trimToSize();
            this.childList = null;
        }
        this.parentNode = null;
        this.root = null;
        this.xmlFile = null;
        this.value = null;
        this.name = null;
    }

    public String getString() {
        return this.getValue();
    }

    public XmlNode findConfig(String string) {
        int n;
        int n2 = string.length();
        XmlNode xmlNode = this;
        for (n = 0; n < n2 && string.charAt(n) == '/'; ++n) {
        }
        while (n < n2) {
            int n3;
            for (n3 = n; n3 < n2 && string.charAt(n3) != '/'; ++n3) {
            }
            if (n3 > n && (xmlNode = xmlNode.findChildNode(string.substring(n, n3))) == null) {
                return null;
            }
            for (n = n3; n < n2 && string.charAt(n) == '/'; ++n) {
            }
        }
        return xmlNode;
    }

    public XmlNode findChildNode(String string) {
        int n = this.childList == null ? 0 : this.childList.size();
        for (int i = 0; i < n; ++i) {
            XmlNode xmlNode = (XmlNode)this.childList.get(i);
            if (!xmlNode.name.equals(string)) continue;
            return xmlNode;
        }
        return null;
    }

    private XmlNode findChildNode(String string, String string2) {
        int n = this.childList == null ? 0 : this.childList.size();
        for (int i = 0; i < n; ++i) {
            XmlNode xmlNode = (XmlNode)this.childList.get(i);
            if (!xmlNode.name.equals(string) || xmlNode.value == null || !xmlNode.value.equals(string2)) continue;
            return xmlNode;
        }
        return null;
    }

    public String getString(String string, String string2) {
        XmlNode xmlNode = this.findConfig(string);
        if (xmlNode == null) {
            return string2;
        }
        return xmlNode.getString();
    }

    public int getInt() {
        String string = this.getValue();
        if (string == null || string.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getInt(String string, int n) {
        XmlNode xmlNode = this.findConfig(string);
        if (xmlNode == null) {
            return n;
        }
        return xmlNode.getInt();
    }

    public int getInterval(String string, int n) {
        return this.getInt(string, n);
    }

    public boolean getBoolean() {
        String string = this.getValue();
        if (string == null) {
            return false;
        }
        return !string.equals("false");
    }

    public boolean getBoolean(String string, boolean bl) {
        XmlNode xmlNode = this.findConfig(string);
        if (xmlNode == null) {
            return bl;
        }
        return xmlNode.getBoolean();
    }

    public Object clone() {
        XmlNode xmlNode = new XmlNode(this.root, this.name, this.value, this.xmlFile, this.lineNo);
        if (this.root == this) {
            xmlNode.root = xmlNode;
            xmlNode.parentNode = this.parentNode;
        } else {
            xmlNode.root = this.root;
            xmlNode.parentNode = this.parentNode;
        }
        xmlNode.isModified = false;
        if (this.childList != null) {
            xmlNode.childList = new ArrayList();
            for (int i = 0; i < this.childList.size(); ++i) {
                xmlNode.childList.add(this.childList.get(i));
            }
        }
        return xmlNode;
    }

    public void writexml(PrintWriter printWriter, int n) throws IOException {
        int n2;
        this.writeSpaces(printWriter, n);
        printWriter.print("<" + this.getName());
        int n3 = this.childList == null ? 0 : this.childList.size();
        boolean bl = false;
        boolean bl2 = false;
        if (this.childList != null && n3 == 0) {
            bl = true;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            XmlNode xmlNode = (XmlNode)this.childList.get(n2);
            if (xmlNode.childList == null || xmlNode.childList.size() == 0) {
                if (xmlNode.isAttr()) {
                    if (xmlNode.getValue() != null) {
                        printWriter.print(" " + xmlNode.getName() + "=\"" + xmlNode.getValue() + "\"");
                        continue;
                    }
                    printWriter.print(" " + xmlNode.getName());
                    continue;
                }
                if (!bl2) {
                    bl2 = true;
                    printWriter.println(">");
                }
                this.writeSpaces(printWriter, n + 2);
                if (xmlNode.getValue() != null) {
                    printWriter.println("<" + xmlNode.getName() + ">" + xmlNode.getValue() + "</" + xmlNode.getName() + ">");
                    continue;
                }
                printWriter.println("<" + xmlNode.getName() + "/>");
                continue;
            }
            bl = true;
            break;
        }
        if (!bl && !bl2) {
            printWriter.println("/>");
            return;
        }
        if (!bl2) {
            printWriter.println(">");
        }
        n2 = 0;
        for (int i = 0; i < n3; ++i) {
            XmlNode xmlNode = (XmlNode)this.childList.get(i);
            if (n2 == 0 && (xmlNode.childList == null || xmlNode.childList.size() <= 0)) continue;
            n2 = 1;
            xmlNode.writexml(printWriter, n + 2);
        }
        this.writeSpaces(printWriter, n);
        printWriter.println("</" + this.getName() + ">");
    }

    public void save(PrintWriter printWriter) throws IOException {
        this.save(printWriter, 0);
    }

    private void save(PrintWriter printWriter, int n) throws IOException {
        XmlNode xmlNode;
        int n2;
        this.writeSpaces(printWriter, n);
        printWriter.print("<" + this.getName());
        int n3 = this.childList == null ? 0 : this.childList.size();
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            xmlNode = (XmlNode)this.childList.get(n2);
            if (xmlNode.childList != null && xmlNode.childList.size() != 0) {
                bl = true;
                break;
            }
            printWriter.print(" " + xmlNode.getName() + "=\"" + xmlNode.getValue() + "\"");
        }
        if (!bl) {
            printWriter.println("/>");
            return;
        }
        printWriter.println(">");
        for (n2 = 0; n2 < n3; ++n2) {
            xmlNode = (XmlNode)this.childList.get(n2);
            if (!bl2 && (xmlNode.childList == null || xmlNode.childList.size() <= 0)) continue;
            bl2 = true;
            xmlNode.save(printWriter, n + 2);
        }
        this.writeSpaces(printWriter, n);
        printWriter.println("</" + this.getName() + ">");
    }

    private void writeSpaces(PrintWriter printWriter, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            printWriter.print(' ');
        }
    }

    public String toString() {
        return "[XmlNode " + this.name + " " + this.value + "]";
    }

    public Iterator iterate(String string) {
        return new XmlIterator(string);
    }

    public Iterator iterate() {
        return new XmlIterator();
    }

    class XmlIterator
    implements Iterator {
        int i;
        String key;

        public XmlIterator() {
        }

        public XmlIterator(String string) {
            this.key = string;
            this.findNext();
        }

        private void findNext() {
            if (this.key == null || XmlNode.this.childList == null) {
                return;
            }
            while (this.i < XmlNode.this.childList.size()) {
                XmlNode xmlNode = (XmlNode)XmlNode.this.childList.get(this.i);
                if (xmlNode.name.equals(this.key)) {
                    return;
                }
                ++this.i;
            }
        }

        public boolean hasNext() {
            return XmlNode.this.childList != null && this.i < XmlNode.this.childList.size();
        }

        public Object next() {
            if (XmlNode.this.childList == null || this.i >= XmlNode.this.childList.size()) {
                return null;
            }
            Object e = XmlNode.this.childList.get(this.i);
            ++this.i;
            this.findNext();
            return e;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

