/*
 * Decompiled with CFR 0.152.
 */
package samples.security.jdbcrealm;

import com.iplanet.ias.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.login.LoginException;
import samples.security.jdbcrealm.JDBCRealm;

public class JDBCLoginModule
extends PasswordLoginModule {
    static final String PARAMS_DBDRIVERNAME = "dbdrivername";
    static final String PARAMS_DBURL = "dburl";
    static final String PARAMS_DBUSERNAME = "dbusername";
    static final String PARAMS_DBPASSWD = "dbpasswd";
    static final String PARAMS_USERTABLE = "usertable";
    static final String PARAMS_USERNAMECOL = "usernamecol";
    static final String PARAMS_USERPASSWDCOL = "userpasswdcol";
    static final String PARAMS_USERGROUPCOL = "usergroupcol";
    static Driver _dbdriver = null;
    static Connection _dbConnection = null;

    protected AuthenticationStatus authenticate() throws LoginException {
        if (!(this._currentRealm instanceof JDBCRealm)) {
            throw new LoginException("JDBCLoginModule requires JDBCRealm.");
        }
        String[] stringArray = this.authenticate(this._username, this._password);
        if (stringArray == null) {
            throw new LoginException("Failed JDBC login: " + this._username);
        }
        System.out.println("JDBCRealm login succeeded.");
        return this.commitAuthentication(this._username, this._password, this._currentRealm, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] authenticate(String string, String string2) {
        Object object;
        String[] stringArray;
        String string3 = null;
        String string4 = null;
        JDBCRealm jDBCRealm = (JDBCRealm)this._currentRealm;
        String string5 = jDBCRealm.getRealmProperty(PARAMS_USERTABLE);
        String string6 = jDBCRealm.getRealmProperty(PARAMS_USERNAMECOL);
        String string7 = jDBCRealm.getRealmProperty(PARAMS_USERPASSWDCOL);
        String string8 = jDBCRealm.getRealmProperty(PARAMS_USERGROUPCOL);
        String string9 = "SELECT " + string7 + "," + string8 + " FROM " + string5 + " WHERE " + string6 + " =?";
        Statement statement = null;
        try {
            stringArray = this.getConnection();
            statement = stringArray.prepareStatement(string9);
            statement.setString(1, string);
            object = statement.executeQuery();
            if (object.next()) {
                string3 = object.getString(1).trim();
                string4 = object.getString(2).trim();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        stringArray = null;
        if (string3 != null && string3.equals(string2)) {
            object = new Vector();
            if (string4 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",;");
                while (stringTokenizer.hasMoreTokens()) {
                    ((Vector)object).add(stringTokenizer.nextToken());
                }
            }
            if (((Vector)object).size() > 0) {
                stringArray = new String[((Vector)object).size()];
                ((Vector)object).toArray(stringArray);
                jDBCRealm.setGroupNames(string, stringArray);
            }
        }
        return stringArray;
    }

    private Connection getConnection() throws SQLException {
        Serializable serializable;
        if (_dbConnection != null) {
            return _dbConnection;
        }
        JDBCRealm jDBCRealm = (JDBCRealm)this._currentRealm;
        String string = jDBCRealm.getRealmProperty(PARAMS_DBDRIVERNAME);
        String string2 = jDBCRealm.getRealmProperty(PARAMS_DBURL);
        String string3 = jDBCRealm.getRealmProperty(PARAMS_DBUSERNAME);
        String string4 = jDBCRealm.getRealmProperty(PARAMS_DBPASSWD);
        if (_dbdriver == null) {
            try {
                serializable = Class.forName(string);
                _dbdriver = (Driver)((Class)serializable).newInstance();
            }
            catch (Throwable throwable) {
                throw new SQLException(throwable.getMessage());
            }
        }
        serializable = new Properties();
        ((Properties)serializable).put("user", string3);
        ((Properties)serializable).put("password", string4);
        Connection connection = _dbdriver.connect(string2, (Properties)serializable);
        connection.setAutoCommit(false);
        return connection;
    }
}

