function isAscii(s)
{
    var i, c;

    for(i = 0; i < s.length; i++)
    {
       c = s.charCodeAt(i);
       if(c > 0x7f || c < 0)
       {
          return false;
       } 
    }
    return true;
}

function isWhitespace(s)
{
    var whitespace = " \t\n\r";
    var i,c;

    // Is s empty?
    if (isEmpty(s)) return true;

    // Search through string's characters one by one
    // until we find a non-whitespace character.
    // When we do, return false; if we don't, return true.

    for (i = 0; i < s.length; i++)
    {
       // Check that current character isn't whitespace.
       c = s.charAt(i);

       if (!(whitespace.indexOf(c) != -1 )) return false;
    }

    // All characters are whitespace.
    return true;
}

function isComma(s)
{
    var commachar = ",";
    var i,c;
    for (i = 0; i < s.length; i++)
    {
       // Check that current character isn't comma.
       c = s.charAt(i);

       if (commachar.indexOf(c) != -1 ) return true;
    }
    return false;
}


function hasWhiteSpace(s)
{
    var whitespace = " \t\n\r";
    var i,c;

    // Is s empty?
    if (isEmpty(s)) return true;

    // Search through string's characters one by one
    // until we find a whitespace character.
    // When we do, return true; if we don't, return false.

    for (i = 0; i < s.length; i++)
    {
        // Check that current character is a whitespace.
        c = s.charAt(i);

        if (whitespace.indexOf(c) != -1) return true;
    }

    // no whitespace characters.
    return false;
}

function hasQuotes(s)
{
    var i,c;

    // Is s empty?
    if (isEmpty(s)) return true;

    // Search through string's characters one by one
    // until we find a quote character.
    // When we do, return true; if we don't, return false.

    for (i = 0; i < s.length; i++)
    {
        // Check that current character is a quote.
        c = s.charAt(i);

        if (c == "'" || c == '"') return true;
    }

    // no quotes characters.
    return false;
}

function isEmpty(s)
{
    if (s == null || s.length == 0) return true;
    return false;
}

function trim(textElement) {
    var x = textElement.value;
    while (x.substring(0,1) == ' ') x = x.substring(1);
    while (x.substring(x.length-1,x.length) == ' ') x = x.substring(0,x.length-1);
    textElement.value = x;
}

function isValidId(field, label) {
    var identExp = /^\s*[A-Za-z_]+[A-Za-z0-9_\.\-]*\s*$/;

    if (isEmpty(field)) {
        alert (label + " cannot be empty");
        return false;
    }

    trim(field);

    if( isWhitespace(field.value) || isComma(field.value) )
    {
        alert("Please enter a valid " + label);
        return false;
    }

    if (hasWhiteSpace(field)) {
        alert (label + " cannot have spaces");
        return false;
    }
    if (hasQuotes(field)) {
        alert (label + " cannot have quotes");
        return false;
    }
    if (!isAscii(field)) {
        alert ("Non-Ascii characters are not accepted for " + label);
        return false;
    }
    if ( !((field.value).match(identExp)) ) {
        alert (label + " should be an identifier");
        return false;
    }
    return true;
}

function validateCollectionName(field) {
    return isValidId(field, "Collection name");
}
