/*
 * Every session manager supported by iWS must extend this class
 */

package com.iplanet.server.http.session;

import java.util.Properties;

import javax.servlet.http.*;
import javax.servlet.ServletContext;
import com.iplanet.server.http.util.SrvUtil;
import com.netscape.server.http.session.NSHttpSessionContext;

/**
 * iPlanet Web Server 6.0's session manager base class.
 *
 * @deprecated
 */
public abstract class IWSHttpSessionManager 
    implements NSHttpSessionReaperListener
{
    /**
     * Default session timeout value (30 minutes).
     */
    public static final int DEFAULT_TIMEOUT = 1800;

    /** 
     * is this manager used for FORM-based login sessions?
     */
    public boolean _handleFormLoginSessions = false;

    /**
     * The thread that periodically checks for expired sessions.
     */
    private SessionReaper _reaper = null;

    /**
     * SessionContext is returned by HttpSession.getSessionContext()
     * method.
     *
     * This method is deprecated as of Java Servlet API 2.1 for security 
     * reasons, with no replacement.
     */
    private static NSHttpSessionContext _ctx = new NSHttpSessionContext();
    
    /**
     * Initializes the session manager.
     * 
     * @param props A collection of initialization parameters passed by the 
     *              web server
     */
    public abstract void init(Properties props) throws Exception;

    /**
     * Creates a session with the specified session id. 
     * 
     * @param id       session ID
     *
     * @return  newly-created session
     */
    public abstract HttpSession createSession(String id);

    /**
     * Creates a session with the specified session id. 
     * 
     * @param id       session ID
     * @param  context The context of the web application
     *
     * @return  newly-created session
     */
    public HttpSession createSession(String id, ServletContext context)
    {
        return createSession(id);
    }
    
    /**
     * Delete a specified session
     * 
     * @param session
     * @param  context The context of the web application
     */
    public abstract void deleteSession(HttpSession session);


    /**
     * Request an existing session with the specified session id
     * 
     * @param id       session ID
     * @param  context The context of the web application
     */
    public abstract HttpSession getSession(String id);

    public HttpSession getSession(String id, ServletContext context)
    {
        return getSession(id);
    }

    
    /**
     * Get default session expiration timeout in seconds
     */
    public abstract int getDefaultTimeOut();
    
    /**
     * A method which will be call periodically to let the session manager 
     * expire old sessions
     */
    public abstract void reaper();

    /**
     * Update method will be called by the server at the end of every request 
     * to give the session manager an opportunity to store the session into 
     * reliable storage if needed
     * 
     * @param session  The session object
     * Throws: Exception -- if the session data cannot be updated.
     */
    public void update(HttpSession session)
            throws Exception
    {
        // do nothing
    }
    
    /**
     * Generate random session ID
     * 
     * @return  random unique string which represents random ID
     */
    public  String  generateSID ()
    {
        // ruslan: this is a peace of crap java generator, don't use it
        // return new java.rmi.server.UID ().toString ();
        return SrvUtil.generateSID ();
    }
    
    /**
     * close the session manager -- stop the reaper thread and
     * save any in-memory session data
     */
    public void close()
    {
        stopReaper();
    }

    /**
     * Returns the SessionContext information. 
     *
     * It is used only by <code>HttpSession.getSessionContext</code>.
     *
     * @deprecated  As of Java Servlet API 2.1 for security reasons,
     *              with no replacement. This method will no longer be
     *              needed in the future versions of th API.
     * @return      SessionContext information
     */
    public NSHttpSessionContext getContext()
    {
        return _ctx;
    }

    /**
     * Creates a reaper thread that periodically purges expired sessions
     * from the session manager.
     */
    public void startReaper(Properties config)
    {
        // Start the session reaper
        _reaper = new SessionReaper(config, this);
    }

    /**
     * Stops the reaper thread.
     */
    public void stopReaper()
    {
        if (_reaper != null)
            _reaper.shutdown();
    }

    /**
     * Indicates whether the session manager saves sessions to a 
     * persistent store.
     *
     * Subclasses of this class that DO NOT support persistent sessions must
     * override this method to return false.
     */
    protected boolean hasPersistence()
    {
        return true;
    }

    /**
     * A hook for implementing session-locking semantics for session managers
     * that are multi-process aware.
     */
    protected boolean lock(String id)
    {
        return false;
    }

    /**
     * A hook for implementing session-unlocking semantics for session managers
     * that are multi-process aware.
     */
    public boolean unlock(String id)
    {
        return false;
    }

    /**
     * This method is used by the data-stores to inform the session manager
     * that the specified session has been reaped.
     *
     * It gives the session manager an opportunity to perform cleanup related
     * to the specified session id.
     */
    protected void reaped(String id)
    {
    }

    public void setHandleFormLoginSessions(boolean flag)
    {
        _handleFormLoginSessions = flag;
    }

    public boolean getHandleFormLoginSessions()
    {
        return _handleFormLoginSessions;
    }

    /************************************************************
     * The following methods are useful for doing instrumentation
     */
    public int getMaxSession()
    {
        return 0;
    }
    
    public int getSessionCount()
    {
        return 0;
    }

    public int getSessionReapCount()
    {
        return 0;
    }
}
