/******************************************************************************
 *                                                                            *
 * (c) Copyright 1993, 1994, 1996, 1997, 1999 by Sun Microsystems, Inc.             *
 *                                                                            *
 ******************************************************************************
 *   File:           ModLabel.h                                               *
 *                                                                            *
 *   Description:    Public include file for the label builder                *
 *                                                                            *
 ******************************************************************************/


#pragma ident   "@(#)ModLabel.h 1.13 99/10/26 SMI; TSOL 2.x"
 

#ifndef _ModLabel_h
#define _ModLabel_h

#ifdef __cplusplus
extern "C" {
#endif

#include <tsol/label.h>


/*
 * TS7 NOTE:
 *   Information labels (ILs) are not supported in Trusted Solaris 7 and
 *   later releases. Trusted Solaris software interprets any ILs on
 *   communications and files from systems running earlier releases as
 *   ADMIN_LOW. Objects still have CMW labels, and CMW labels still include
 *   the IL component: IL[SL]; however, the IL component is fixed at ADMIN_LOW.
 *
 *   For details see Intro(1)
 *
 *   Any references to ILs in this header file will be removed in the next
 *   release.
 */


/*
 * CONSTANTS
 */

#define LBUILD_VIEW_INTERNAL 0
#define LBUILD_VIEW_EXTERNAL 1


/* The possible label builder modes */
typedef enum {
    LBUILD_MODE_IL = 10,
    LBUILD_MODE_SL = 11,
    LBUILD_MODE_CMW = 12,
    LBUILD_MODE_CLR = 13
} LBUILD_MODE_VALUES;

/* The extended operations for lbuild */
typedef enum {
    LBUILD_MODE = 1,
    LBUILD_VALUE_SL = 2,
    LBUILD_VALUE_IL = 3,
    LBUILD_VALUE_CMW = 4,
    LBUILD_VALUE_CLR = 5,
    LBUILD_USERFIELD = 6,
    LBUILD_SHOW    = 8,
    LBUILD_TITLE = 9,
    LBUILD_WORK_SL = 10,
    LBUILD_WORK_IL = 11,
    LBUILD_WORK_CMW = 12,
    LBUILD_WORK_CLR = 13,
    LBUILD_X = 14,
    LBUILD_Y = 15,
    LBUILD_UPPER_BOUND = 16,
    LBUILD_LOWER_BOUND = 17,
    LBUILD_CHECK_AR    = 18,
    LBUILD_VIEW = 19,
    LBUILD_CANCEL_HANDLER = 20,
    LBUILD_CANCEL_DATA = 21
} Lbuild_attributes;


/*
 * DATA STRUCTURES
 */

typedef struct _modlabel_data {
    int          mode;                /* label builder mode: il/sl/cmw/clear */
    int          check_ar;            /* do accreditation check on labels */
    int          view;                /* label view: internal/external */
    Bool         show;                /* set True to display the builder */
    char        *userfield;           /* user message string */
    char        *lbuild_title;        /* main window title */
    Position     x;                   /* upper left corner GUI co-ordinates */
    Position     y;
    bslabel_t    sl;                  /* initial input labels to the */
    bilabel_t    il;                  /* builder */
    bclabel_t    cmw;
    bclear_t     clr;
    bslabel_t    sl_work;             /* current values of the labels */
    bilabel_t    il_work;
    bclabel_t    cmw_work;
    bclear_t     clr_work;
    brange_t     range;               /* label range of the builder */
    Widget       lbuild_dialog;       /* public members of the label */
    Widget       ok;                  /* builder GUI: the dilaog box and */
    Widget       cancel;              /* buttons to attach handlers to */
    Widget       reset;
    Widget       help;
    void        *priv_data;           /* user not to modify this private data */
    void       (*event_handler)();    /* callback for ok button */
} ModLabelData, *ModLabelDataPtr;


/*
 * PUBLIC ROUTINES
 */

extern ModLabelData *tsol_lbuild_create(Widget, void(*event_handler)(), ...);
extern void tsol_lbuild_destroy(ModLabelData *);
extern void *tsol_lbuild_get(ModLabelData *,  int);
extern void tsol_lbuild_set(ModLabelData *, ...);


#ifdef __cplusplus
}
#endif


#endif /* _ModLabel_h */
/* DON'T ADD ANYTHING AFTER THIS #endif */
