package Agent::3310JBOD;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $
#  $Id:
use strict;
use Agent::3310;
use base 'Agent::3310';

sub isSelectable {"Sun 3310JBOD"}
sub revision {}

# DO NOT REMOVE THIS COMMENT
# Report::CAT_3310MESSAGE


sub category {Report::CAT_3310JBOD}

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::3310JBOD');
  return $self;
}

sub REPORT {
  my($class, $host, $r, $arg) = @_;

  my($v) = $r->{_value};
  my($out);
  my($tableCnt) = $arg->{tableCnt};
  my($host0) = $host || System->hostname();
  my $comm = ($r->{_status} eq "CC") ? "<font color=red>Communication Lost: Data may be old!</font>" : "";


  $out .= $class->reportHead($v->{'info.product'}, $r);
  my $cnt;
  $out .= "<tr> <td colspan=4><center><b>$v->{'info.Product'} $v->{'info.unique_id'}</td>";
  $out .= "<tr> <td colspan=4><b><center>$comm</td>";
  foreach my $el (sort keys %$v) {
     if ($el =~ /^info\.(.+)/)  {
       my $n = $1;
       next if (index(",manufacturer,model,bootrecord_version,total_disk,top_disk,total_other,Vendor,name,sccli,unique_id,", ",$n,") >= 0);
       next if (index(",Product,revision,total_ctrl,total_logical_drives,total_lun,disk_map,ethernet_status,Device_Type,", ",$n,") >= 0);
       $n =~ s/id_of_//;
       $n =~ s/^total_//;
       $n =~ s/_/ /g;
       $out .= "<tr>" if ($cnt++ % 2 == 0);
       my $v1 = $v->{$el};
       my $le = length($v1);
       if ($le > 20) {
         my $half = int($le/2);
         $v1 = "<small>" . substr($v1,0,$half) . " " . substr($v1,$half);
       }
       $out .= "<td bgcolor=$Style::LIGHT align=right>$n:</td>
                   <td>&nbsp;$v1</td>" if ($v1);
     }
  }
  $out .= "</table>";
  
  # FRUS

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=7><font color=white><b>Frus</td>
    <tr bgcolor=$Style::LIGHT>
        <th>#
        <th>Name
        <th>Vendor/Model/Serial
        <th>Chassis Serial #
        <th>Location
        <th>Rev
        <th>Status
   ";
  my $x;
  foreach my $el (keys %$v) {
    if ($el =~ /fru\.(\w+)\.name/) {
     my $x = $1;
     my $item = $v->{"fru.$x.description"};
     $out .=<<EOF;
        <tr>
              <td>$v->{"fru.$x.idx"}</td>
              <td><small>$item</td>
              <td><small>$v->{"fru.$x.manufacturer_jedec_id"}/ $v->{"fru.$x.part_number"}/ $v->{"fru.$x.serial_number"}</td>
              <td><small>$v->{"fru.$x.chassis_serial_number"}</td>
              <td><small>$v->{"fru.$x.fru_location"}</td>
              <td><center>$v->{"fru.$x.revision"}</td>
              <td><small>$v->{"fru.$x.fru_status"}</td>
EOF
    }
  } 
  $out .= "</table>";

  # component fan, ps

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Enclosure components: fan / power supply</td>
    <tr bgcolor=$Style::LIGHT>
        <th>index 
        <th>Unit
        <th>type
        <th>part number
        <th>serial number
        <th>status
   ";
  for ($x=1; $x <= 100; $x++) {
     last if (!$v->{"enclosure.component.$x.type"});
     last if (( $v->{"enclosure.component.$x.type"} =~ /temp/) || ($v->{"enclosure.component.$x.type"} =~ /disk/ ));
     $out .=<<EOF;
        <tr>
              <td>$x</td>
              <td><small>$v->{"enclosure.component.$x.unit"}</td>
              <td><small>$v->{"enclosure.component.$x.type"}</td>
              <td><small>$v->{"enclosure.component.$x.fru-pn"}</td>
              <td><small>$v->{"enclosure.component.$x.fru-sn"}</td>
              <td><small>$v->{"enclosure.component.$x.status"}</td>
EOF
  }
  $out .= "</table>";

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=7><font color=white><b>Enclosure components: temperature sensor</td>
    <tr bgcolor=$Style::LIGHT>
        <th>index
        <th>Unit
        <th>type
        <th>value
        <th>part number
        <th>serial number
        <th>status
   ";
  for ($x=1; $x <= 100; $x++) {
     last if (!$v->{"enclosure.component.$x.type"});
     if ( $v->{"enclosure.component.$x.type"} =~ /temp/) {
       $out .=<<EOF;
        <tr>
              <td>$x</td>
              <td><small>$v->{"enclosure.component.$x.unit"}</td>
              <td><small>$v->{"enclosure.component.$x.type"}</td>
              <td><small>$v->{"enclosure.component.$x.temp"}</td>
              <td><small>$v->{"enclosure.component.$x.fru-pn"}</td>
              <td><small>$v->{"enclosure.component.$x.fru-sn"}</td>
              <td><small>$v->{"enclosure.component.$x.status"}</td>
EOF
    }
  }
  $out .= "</table>";

   $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=7><font color=white><b>Enclosure components: disk slot</td>
    <tr bgcolor=$Style::LIGHT>
        <th>index
        <th>Unit
        <th>type
        <th>addr
        <th>LED 
        <th>serial number
        <th>status
   ";
  for ($x=1; $x <= 100; $x++) {
     last if (!$v->{"enclosure.component.$x.type"});
     if ( $v->{"enclosure.component.$x.type"} =~ /disk/) {
       my $status;
       if ($v->{"enclosure.component.$x.status"} =~ /Absent/i) {
          $status = "Disk Absent";
       } else {
          $status =  $v->{"enclosure.component.$x.status"};
       }

       $out .=<<EOF;
        <tr>
              <td>$x</td>
              <td><small>$v->{"enclosure.component.$x.unit"}</td>
              <td><small>$v->{"enclosure.component.$x.type"}</td>
              <td><small>$v->{"enclosure.component.$x.addr"}</td>
              <td><small>$v->{"enclosure.component.$x.led"}</td>
              <td><small>$v->{"enclosure.component.$x.fru-sn"}</td>
              <td><small>$status</td>
EOF
    }
  }


  $out .= "</table>&nbsp;<p>&nbsp;<p>";


  return $out;
}
1;
