package Agent::EMAILMESSAGE;
#<copyright>

# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Name:  $ 
#  $Id: EMAILMESSAGE.pm,v 1.2 2004/05/20 17:05:03 ccadieux Exp $

use strict qw(vars);
use State;
use PDM::Parse;
use Report;
use Agent;
use base 'Agent';
use Policies;
use Modules;

sub isSelectable { 0 }
sub revision     { '$Revision: 1.2 $'}
sub type         { Report::CAT_EMAILMESSAGE }
sub diskTotal    { 9    }

use vars qw( $ERR %FOUND %SAM_MAP @SAM_SEV);

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::EMAILMESSAGE');
  return $self;
}

sub RUN {
   my($agent, $static_list) = @_;
   my($err_lines, $warn_lines,  $out,$device, $connect_errs);
   my($report ,  $id, $lines, $log_err, $type);

   $DB::single = 1;
   my $type = uc($agent->type());
 
   my $processed_list = [];
 
   my $renv     = System->get_renv();
   my $logf     = $renv->{email_logfile} || "/var/adm/messages.email";
   my $warn_lines = [];
   my (%UIDS, $ISP, $read);

   my $email_modules = Modules->load("EmailMessage");
   foreach my $m (@$email_modules) {
      my $m = "EmailMessage::$m";
      my $u = $m->REGISTER();
      if ($u) {
        $UIDS{$m} = $u; $read=1;
      }
   }
   return $processed_list if (!$read); # nobidy registered

   if ($logf && -r $logf) {
       Debug->print1("Executing agent EmailMESSAGE");
       Timelapse->start("email:logfile");
       ($log_err, $lines) = $agent->read_log_file($logf,'NEW', undef, {ignoreContent => 1});  
       Debug->err('CANNOT_READ', $logf) if ($log_err);

       $agent->find_alert(\%UIDS, $lines, $device, \$ISP, $warn_lines);
       Timelapse->stop("email:logfile");
   }
      
   my($name) = $renv->{hostname} || System->hostname();
   if ($#$warn_lines >= 0) {
      $id = {
            deviceName  => System->hostid(),
            active      => "Y",
            logFile     => $logf,
            display     => $name,
            name        => $name, 
            class       => "host",
            category    => Report::CAT_EMAILMESSAGE,
            ip          => "",
         };
      $report->{"id.name"} = $name;
      my $new_rep = Report->new($id, $report , $warn_lines, 
                                Report::STATUS_DONT_SAVE);
      require Health::Message;
      my $broke_list = Health::Message->all_logic($new_rep);

      foreach my $dev (@$broke_list) {
         $dev->{problems} = 2; # broke but not processed yet.
         push(@$processed_list, $dev);
      }
      PDM->saveReport($new_rep);
   }
 
   return $processed_list;
}



############################################################
#                    SUBROUTINES
############################################################

sub find_alert {
  my($agent, $UIDS, $lines, $device, $ISP, $err) = @_;
  my( $level, $name, $no1, $no2, $rest);
  my($m, $year, $date, $comp, $x);
  my($ipno);

  my $Config = PDM::ConfigFile->read();
  my $devs = $Config->devices();
  my (%ACTIVE, %IP, %SAVE);

  my ($comp1, $comp2, %DEV);

  foreach my $d (@$devs) {
     $DEV{$d->{ipno}} = $d;
  }
  my (@messages, $message, $in, $section);

  for ($x = 0; $x <= $#$lines; $x++ ) {
     my $line = $lines->[$x];
     if ($line =~ /<\/MESSAGE>/) {
         push(@messages, $message);

     } elsif ($line =~ /<MESSAGE>/) {
         $message = {}; $section = undef;
         $in = 0;
     } else {
         $line = substr($line,1);
         if ($in) {
            push(@{$message->{CONTENT}}, $line);

         } elsif (!$line) {
            $in = 1;

         } elsif ($line =~ /From (.+)/) {
            my $val = $1;
            $section = "FROM";
            $message->{FROM} = $val;

         } elsif ($line =~ /^([\-\w]+): (.*)/) {
            $section = $1;
            my $val = $2;
            $message->{$section} = $val;

         } elsif ($line) {
            my $line0 = Util->ltrim($line);
            $message->{$section} .= "\n$line0";
         }
     }
  }
  foreach my $message (@messages) {
    foreach my $m (keys %$UIDS) {
      my $uids = $UIDS->{$m};
      foreach my $uid (@$uids) {
         if ($uid->{style} eq 'name_value_content') {
            my $pat = "$uid->{name}\\s*: $uid->{value}";
            my $content = $message->{CONTENT};
            my $x;
            while ($x < 20 && $x < $#$content) {
               if ($content->[$x] =~ /$pat/) {
                  push(@{$SAVE{$m}}, $message);
                  last;
               }
               $x++;
            }
         }
      }
    }
  }

  foreach my $m (keys %SAVE) {
     $m->RUN($SAVE{$m}, $err);
  }

}

1;
