package Agent::EVENTS;
 
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $
#  $Id:
use strict;
use Agent;
use base 'Agent';
use Health::SAN;
use Debug;
use Grid;

sub isSelectable {0}
sub revision {'$Revision: 1.5 $'}

# USED TO ALERT rasagent WHEN SLAVES OR Solutions HAVE a PROBLEM
# run by inspectors and agents

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::EVENTS');
  return $self;
}


sub RUN {
   my($agent, $static_list, $pass ) = @_;
 
   return [] if (Util->findMaster());
   my $Config = System->get_Config();
   $DB::single = 1;
 
   my($ev, $sd, $x, $h, $pertains);
   my($l, $s, $rc, $url, $ed);
 
   my $todo_list = [];
   my $hosts = System->get_configHosts();
   my %H;
   foreach $h (@$hosts) {           # SLAVES
      next if ($h->{dh} eq "Y");
      $H{$h->{hostname}} = $h;
   }
   my $DIR = System->get_home() . "/DATA/Events";
   opendir(D, $DIR);
   my @F = readdir(D); closedir(D);

   foreach my $f (@F) {             # Solutions 
      next if (substr($f,-4) ne "push");
      my $file = substr($f,0,-5);
      my $dev;
      if ($H{$file}) {
        my $ho = PDM::ConfigFile->hostAsDevice($H{$file});
        $ho->{problems} = 2; # not processed yet
        push(@$todo_list, $ho);
 
      } elsif ($dev = $Config->deviceByKey($file)) {
        $dev->{problems} = 2;
        push(@$todo_list, $dev);
        unlink "$DIR/$file.push";
      }
   }

   
   return $todo_list;
}
 
 
 
1;
