package Agent::INRANGE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: INRANGE.pm,v 1.9 2004/05/10 23:50:39 gkirton Exp $

use strict;
use Agent::SWITCH_Parent;
use base 'Agent::SWITCH_Parent';
use Net::Telnet;
use Agent::SWITCH;
use Util;
#  Report::CAT_SWITCH2

sub isSelectable {"Inrange Switch"}
sub revision     {'$Revision: 1.9 $'}

sub HEALTH {
  my($agent, $new_rep) = @_;
  require Health::INRANGE;
  Health::INRANGE->all_logic($new_rep);
}

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::INRANGE');
  return $self;
}
use vars qw($ERR);


sub getDevStatus {
  my($class, $dev) = @_;
  my %R;

  $ERR = $class->getLinks($dev, \%R);
  $ERR = $class->getPortStatus($dev, \%R);
  return ($ERR, \%R);
}


sub getLinks {
  my($class, $dev, $R) = @_;
  my($x, $err, $ports, $rem);
  my $DIR  = System->get_home() . "/snmp/bin";
  my $MIBDIR  = System->get_home() . "/snmp/share/snmp/mibs";
  my $renv  = System->get_renv();
  my $TO  = $renv->{'timeout.snmp'} + 45 || 60;
  my $wwn = $dev->{wwn};
  my $mibwwn = Util->wwn2mib($wwn);
  my $public = $renv->{'snmp.community'} || "public";
 
  my $OPT = "-v1 -c$public -t$TO -r1 -M$MIBDIR -mall " . System->snmpopt() . "b";
  ($err,$ports) = Util->run_command(
                 "$DIR/snmpwalk $OPT $dev->{ipno} connUnitNumports", 
                 "sanbox_version.txt", 2*$TO+5);

  foreach my $l (@$ports) {
      if ($l =~ /$mibwwn/) {
         my(@a) = split(/ +\= */, $l);
         $R->{"port.count"} = $a[1];
         last;
      }
  }

  ($err,$rem) = Util->run_command(
                 "$DIR/snmpwalk $OPT $dev->{ipno} connUnitLinkPortNumberX", 
                 "sanbox_version.txt", 2*$TO+5);
  my @PORTS;
  foreach my $l (@$rem) {
     $l =~ /connUnitLinkPortNumberX.*\.(\d+) =\s+(.*)/;
     my $x = lc($2);
     my $wwnindex = $1;
     $x =~ s/ //g;
     if ($l =~ /$mibwwn/) {
         $PORTS[$wwnindex] = $x-1;
     }
  }

  ($err,$rem) = Util->run_command(
                 "$DIR/snmpwalk $OPT $dev->{ipno} connUnitLinkPortWwnY", 
                 "sanbox_version.txt", 2*$TO+5);
  foreach my $l (@$rem) {
     $l =~ /connUnitLinkPortWwnY.*\.(\d+) =\s+Hex: (.*)/;
     my $x = lc($2);
     my $wwnindex = $1;
     $x =~ s/ //g;
     if ( defined($PORTS[$wwnindex]) ) {
        $R->{"port." . $PORTS[$wwnindex] . ".link_wwn"} = substr($x,0,16);
     }
  }
}

sub getSensors {
  my($class, $dev, $R, $mibwwn) = @_;

  my $DIR    = System->get_home() . "/snmp/bin";
  my $MIBDIR    = System->get_home() . "/snmp/share/snmp/mibs";
  my $renv   = System->get_renv();
  my $TO     = $renv->{'timeout.snmp'} + 45;
  my ($err0, $sensors);
  my $ip     = $dev->{ip};
  my(@MAP, $max, %CNT);
  my $public = $renv->{'snmp.community'} || "public";
  my $OPT    = "-v1 -c$public -r1 -t$TO -M$MIBDIR -mall " . System->snmpopt() . "b";

   foreach my $el ('Type','Status','Name') {
    ($err0,$sensors) = Util->run_command("$DIR/snmpwalk $OPT $ip connUnitSensor$el",
                      "sanbox_version.txt", 2*$TO+5);

    if ($err0 || $#$sensors < 0) {
       Debug->errNoRepeat( SNMP_SENSOR => $dev->{name} , 8, "$err0: connUnitSensor$el");
    }

    foreach my $x (@$sensors) {
       next if ($x !~ /$mibwwn/);
       $x =~ /(.*)\.(\d+) = (.*)/;
       my $name = $1;
       my $ix   = $2;
       my $val  = $3;
       $val =~ s/"//g;
       my $i = index($val,"(");
       $val = substr($val,0,$i) if ($i > 0);
       if ($el eq "Type") {
          $CNT{$val}++;
          $MAP[$ix] = "$val." . $CNT{$val};
       } else {
          my $ix2 = $MAP[$ix];
	  my $el1 = lc($el);
          $R->{"sensor.$ix2.$el1"} = $val;
          $max = $ix if ($ix > $max);
       }
    }
  }

  $R->{"sensor.count"} = $max;




}
sub getPortStatus {
  my($class, $dev, $R) = @_;
  my($x);
  my $DIR   = System->get_home() . "/snmp/bin";
  my $MIBDIR   = System->get_home() . "/snmp/share/snmp/mibs";
  my $renv  = System->get_renv();
  my $TO    = $renv->{'timeout.snmp'} + 45 || 60;
  my $wwn   = $dev->{wwn};
  my $mibwwn = Util->wwn2mib($wwn);
  my $public = $renv->{'snmp.community'} || "public";
 
  my $OPT = "-v1 -c$public -t$TO -r1 -M$MIBDIR -mall " . System->snmpopt() . "b";
  my ($err, $ports);
  my $rem;

  ($err,$ports) = Util->run_command(
                 "$DIR/snmpwalk $OPT $dev->{ipno} connUnitNumports", 
                 "inrange.txt", 2*$TO+5);

  foreach my $l (@$ports) {
      if ($l =~ /$mibwwn/) {
         my(@a) = split(/ +\= */, $l);
         $R->{"port.count"} = $a[1];
         last;
      }
  }

  # Get port indexes

#  ($err,$rem) = Util->run_command(
#                 "$DIR/snmpwalk $OPT $dev->{ipno} connUnitPortIndex", 
#                 "inrange.txt", 2*$TO+5);
#  my @PORTS;
#  foreach my $l (@$rem) {
#     $l =~ /connUnitPortIndex.*\.(\d+) =\s+(.*)/;
#     my $x = $2;
#     my $wwnindex = $1;
#     $x =~ s/ //g;
#     if ($l =~ /$mibwwn/) {
#         $PORTS[$wwnindex] = $x;
#     }
#  }
#
#
#  # get port type
#
#  ($err,$rem) = Util->run_command(
#                 "$DIR/snmpwalk $OPT $dev->{ipno} $public connUnitPortType", 
#                 "inrange.txt", 2*$TO+5);
#  foreach my $l (@$rem) {
#     $l =~ /connUnitPortType.*\.(\d+) =\s(.*)/;
#     my $x = lc($2);
#     my $wwnindex = $1;
#     $x =~ s/ //g;
#    my $i = index($x,"(");
#     $x = substr($x,0,$i) if ($i > 0);
#     # Must convert type
#     my($f1, $f2) = split(/-/,$x);
#     $x = uc($f1) . "_Port";
#

#     if ( defined($PORTS[$wwnindex]) ) {
#        $R->{"port." . $PORTS[$wwnindex] . ".type"} = $x;
#     }
#  }


  

  # get port status
  ($err,$rem) = Util->run_command(
               "$DIR/snmpwalk $OPT $dev->{ipno} connUnitPortStatus", 
               "inrange.txt", 2*$TO+5);

  foreach my $l (@$rem) {
    if ($l =~ /$mibwwn/) {
      my($f1, $f2) = split(/ = /, $l);
      my $ix = rindex($f1, ".");
      my $port = substr($f1,$ix+1) - 1;
      my $ix1 = index($f2,"(");
      my $type = $f2;
      $type = substr($f2,0,$ix1) if ($ix1 != -1);

      $R->{"port.$port.state"} = $type;

    }
  }



}


sub getErrStats {
   my($class, $timeout, $ip, $R, $dev, $mibwwn) = @_;

   my $DIR    = System->get_home();
   my $MIBDIR    = System->get_home() . "/snmp/share/snmp/mibs";
   my $renv = System->get_renv();
   my $public = $renv->{'snmp.community'} || "public";
   my $OPT    = "-v1 -c$public -r1 -t$timeout -m$MIBDIR/qlogic/FA.MIB " . System->snmpopt() . "b";

   my $counter;
   foreach $counter('LinkFailures', 'PrimitiveSequenceProtocolErrors', 
                    'InvalidCRC','LossofSynchronization','InvalidTxWords')
   {
      my ($err0,$sensors) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT $ip connUnitPortStatCount$counter", 
                      "inrange.txt", 2*$timeout+5);

      foreach my $l (@$sensors) {
         if($l =~ /$counter.$mibwwn.+\.(.+) = (.+)/)
         {
	    my $port = $1 -1;
	    my $value = $2;
	    $value =~ s/Hex: //;
	    $value =~ s/ //g;
	    if($value =~ /8000000000000000/){
	       # Unsuppported counter
	       $value = 0;
	    }else{
	       $value = hex($value);
	    }

	    $R->{"port.$port.error.$counter"} =  $value;

         }

      }
   }

}

sub NOT_USED_gettransferStats {
   my($class, $timeout, $ip, $R, $dev, $mibwwn) = @_;

   my $DIR    = System->get_home();
   my $MIBDIR    = System->get_home() . "/snmp/share/snmp/mibs";
   my $renv = System->get_renv();
   my $public = $renv->{'snmp.community'} || "public";
   my $OPT    = "-v1 -c$public -r1 -t$timeout -m$MIBDIR/qlogic/FA.MIB " . System->snmpopt() . "b";

   my $counter;
   
   foreach $counter('Class2RxFrames', 'Class3RxFrames','Class2TxFrames', 'Class3TxFrames')
   {
      my ($err,$sensors1) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT $ip connUnitPortStatCount$counter", 
                      "inrange.txt", 2*$timeout+5);

      foreach my $l (@$sensors1) {
         if($l =~ /$counter.$mibwwn.+\.(.+) = (.+)/)
         {
	    my $port = $1 -1;
	    my $value = $2;
	    $value =~ s/Hex: //;
	    $value =~ s/ //g;
	    $value = hex($value);
	    $R->{"port.$port.stats.$counter"} =  $value;
         }
      }
   }
}

sub INSTRUMENTATION {
  my($agent, $device) = @_;
  my(@s, %dev, $in, %info);
  my($connect_err, %C, $err0, $system, $sensors);
  my($port,  $config, $err4);

  return Report->readTest($device) if (System->get_testMode());

  my(%R);
  my $ip     = $device->{ip};
  my(@counts, @stats, $stat, $x);
  my $DIR    = System->get_home() . "/snmp/bin";
  my $MIBDIR    = System->get_home() . "/snmp/share/snmp/mibs";
  my $renv   = System->get_renv();
  my $TO     = $renv->{'timeout.snmp'} + 45;
  my $wwn    = $device->{wwn};
  my $mibwwn = Util->wwn2mib($wwn);
  my $ping_to  = $renv->{'timeout.ping'} || 10;
  $DB::single = 1;
  my $public = $renv->{'snmp.community'} || "public";

  $ENV{LD_LIBRARY_PATH} = System->get_home() . "/snmp/lib";
  my $OPT    = "-v1 -c$public -r1 -t$TO -M$MIBDIR -mall " . System->snmpopt() . "b";

  if (!Util->ping($device->{ipno}, $ping_to)) {
     $R{'rc.error'} = "Cannot ping $device->{ipno}";
     return \%R;
  }
  Timelapse->startDev( $device);

  my ($stderr);
  ($err0,$system, $stderr) = Util->run_command("$DIR/snmpwalk $OPT $ip system", 
                      "inrange.txt", 2*$TO+5);

  if ($stderr =~ /Timeout/) {
     $R{'rc.error'} = $stderr;
     return \%R;
  } elsif ($err0) {
     $R{'rc.error'} = $err0;
     return \%R;
  } elsif ($#$system < 0) {
     $R{'rc.error'} = "No answer from switch at $ip";
     return \%R;
  } elsif ("@$system" =~ /Timeout:/) {
     $R{'rc.error'} = "@$system";
     return \%R;
  }


  foreach my $x (@$system) {
     my(@a) = split(/ +\= */, $x);
     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     $a[1] =~ s/Counter\d\d\://;
     $R{"system.$a[0]"} =  $a[1];
  }


  # Get switch uptime
  my($err8,$uptime) = Util->run_command("$DIR/snmpwalk $OPT $ip sysuptime ", 
                       "inrange.txt", 2*$TO+5);

  foreach my $x (@$uptime) {
     my(@a) = split(/\(/, $x);
     my(@b) = split(/\)/, $a[1]);
     $R{"system.uptime"} =  $b[0];

  }
  #$agent->getErrStats($TO, $ip, \%R, $device, $mibwwn);
  #$agent->getSensors($device, \%R, $mibwwn);
  #$agent->getLinks($device, \%R);
  $agent->getPortStatus($device, \%R);

  if (index("|$renv->{categories}|", "|san|") >= 0) {
  #   $R{"FC_COUNTERS"} = $agent->FCfromDevice($device);
  }

  $agent->addIdentification(\%R);

  $R{"id.wwn"} = $device->{wwn};

  $R{'rc.key'} = $R{"id.wwn"};
  Timelapse->stopDev( $device);
  return \%R;
}



sub DESTROY {}

sub FCfromDevice {
  my($class, $dev) = @_;

  my($db, $VAR1);
  $ERR = undef;
  my $renv = System->get_renv();
  my $rc;
  if ($dev->{host} && ($dev->{host} ne $renv->{hostname} )) {
    $rc = Util::Http->getCommand($dev->{hostIpno},
             "Agent::INRANGE::FC1&telnet=$dev->{telnet}".
                "&wwn=$dev->{wwn}&key=$dev->{key}".
                "&ipno=$dev->{ipno}&HTTP=1&name=$dev->{name}", 
                30);
    $rc = "ERR $Util::Http::ERROR" if (!defined($rc));

    if (substr($rc,0,3) eq "ERR" ) {
      $ERR = $rc;
      return undef;
    } else {
      eval substr($rc,3);
      $ERR = $rc if (!$VAR1);
      return $VAR1;
    }
  } else {
    return &get_FC1($dev);
  }
}

sub ERR {
  return $ERR;
}


#  telnet, ipno, wwn, key, name

sub get_FC1 {
  my($dev) = @_;

  
  my (%X, @R, $x);
  my $renv = System->get_renv();
  my($TO)  = $renv->{'timeout.snmp'} + 45;
  my $public = $renv->{'snmp.community'} || "public";

  my $max = 0;

  my $ip = $dev->{ipno};
  my $DIR    = System->get_home();
  my $MIBDIR = System->get_home() . "/snmp/share/snmp/mibs";
  my $OPT    = "-v1 -c$public -r1 -t$TO -m$MIBDIR/qlogic/FA.MIB " . System->snmpopt() . "b";
  my $wwn = $dev->{wwn};
  my $mibwwn = Util->wwn2mib($wwn);
  my $counter;
   
  # printf("%d.1 = %d\n",port_num, pCounters.LinkFailures[1]);
  # printf("%d.2 = %d\n",port_num, pCounters.LossOfSignal[1]);
  # printf("%d.3 = %d\n",port_num, pCounters.PrimitiveSequenceProtocolErrors[1]);
  # printf("%d.4 = %d\n",port_num, pCounters.InvalidCRC[1]);
  # printf("%d.5 = %d\n",port_num, pCounters.LossOfSynchronization[1]);
  # printf("%d.6 = %d\n",port_num, pCounters.InvalidTxWords[1]);
  # printf("%d.7 = %d\n",port_num, pCounters.TotalRxFrames[1]);
  # printf("%d.8 = %d\n",port_num, pCounters.TotalTxFrames[1]);



   my $fc_no = 1;
   foreach $counter('LinkFailures', 'LossofSynchronization',
                    'PrimitiveSequenceProtocolErrors', 
                    'InvalidCRC','LossofSynchronization','InvalidTxWords')
   {
      my ($err,$sensors1) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT $ip connUnitPortStatCount$counter", 
                      "inrange.txt", 2*$TO+5);

      foreach my $l (@$sensors1) {
         if($l =~ /$counter.$mibwwn.+\.(.+) = (.+)/)
         {
	    my $port = $1 -1;
	    my $value = $2;
	    $value =~ s/Hex: //;
	    $value =~ s/ //g;
	    $value = hex($value);
	    $R[$port][$fc_no] = $value;
	    $max = $port if ($port > $max);

         }
      }
      $fc_no++;
   }

   foreach $counter('Class2RxFrames', 'Class3RxFrames')
   {
      my ($err,$sensors1) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT $ip connUnitPortStatCount$counter", 
                      "inrange.txt", 2*$TO+5);

      foreach my $l (@$sensors1) {
         if($l =~ /$counter.$mibwwn.+\.(.+) = (.+)/)
         {
	    my $port = $1 -1;
	    my $value = $2;
	    $value =~ s/Hex: //;
	    $value =~ s/ //g;
	    if($value =~ /8000000000000000/){
	      # Not supported
	      $value = 0;
	    }
	    $value = hex($value);
	    if($counter =~ /2Rx/){
	       $R[$port][7] = 0;
	    }
	    $R[$port][7] = $value;

	    

         }
      }
   }

   # Transmitted frames is not supported
   foreach $counter('Class2TxFrames', 'Class3TxFrames')
   {
    my ($err,$sensors1);
    #  my ($err,$sensors1) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT $ip connUnitPortStatCount$counter", 
    #                  "inrange.txt", 2*$TO+5);

      foreach my $l (@$sensors1) {
         if($l =~ /$counter.$mibwwn.+\.(.+) = (.+)/)
         {
	    my $port = $1 -1;
	    my $value = $2;
	    $value =~ s/Hex: //;
	    $value =~ s/ //g;
	    $value = hex($value);
	    if($value =~ /8000000000000000/){
	      # Not supported
	      $value = 0;
	    }
	    if($counter =~ /2Tx/){
	       $R[$port][8] = 0;
	    }

	    $R[$port][8] = "Not Supported";
         }
      }
   }

  for ($x=0; $x <= $max; $x++) {
      my $key = "|$dev->{key}|port.$x|switch";
      next if (!defined($R[$x]));

      $X{$key} = ($R[$x][1]+0) . "\t" .
                 ($R[$x][2]+0) . "\t" .
                 ($R[$x][3]+0) . "\t" .
                 ($R[$x][4]+0) . "\t" .
                 ($R[$x][5]+0) . "\t" .
                 ($R[$x][6]+0) . "\t" . 
                 ($R[$x][7]+0) . "\t" . 
                 ($R[$x][8]+0) . "\t";

  }

  my $out = {enc => {$dev->{wwn} => $dev->{name}} , data => \%X };

  if ($dev->{HTTP}) {
require Data::Dumper;
    print "OK " . Data::Dumper::Dumper($out);
  } else {
    return $out;
  }
}





sub FRUS {
  my($class, $r, $name) = @_;
  my($v) = $r->{_value};
  my $devtype = $r->category();
  my $model = $v->{'info.Product'} || $v->{"system.sysDescr"};
  my @FRUS;
  my $rev;
  if (exists($v->{"info.version.PROM_Firmware_Revision"})) {
     $rev = $v->{"info.version.PROM_Firmware_Revision"} . "-" . 
            $v->{"info.version.FLASH_Firmware_Revision"};
  } else {
     $rev = $v->{"info.version.Active_Firmware_image"};
  }
  my $type = $v->{"id.device_userLabel"};
  push(@FRUS, [$name, "switch", "switch", $type, "Inrange", $model, " N/A", $rev, " N/A"]);
  return \@FRUS;

}

sub REPORT {
  my($class, $host, $r, $arg) = @_;

  my($out);
  my($tableCnt) = $arg->{tableCnt};
  my($v) = $r->content();

  $out .= $class->reportHead("INRANGE", $r, undef, $v->{"id.connect_errs"});

  my($version) = $v->subset("info.version.");
  my($cnt) =0;
  my $prod = $v->{'info.Product'} || $v->{"system.sysDescr"};
  $out .= "<tr><td colspan=4><center>$prod</td>
    <tr><td align=right bgcolor=$Style::LIGHT>IP :<td colspan=3>&nbsp;$v->{'id.ipno'}</td>\n";
  

  $out .= "<tr><td align=right bgcolor=$Style::LIGHT> WWN :</td>
               <td colspan=3>&nbsp;$v->{'id.device_wwn'}</td>\n";

  $out .= "</table><table border=1 cellspacing=0 width=100% bgcolor=white>";

  my $x;
#  $out .= "<tr bgcolor=$Style::LIGHT><th>Sensor<th>Status</th>";
#  foreach my $el ('board','fan','power-supply') {
#    for ($x = 1; $x <= 20; $x++) {
#       my $name = $v->{"sensor.$el.$x.name"};
#       next if (!$name);
#
#       my $status;
#       $status = $v->{"sensor.$el.$x.status"};
#       $out .= "<tr><td>&nbsp;$name<td>&nbsp;$status</td>\n";
#    }
#  }

  $out .= "</table><table border=1 cellspacing=0 width=100% bgcolor=white>\n";
  if($v->{"port.count"} > 33){
     #$out .= "<tr bgcolor=$Style::LIGHT><th>Port<th>Slot / Port<th>State<th>WWN of Connected Device</th>\n";
     $out .= "<tr bgcolor=$Style::LIGHT><th>Port<th>Slot / Port<th>State</th>\n";

  }else{
     #$out .= "<tr bgcolor=$Style::LIGHT><th>Port<th>State<th>WWN of Connected Device</th>\n";
     $out .= "<tr bgcolor=$Style::LIGHT><th>Port<th>State</th>\n";

  }
  my $blade = 0;
  my $blade_port;
  for ($x=0; $x <= $v->{"port.count"}; $x++) {
     my $type   = $v->{"port.$x.type"};
     my $state  = $v->{"port.$x.state"};
     #my $wwn    = $v->{"port.$x.link_wwn"};
     next if (!$state);
     my $bg = "";
     my $abg = "";
     if(!($state =~ "ok")){
        $bg = "bgcolor=#FFFFD0";
     }
     
     if($v->{"port.count"} > 33){
        # show blades -  8 ports/blade
	$blade_port = $x%8;
	if($blade_port == 0){
	   $blade++;
	   if($blade == 5){
	     # blade 5 is CPU
	     $blade++;
	   }
	}
	#$out .= "<tr><td>&nbsp;$x<td>$blade - $blade_port<td $bg>&nbsp;$state<td>&nbsp;$wwn</td>\n";
	$out .= "<tr><td>&nbsp;$x<td>$blade - $blade_port<td $bg>&nbsp;$state</td>\n";


     }
     else{
        #$out .= "<tr><td>&nbsp;$x<td $bg>&nbsp;$state<td>&nbsp;$wwn</td>\n";
	$out .= "<tr><td>&nbsp;$x<td $bg>&nbsp;$state</td>\n";

     }
  }

  if (!$tableCnt) {
    $out .= "</table>";
  }
  return $out;

}



sub REPORT2 {
  my($class, $host, $r, $arg) = @_;

  my($out);
  my($v) = $r->{_value};

  my $last;
  $out = $class->reportHead("Inrange Switch", $r);
  foreach my $el (sort keys %$v) {
     my($a, $b) = split(/\./, $el);
     if ($a ne $last) {
        $out .= "<tr bgcolor=$Style::LIGHT><td colspan=2>&nbsp;<b>$a</td>\n" if ($a);
        $last = $a;
     }

     $out .= "<tr><td>&nbsp;$el<td>&nbsp;$v->{$el}</td>";
  }
  $out .= "</table>";
  return $out;

}


sub getZones {
  my($class, $DIR, $s_ip, $TO, $V, $dev) = @_;

  #Zoneing is not supported currently
  my($err);
  return $err;

}



1;
