package Agent::SE2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

# MASERATI AS DEVICES

#  $Name:  $ 
#  $Id: SE2.pm,v 1.8 2004/02/27 15:31:46 mckenney Exp $

use Catalog;
use strict;
use Report;
use Agent;
use State;
use Agent::SE;
use base 'Agent::SE';

sub isSelectable { "Sun 6320/6920" }  # used to control rack as device
sub type         { Report::CAT_SE2 }

sub revision     {'$Revision: 1.8 $'}

use vars qw(%N2IP $ERR);

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::SE2');
  return $self;
}

sub FCfromReport {
  my($agent, $dev, $rep) = @_;
  my($x, %X);
  for ($x = 0; $x <= 100; $x++) {
     last if (!exists $rep->{"fcPort.$x.INF"});
     my @t = split(/\:/, $rep->{"fcPort.$x.nodeId"});
     my $y = $x + 1;
     my $k   = "fcPort.$x";
     my $val = $rep->{"$k.LINK"} . "\t" .
                $rep->{"$k.SIG"}  . "\t" .
                $rep->{"$k.SEQ"}  . "\t" .
                $rep->{"$k.CRC"}  . "\t" .
                $rep->{"$k.SYNC"} . "\t" .
                $rep->{"$k.ITW"} ;

     $X{"0|$dev->{key}|port.$t[2]|se2"} = $val;
  }
  return {data => \%X, hba => {}} ;
}





1;
