package  CIM::Mof;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Mof.pm,v 1.2 2004/01/26 20:07:01 ccadieux Exp $

use CIM;
use strict;
use Carp;
use Text::ParseWords;
use Debug;


sub toMof {
  my($this, $sch) = @_;
  my($mof, $class, $itype, $vers, $parent, $cname ) ;
  foreach my $cp (sort keys %$sch) {
     next if (substr($cp,0,1) eq "_");
     my($assoc);
     $class = $sch->{$cp};
     $cname = $cp;
     $itype = $class->[0]{type};
     $parent = $class->[0]{parent};
     $parent = $parent? ": $parent":"";
     $assoc = ",Association" if ($itype eq "A");
     $mof .= "\n";
     $mof .= "[ Type(\"$itype\")$vers$assoc ]\n";
     $mof .= "class $cname $parent\n{\n";
     my($props) = $class->[1];
     foreach my $p (@$props) {
        my($quals, $name, $type, $key, $default, $enum, $array);
        $name = $p->[0];
        $type = $CIM::MAP{$p->[1]} || $p->[1];
        if ($type eq "reference") {
          $mof .= "  $p->[2] REF $name;\n";
        } else { 
          $key = "Key," if ($p->[2]);
          $default = " = \"$p->[3]\"" if ($p->[3]);
          if ($p->[4]) {
            my(@a) = split(/,/, $p->[4]);
            my($x) = join("\",\"", @a);
            $enum = "Value(\"$x\"),";
          }
          if ($key || $enum) {
             $quals = "$key$enum"; chop($quals);
             $quals = "    [ $quals ]\n";
          }
          $array = "[]" if (lc($type) =~ /array/);
          $mof .= "$quals  $type$array $name$default;\n";
        }
     }
     $mof .= "};\n";
  }
  return $mof;
}

1;

use vars qw(@L $POS);

sub fromMof {
  my($this, $file) = @_;
  my($l, $t, $inC, $inQ, $inPQ, %SCHEMA, @PROPS);
  @L = (); $POS= 0;
  my($f1) = $file;
  open(OMOF, $file);
  while ($l = <OMOF>) {
     chop($l);
     push(@L, $l);
  }
  close(OMOF);
  $POS=0;
  $inC = 0; $inQ = 0; $inPQ = 0;
  my($itype) = "";
#  while ($t = nextLine() ) {
#      print join(" ", @$t) . "\n";
#  }
#  return;
  my($cname, $name, $parent, $i, $w0, @q2, $def, @quals);
  my($key) = 0;
  while ($t = nextLine() ) {
      if ($t->[0] eq "class") {
         $cname = $t->[1]; $parent = $t->[3];
         if ($cname !~ /^\w+$/) {
            Debug->print0("CIM:fromMof: Attribute '$cname' include special characters!");
         }
         $inC = 1;
      } elsif ($t->[0] eq "};") {
         $parent = 0 if (!$parent);
         if (!$itype) {
            $itype = "E" if ($cname =~ /NWS_.*Event/);
            } 
         Debug->print0("Error ($POS): No type for $cname") if (!$itype);
         $SCHEMA{$cname} = [{type => $itype, parent => $parent}, [@PROPS]];
         @PROPS = ();
         $parent = $itype = undef;
         $inC = 0;
      } elsif ($t->[0] eq "{") {
         next;

      } elsif ($t->[0] eq "[") {  # qualifiers
         if (!$inC) { # class quals
           for ($i=1; $i <= $#$t; $i++) {
              if ($t->[$i] eq "Association") {
                 $itype = "A";
              } elsif ($t->[$i] eq "Type") {
                 $itype = substr($t->[$i+2],1,-1);
              }
              $i += ($t->[$i+1] eq "(")? 3:1;
           }
         } else { # prop quals
           @quals = ();
           for ($i=1; $i <= $#$t; $i++) {
              if (lc($t->[$i]) eq "key") {
                 $key = 1;
              } else {
                 if ($t->[$i+1] eq "(") {
                   push(@quals, $t->[$i], substr($t->[$i+2],1,-1), "string");
                 } else {
                   push(@quals, $t->[$i], 0, "boolean");
                 }
              }
              $i += ($t->[$i+1] eq "(")? 3:1;
           }
         }
      } else {
         my($ptype) = lc($t->[0]);
         if (CIM->check_type($ptype)) {
           $name = $t->[1];
           if ($t->[2] eq "=") {
              if (substr($t->[3],0,1) eq "\"") {
                $def = substr($t->[3],1,-1);
              } else {
                $def = $t->[3];
              }
           }
           push(@PROPS, [$name, $ptype, $key, $def, [@quals]]);
           @quals = ();

          } elsif (uc($t->[1]) eq "REF") {
           $name = $t->[2];
           push(@PROPS, [$name, "R", $t->[0]] );

         } else {
            Debug->print0("Errors ($POS): invalid type on " . join(" ", @$t) );
         }
         $name = $ptype = $key = $def = undef;
      }
  }
  return \%SCHEMA;
}

#
# all qualifiers on the same line.

sub nextLine {
  my(@q, @q2);
  my($inQ) = 0;
  while ($POS <= $#L) {
     my($l) = $L[$POS];
     $POS++;
     if (substr($l,0,2) eq "//" || substr($l,0,1) eq "#" || $l =~ /^\s*$/) {
         next;
     }
     next if ($l =~ /^ *Qualifier /);
     @q = &parse_line('[\[\]\(\)\{\}\s\;\,]+', 'delimiters', $l);
     foreach my $w (@q) {
        my($w0) = &trim($w);
        if (substr($w0,0,1) eq "\"" && substr($q2[$#q2],0,1) eq "\"") {
           chop($q2[$#q2]);
           $q2[$#q2] .= " " . substr($w0,1);
        } else {
           push(@q2, $w0) if ($w0 !~ /^\s*$/);
        }
     }
     if (substr($q2[$#q2],-1) eq "]") {
        $inQ = 0;
        return \@q2;
     }
     next if ($inQ);
     if ($q2[0] eq "[") {
        $inQ = 1;
        next;
     }
     return \@q2;
  }
  return undef;
}

sub trim {
  my($s) = @_;
  my($left);

  $s =~ /^( *)/;
  $left = length($1);
  $s =~ /( *)$/;
  substr($s,$left,length($s) - length($1) - $left);
}


