package Cache;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use Util;
use System;
use Data::Dumper;
$CACHE = undef;

sub _load {
  my($class, $cat) = @_;
  my($VAR1);
  if (!$CACHE->{$cat}) {
     my $file = System->get_home() . "/DATA/cache_$cat";
     if (open(CACHER, $file)) {
       @x = <CACHER>;
       eval "@x";
       $CACHE->{$cat} = $VAR1;
       close(CACHER);
     } else {
       $CACHE->{$cat} = {};
     }
  }
}
   
#
#  $var = Cache->read2("cacheX");
#  $var->{save1} = "val1"; ...
#  ...
#  Cache->save2("cacheX");
#

sub read2 {
  my($class, $cat, $name) = @_;
  $class->_load($cat);
  if (!exists $CACHE->{$cat}{$name}) {
    $CACHE->{$cat}{$name} = {};
  }
  return $CACHE->{$cat}{$name};
}

sub save2 {
  my($class, $cat) = @_;
  $class->_save($cat);
}
  
  

sub read {
  my($class, $cat, $name) = @_;
  my($x, $VAR1);
  $class->_load($cat);

  
  return $CACHE->{$cat}{$name};
}
 
sub write {
  my($class, $cat, $name, $var) = @_;
  $class->_load($cat);
  $CACHE->{$cat}{$name} = $var;
  $class->_save($cat);
}
  
  

sub _save {
  my($class, $cat) = @_;

  if ($CACHE) {
     my $file = System->get_home() . "/DATA/cache_$cat";
     open(CACHEO, ">$file");
     $Data::Dumper::Indent = 1;
     print CACHEO Dumper($CACHE->{$cat});
     close(CACHEO);
     chmod 0664, $file;
  }
}


#
# read if var is missing, otherwise write
#
sub cache {
  my($class, $cat, $name, $var) = @_;
  $class->_load($cat);

  if ($var) {
     $CACHE->{$cat}{$name} = $var;
     $class->_save($cat);
  } else {
     return $CACHE->{$cat}{$name};
  }
  return $var;
}



1;


__END__

=head1 NAME

Cache.pm - Simplistic cache package using a file in DATA/cache_*


=head1 SYNOPSIS

 use Cache;

 Cache->write("cache_type", "key", "value");

 $value = Cache->read("cache_type", "key");

 Cache0->cache("cache_type", 'key', ['value']) ; # read or write



=head1 METHODS

=over 4

=item write()

Used to save a value in the cache "cache_type" at 'key'. Arbitrary data structure can
be saved.

=item read()

Used to read a value in the cache "cache_type" at 'key'.

=back 4



=head1 DESCRIPTION

This module can be used to save arbitrary data in a serialize perl file in DATA/cache_*
. Should be used when the data is not too big since there is no hashing. 
This package is old and used only in GUI.pm GUI/Test.pm, GUI/Scripts.pm and AutoForm.pm.





=cut
