package Client::Alarm;
use Client;
use strict;
use Events;
use Debug;
use Util;
use State;

use Data::Dumper;

# Client::Alarm::setNote&key=t3:serial&topic=<topic>&note=<text>
#
sub setNote {
  my($q) = @_;
  my $key   = $q->{key};
  my $topic = $q->{topic};
  my $note  = $q->{note};

  my $State = State->read();
  my $Comp  = $State->hash();

  if (!exists $Comp->{$key}) {
       print Client->error("xml", 210, "Alarm not found for $key");
       return;
  }
  my $el = $Comp->{$key};
  if (!exists $el->{$topic}) {
       print Client->error("xml", 211, "Alarm not found for $key:$topic");
       return;
  }
  State->note($Comp, $key, $topic, $note);

  print Client->http_OK();
  print "<ALARM>A note was added to Alarm $key:$topic</ALARM>\n";
}

#
# Un-Acknowledge an alarm
#
sub nackAlarm {
  my($q) = @_;
  $q->{nack} = 1;
  &ackAlarm($q);
}

# Acknowledge an Alarm.  
# Client::Alarm::ackAlarm&key=t3:serial&topic=<topic>&login=chris
# Example: Client::Alarm::ackAlarm&key=6020:0x301.5405318.402445&topic=loopcard.u2l1.cable
# login is optional

sub ackAlarm {
  my($q) = @_;
  my $key   = $q->{key};
  my $topic = $q->{topic};
  my $login = $q->{login};
  my $State = State->read();
  my $Comp  = $State->hash();
  my $flag  = 1 if (!$q->{nack});

  if (!exists $Comp->{$key}) {
       print Client->error("xml", 210, "Alarm not found for $key");
       return;
  }
  my $el = $Comp->{$key};
  if (!exists $el->{$topic}) {
       print Client->error("xml", 211, "Alarm not found for $key:$topic");
       return;
  }
  State->ack($Comp, $key, $topic, $flag, $login);

  print Client->http_OK();
  print "<ALARM>Alarm $key:$topic is acknowledged</ALARM>\n";

}

#
# Delete an Alarm
#

sub delAlarm {
  my($q) = @_;
  my $key   = $q->{key};
  my $topic = $q->{topic};
  my $login = $q->{login};
  my $State = State->read();
  my $Comp  = $State->hash();
  if (!exists $Comp->{$key}) {
       print Client->error("xml", 210, "Alarm not found for $key");
       return;
  }
  my $el = $Comp->{$key};
  if (!exists $el->{$topic}) {
       print Client->error("xml", 210, "Alarm not found for $key:$topic");
       return;
  }
  State->delete($Comp, $key, $topic);
  print Client->http_OK();
  print "<ALARM>Alarm $key:$topic is deleted</ALARM>\n";

}


# see GUI.EventLog.info

sub GetAlarm {
  my($q) = @_;
  require "Grid.pm";
  my($type, $comp, $ev, $desc, $severity, $code, $title);

  if ($q->{event}) {
    my $event = State->readEvent($q->{event});
    if (!$event) {
       print Client->error("xml", 110, "Event key not found!");
       return;
    }
    my $H     = State->eventHash($event->[4]);

    # handle the sub events
    my $agg = $event->[5];
    my $sub_events;
    my @all_sub_events;
    if ($agg > 1) {
      if ($q->{details} == 1) {
        my $involved;
        require EventDB;
        # last parameter specify mode is XML
        ($involved, $sub_events) = EventDB->sub_events($event->[6], 0, 0, 1);
      }
    }

    my $SUB_EVENT;
    if ($sub_events) {
       $SUB_EVENT =<<EOF;
<SUB_EVENTS>\n$sub_events\n</SUB_EVENTS>
EOF
    }

    $code     = $H->{GridCode};
    $severity = int($event->[0]+0.5);
    $desc     = $event->[1];
    $ev       = Grid->getInfo($type, $comp, {code => $code});
    my $ack   = $event->[7];
    my $ACK;
    if ($ack->{ack}) {
       $ACK =<<EOF;
<ACK>Y</ACK>
<ACK_LOGIN>$ack->{login}</ACK_LOGIN>
<NOTE>$ack->{note}</NOTE>
EOF
    } else {
      $ACK =<<EOF;
<ACK>N</ACK>
<ACK_LOGIN>$ack->{login}</ACK_LOGIN>
<NOTE>$ack->{note}</NOTE>
EOF
    }
    $title    = $H->{TargetName};
    $comp     = $q->{comp};

print <<EOF;
EOF

    print "<ALARM>\n";

    print "<CODE>";
    print $code;
    print "</CODE>";
    print "\n";
    print $ACK;
    print $SUB_EVENT;
    print "<SEVERITY>";
    print $severity;
    print "</SEVERITY>";
    print "\n";

    print "<COMPONENT>";
    print $ev->{comp};
    print "</COMPONENT>";
    print "\n";

    print "<DESC>";
    print $desc;
    print "</DESC>";
    print "\n";

    $ev->{info}   =~ s/\</&lt;/g;
    $ev->{cause}  =~ s/\</&lt;/g;
    $ev->{action} =~ s/\</&lt;/g;

    print "<INFO>";
    print $ev->{info};
    print "</INFO>";
    print "\n";

    print "<PROBABLE_CAUSE>";
    print $ev->{cause};
    print "</PROBABLE_CAUSE>";
    print "\n";

    print "<RECOMMENDED_ACTION>";
    print $ev->{action};
    print "</RECOMMENDED_ACTION>";
    print "\n";

    print "</ALARM>\n";
    print "\n";

  }
}

use vars qw($SEV $TIME1);

sub summary {
  require State;

  if (!$SEV || time - $TIME1 > 60) {
    $SEV = State->sev_summary();
    $TIME1 = time;
  }

  my $date = Util->get_today();
  $SEV->[3]+= 0;
  $SEV->[2]+= 0;
  $SEV->[1]+= 0;

  print "<alarmSummary>\n";
  print " <date>$date</date>\n";
  print " <down>$SEV->[3]</down>\n";
  print " <critical>$SEV->[2]</critical>\n";
  print " <major>$SEV->[1]</major>\n";
  print " <minor>0</minor>\n";
  print "</alarmSummary>";

}

#  Display eventLog information:
#
#  Client::Alarm::eventLog&type=6020&severity=2&key=0x301.5405318.402445&max=1000&eventID=99
#  arguments are optional
#  type : device_type
#  Severity: 1=warning,2=error,3=down,0=informational, default=all
#  key  : device key
#  max  : max number of lines returned, default=1000
#  eventID : for a specify event
#

sub eventLog {
  my($q) = @_;
  
  print Client->http_OK();
  print "<LOG>\n";
  my $F = System->get_home() . "/DATA/Events.log";

  if ($q->{key}) {
    open(O, "/usr/bin/grep \"Enc:$q->{key}\" $F|");
  } elsif ($q->{severity}) {
    open(O, "/usr/bin/grep \"Sev:$q->{severity}\" $F|");
  } else {
    open(O, $F);
  }
  my $max = $q->{max} || 100;
  my $eventID = $q->{eventID} || -9999;
  my $found = 0;

  my($l,$data, $cnt, $date2, $type, $event);
  my($date,$etype,$topic,$desc,$sev,$act,$enc,$mg,$agent,$agg,$ecode);

  while ($l = <O>) {
     $cnt++;
     last if ($cnt > $max);
     chop($l);
     if (substr($l,0,1) eq "L") {
       $data .= substr($l,1) . "\n";
     } else {
       if ($date) {
	 if($eventID != -9999) {
	   if($eventID == $cnt) {
	     &printit($cnt, $date2,$sev,$act,$desc,$ecode,$type,$event,$enc,$topic,$data);
	     $found  = 1;
	     last;
	   }
	 } else {
	   &printit($cnt, $date2,$sev,$act,$desc,$ecode,$type,$event,$enc,$topic,$data);
         }
       }
       $data = "";
       ($date,$etype,$topic,$desc,$sev,$act,$enc,$mg,$agent,$agg,$ecode) = split(/\t/, $l);

       next if (substr($date,0,9) eq "RUN-COUNT");
       ($type, $event) = split(/\./, $etype);

       $sev = substr($sev,4);
       $enc = substr($enc,4);
       next if ($q->{severity} && $sev != $q->{severity});
       next if ($q->{type} && $type ne $q->{type});
       next if ($q->{key} && $enc ne $q->{key});
       $date2 = substr($date,0,4) . "-" . substr($date,4,2) . "-" . substr($date,6,2) . " ".
             substr($date,8,2) . ":" . substr($date,10,2) . ":" . substr($date,12,2);
       $act   = substr($act,7);
       $ecode = substr($ecode,6);
     }
  }
  if($eventID != -9999) {
    if($eventID == $cnt && $found != 1) {
      &printit($cnt, $date2,$sev,$act,$desc,$ecode,$type,$event,$enc,$topic,$data);
    }
  } else {
    &printit($cnt, $date2,$sev,$act,$desc,$ecode,$type,$event,$enc,$topic,$data);
  }
  close(O);
  print "</LOG>\n";
}

sub printit {
 my($cnt, $d,$sev,$act,$desc,$ecode,$type,$event,$enc,$topic,$data) = @_;

   print <<EOF;
 <EVENT ID=\"$cnt\">
   <DATE>$d</DATE>
   <SEVERITY>$sev</SEVERITY>
   <ACTION>$act</ACTION>
   <DESC>$desc</DESC>
   <GRIDCODE>$ecode</GRIDCODE>
   <TYPE>$type</TYPE>
   <EVENT>$event</EVENT>
   <KEY>$enc</KEY>
   <TOPIC>$topic</TOPIC>
   <DATA>$data</DATA>
 </EVENT>
EOF
}


1;

