package Client::EventReport;

use GUI;
use Report;
use System;
use Html::List;
use Reports;
use Reports::Event;
use strict;
use Modules;
use Labels;

sub events {
  my($q) = @_;

  my $LB = Labels->read("GUI::EventReport");

  my $LIST = [
   [ "eventYM.html",   "GUI::EventReport::eventsYmd",  $LB->{report1}],
   [ "eventWeek.html", "GUI::EventReport::eventsWeek", $LB->{report2}],
   [ "eventDOW.html",  "GUI::EventReport::eventsDow",  $LB->{report3}],
    ];
  my $info;
  print Html->body();

  if ($q->{ACTION_new}) {
    Reports::Event->new(1, {actionable => $q->{actionable}} );
    $info= $LB->{report_done};

  } elsif ($q->{ACTION_email}) {
    if ($q->{email}) {
      Reports->email($q, $q->{email}, "Event Report", $LIST);
      $info= "$LB->{email_sent}!<br>";
    } else {
      print Html->error($LB->{email});
    }
    $Html::HEADER2_DONE = 0;
  }
  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/event_report");

  print Html->header2("report.general.event_report");

  my $scr = Html::Screen->new();
  $scr->add("$info <form> <input type=hidden name=GO value=GUI::EventReport::events>");
  $scr->table( { title => $LB->{create} },
   [
   [ f => $LB->{action}, "<input type=checkbox name=actionable>" ],
   [ f => $LB->{last_run}, $date ],
   ]);
  $scr->button2( [
    [ l => 'ACTION_new', $LB->{submit_run} ],
    ]);
 
  $scr->add(Reports->list($q, $LIST, $date));
  $scr->add("</form>");
  print $scr->out();
}

#
# Generate alarm statistics reports
# (so actionable is forced to on).
#
sub generateReports {
  my($q) = @_;
  Reports::Event->new(1, {actionable => "on"} );
  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/event_report");
  print "<REPORT_DATE>$date</REPORT_DATE>\n";
}

#
# Get the date when the statistics reports were generated.
#
sub getReportsDate {
  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/event_report");
  print "<REPORT_DATE>$date</REPORT_DATE>\n";
}
  

#
# Generates alarms (events with action required) 
# statistics by Device Type/ Year-Month
#
sub eventsYmd {
  my($q) = @_;
  my $out = "";

  my $REP = Reports::Event->new();

  # force non interactive mode.
  my ($R, $TOT) = $REP->ymd({ interactive => 0} );

  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/event_report");

  print "<STATISTICS>\n";
  for (my $i=0; $i <= $#$R; $i++) {
    my $el = $R->[$i];
    print "  <REPORT_DATE>$date</REPORT_DATE>\n";
    print "  <STATISTIC>\n";
    print "    <TYPE>".$el->[0]."</TYPE>\n";
    print "    <DATE>".$el->[1]."</DATE>\n";
    print "    <INFO>".($el->[2]+0)."</INFO>\n";
    print "    <MAJOR>".($el->[3]+0)."</MAJOR>\n";
    print "    <CRITICAL>".($el->[4]+0)."</CRITICAL>\n";
    print "    <DOWN>".($el->[5]+0)."</DOWN>\n";
    print "  </STATISTIC>\n";
  }
  print "  <TOTAL>\n";
  print "    <INFO>".$TOT->[0]."</INFO>\n";
  print "    <MAJOR>".$TOT->[1]."</MAJOR>\n";
  print "    <CRITICAL>".$TOT->[2]."</CRITICAL>\n";
  print "    <DOWN>".$TOT->[3]."</DOWN>\n";
  print "  </TOTAL>\n";
  print "</STATISTICS>\n";
}

#
# Generate alarms (events with action required)
# statistics by Device Type/ Year-Week
#
sub eventsWeek {
  my($q) = @_;
  my $out = ""; 

  my $REP = Reports::Event->new();

  # force non interactive mode.
  my ($R, $TOT)   = $REP->week({ interactive => 0} );

  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/event_report");

  print "<STATISTICS>\n";
  for (my $i=0; $i <= $#$R; $i++) {
    my $el = $R->[$i];
    print "  <REPORT_DATE>$date</REPORT_DATE>\n";
    print "  <STATISTIC>\n";
    print "    <TYPE>".$el->[0]."</TYPE>\n";
    print "    <DATE>".$el->[1]."</DATE>\n";
    print "    <INFO>".($el->[2]+0)."</INFO>\n";
    print "    <MAJOR>".($el->[3]+0)."</MAJOR>\n";
    print "    <CRITICAL>".($el->[4]+0)."</CRITICAL>\n";
    print "    <DOWN>".($el->[5]+0)."</DOWN>\n";
    print "  </STATISTIC>\n";
  }
  print "  <TOTAL>\n";
  print "    <INFO>".$TOT->[0]."</INFO>\n";
  print "    <MAJOR>".$TOT->[1]."</MAJOR>\n";
  print "    <CRITICAL>".$TOT->[2]."</CRITICAL>\n";
  print "    <DOWN>".$TOT->[3]."</DOWN>\n";
  print "  </TOTAL>\n";
  print "</STATISTICS>\n";
}

#
# Generate alarms (events with action required)
# statistics by Device Type/ Day of the week
#
sub eventsDow {
  my($q) = @_;
  my $out = "";

  my $REP = Reports::Event->new();
  my $G	 = Labels->read();

  my @DD = split(/,/, $G->{dow});
  my %MAP = (0=>$DD[0], 1=>$DD[1],2=>$DD[2],3=>$DD[3],4=>$DD[4],5=>$DD[5],6=>$DD[6]);

  my ($R, $TOT)   = $REP->dow({ interactive => 0, map => \%MAP } );

  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/event_report");

  print "<STATISTICS>\n";
  for (my $i=0; $i <= $#$R; $i++) {
    my $el = $R->[$i];
    print "  <REPORT_DATE>$date</REPORT_DATE>\n";
    print "  <STATISTIC>\n";
    print "    <TYPE>".$el->[0]."</TYPE>\n";
    print "    <DATE>".$el->[1]."</DATE>\n";
    print "    <INFO>".($el->[2]+0)."</INFO>\n";
    print "    <MAJOR>".($el->[3]+0)."</MAJOR>\n";
    print "    <CRITICAL>".($el->[4]+0)."</CRITICAL>\n";
    print "    <DOWN>".($el->[5]+0)."</DOWN>\n";
    print "  </STATISTIC>\n";
  }
  print "  <TOTAL>\n";
  print "    <INFO>".$TOT->[0]."</INFO>\n";
  print "    <MAJOR>".$TOT->[1]."</MAJOR>\n";
  print "    <CRITICAL>".$TOT->[2]."</CRITICAL>\n";
  print "    <DOWN>".$TOT->[3]."</DOWN>\n";
  print "  </TOTAL>\n";
  print "</STATISTICS>\n";
}

sub all_reports {
  my($q, $R, $TOT, $label1, $REP) = @_;
  
  if (!$q->{SORT}) {
    $q->{SORT} = 1 ; $q->{SIGN} = 1;
  }
  my $LB = Labels->read("GUI::EventReport");

  my($pageInfo, $list) = Html::List->makeList($q, $R,
        [$LB->{dev_type}, $label1,   $LB->{info}, $LB->{warn},$LB->{err}, $LB->{down} ],
        [  'l',         'l',        'r',    'r',     'r',     'r'    ],
        [ '+sn',        '+sn',      '-',    '-',     '-',     '-'    ],
                     {pageSize => 100, interactive => !$q->{email} });

  my $ac = $REP->{action} ? $LB->{act} : $LB->{all} ;

  return $list;

  return "
  <script>
  function openw(a) {
	  var b = '$Http::WEBPROC?GO=GUI::EventReport::details&' + a;
	  var O = window.open(b,'rep','menubar=no,resizable=yes,scrollbars=yes,width=800,height=500');
	  O.focus();
  }
  </script>
  <table border=1 cellspacing=0 cellpadding=0 width=$Style::WIDTH bgcolor=white>
  <tr><td colspan=6><table border=0><tr><td><b>$LB->{title1}/ $label1</b> &nbsp;($ac)</table></td>
    $list
  <tr><td align=right colspan=2>Total:</td> <td align=right><b>$TOT->[0]&nbsp;</td> <td align=right><b>$TOT->[1]&nbsp;</td> <td align=right><b>$TOT->[2]&nbsp;</td> <td align=right><b>$TOT->[3]&nbsp;</td>
  </table>
  <table border=0><tr><td></table>
  <table border=0 width=95%>
    <tr><td>$pageInfo</td>
        <td align=right>
  </table>
  ";
}

sub details {
  my($q) = @_;

  print Html->body();
  my $LB = Labels->read("GUI::EventReport");

  my @SEV = ('INFO','WARN','ERR','DOWN');
  open(O, System->get_home(). "/DATA/tmp/Events.log1");
  my $ym;
  if ($q->{ym}) {
    $ym  = $q->{ym};
    $ym =~ s/-//g;
  }
  my $sev   = "Sev:$q->{sev}"     if (exists($q->{sev}));
  my $type  = "\t$q->{type}\."    if ($q->{type});
  my $yweek = "Yweek:$q->{yweek}" if ($q->{yweek});
  my $dow   = "Dow:$q->{dow}"     if ($q->{dow});
  my ($l,@F);
  while ($l = <O>) {
       next if ($ym   && $l !~ /^$ym/);
       next if ($sev  && index($l, $sev) < 0);
       next if ($type && index($l, $type) < 0);
       next if ($dow  && index($l, $dow) < 0);
       next if ($yweek && index($l, $yweek) < 0);
       push(@F, $l);
  }
  close(O);
  my $title;
  $title  = "$LB->{date}: $ym," if ($ym);
  $title .= " $LB->{sev}: $SEV[$q->{sev}]," if (exists($q->{sev}));
  $title .= " $LB->{type}: $q->{type},"     if (exists($q->{type}));
  $title .= " $LB->{yweek}: $q->{yweek},"   if (exists($q->{yweek}));
  $title .= " $LB->{dow}: $q->{dow},"       if (exists($q->{dow}));
  chop($title) if ($title);

  print "<table border=0 cellpadding=4 cellspacing=0 width=100% bgcolor=white>
  <tr><td>Event List [ $title ] ";
  if ($#F > 200 && !$q->{ALL}) {
    my $list;
    foreach my $e (keys %$q) {
      next if ($e eq "GO");
      $list .= "&$e=$q->{$e}";
    }
    my $l1 = $LB->expand(display => ($#F+1));
    print "<td align=right>$l1 [<a href=/rashttp?GO=GUI::EventReport::details$list&ALL=1>$LB->{display_all}</a>]";
  } else {
    print "<td align=right>" . ($#F+1) . " $LB->{events}</td>";
  }
  print "</table>";
 
  my $header = "</table><table border=1 cellspacing=0 width=100% cellpadding=0 bgcolor=white>
    <tr bgcolor=$Style::LIGHT>
      <td><b>$LB->{date}</td>
      <td><b>$LB->{event}</td>
      <td><b>$LB->{topic}</td>
      <td><b>$LB->{desc}</td>
      <td><b>$LB->{sev}</td>
      <td><b>$LB->{action2}</td>
       ";
  my $cnt = 0;
  foreach my $l (@F) {
	print $header if ($cnt++ % 100 == 0) ;
        last if ($cnt > 200 && !$q->{ALL});
        my($dt, $event, $comp, $desc, $sev, $action, $enc) = split(/\t/, $l);
	$comp =~ s/\./. /g;
	my($cat, $ev) = split(/\./, $event,2);
        my $date = substr($dt,0,4) . "-" . substr($dt,4,2) . "-" . substr($dt,6,2);
	my $time = substr($dt,8,2) . ":" . substr($dt,10,2);
	my $enc = substr($enc,4);
	$sev = $SEV[substr($sev,4)];
	$event =~ s/Event$//;
        $event =~ s/\./. /g;
        print "<tr><td>$date $time<td>$event<td>$comp&nbsp;<td>$desc&nbsp;<td><center>$sev".
	       "<td><center>" . substr($action,7) . "</td>\n";
  }
  print "</table>";
}


1;

