package Client::ExceptionReport;
use Report;
use Reports;
use Reports::Exception;
use System;
use Html::List;
use strict;
use Modules;
use Process;
use Math;
use AdminGroup;

sub RUN {
  my($q) = @_;
  my $F = System->get_home() . "/DATA/tmp/exception_report";
  my $age = Util->getFileAge($F, "h");
  if (!-f $F || $age > 12) {
    my $st = Process->status(undef, "exception_report");
    if ($st =~ /Running/) {
       print "<ERROR>Exception report already running!</ERROR>\n";
    } else {
       Process->start("exception_report");
       Reports::Exception->new(1);
       print "<STATUS>OK</STATUS>\n";
    }
  } else {
    print "<STATUS>OK</STATUS>\n";
  }
}

sub RUNback {
  my($q) = @_;
  my $F = System->get_home() . "/DATA/tmp/exception_report";
  my $age = Util->getFileAge($F, "h");
  #if (!-f $F || $age > 12) {
    my $st = Process->status(undef, "exception_report");
    if ($st =~ /Running/) {
       print "<ERROR>Exception report already running!</ERROR>\n";
    } else {
       my $cpid;
       $SIG{CHLD} = 'IGNORE';
       if (($cpid = fork()) == 0) {
         Process->start("exception_report");
         close STDIN;
         close STDOUT if (!$ENV{FCGI});
         close STDERR;
         Reports::Exception->new(1);
         exit;
       }
    }
  #}
  print "<STATUS>OK</STATUS>\n";
}
     


#
# List the time the exception report was generated
# (if any).
#
sub list {

  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/exception_report");
  my ($archive);

  my $st = Process->status(undef, "exception_report");

  my $dis1 = $st;
  $dis1 .= "..." if ($st =~ /Running/);
  my $last_run = Util->get_file_created(System->get_home() . '/DATA/tmp/exception_report');

  print "<STATUS>\n";
  print "  <LAST_RUN>".$last_run."</LAST_RUN>\n";
  print "  <STATUS_DETAIL>".$st."</STATUS_DETAIL>\n";
  print "</STATUS>\n";

}


use GUI::FruReport;

#
# List an 'exception report' 
# (list of current values and default values).
#
sub config {
  my($q) = @_;
  my $out;
  $out = "";
  if (!$q->{SORT}) {
    $q->{SORT} = 1 ; $q->{SIGN} = 1;
  }
  my $REP = Reports::Exception->new();

  if (! $REP) {
     print "<ERROR>no report</ERROR>";
     return;
  } 

  my @REP1;
  print "<ELEMENTS>\n";
  foreach my $e (@$REP) {
    my $name = $e->[0];
    my $ix = rindex($e->[3],".");
    my $el = $ix > 0 ? $e->[2] . "." . substr($e->[3],0,$ix) : $e->[3];
    next if ($q->{ATTR} && index($e->[3], $q->{ATTR}) < 0);
    print "  <ELEMENT>\n";
    print "    <DEVICE>".$e->[0]."</DEVICE>\n";
    print "    <TYPE>".$e->[1]."</TYPE>\n";
    print "    <FRUTYPE>".$e->[2]."</FRUTYPE>\n";
    print "    <FRU>".$e->[3]."</FRU>\n";
    print "    <DESCRIPTION>".$e->[4]."</DESCRIPTION>\n";
    print "    <CURRENTVALUE>".$e->[5]."</CURRENTVALUE>\n";
    print "    <DEFAULTVALUE>".$e->[6]."</DEFAULTVALUE>\n";
    print "  </ELEMENT>\n";
    push(@REP1, [$e->[0], $e->[1],$el, $e->[4], $e->[5], $e->[6] ]);
  }
  print "</ELEMENTS>\n";

  my $ex = Reports::Exception->read_ex();
  my $sel = "<select name=ATTR><option value=\"\">[ Attribute ]";
  use Data::Dumper;
  my(%EX);
  foreach my $e (sort keys %$ex) {
	  $EX{$ex->{$e}{name}.$e} = $e;
  }
  foreach my $e0 (sort keys %EX) {
	  my $e = $EX{$e0};
	  my $ix = rindex($e, ".");
	  my $e0 = substr($e,$ix+1);
	  my $selected = "selected" if ($q->{ATTR} eq $e0);
	  $sel .= "<option $selected value=\"$e0\">$ex->{$e}{name}</option>\n";
  }
  $sel .= "</select>";

  if ($#$REP < 0) {
     push(@REP1, [ "<b>No Exception found!" ]);
  }

}




1;

