package Client::Health;
use strict;
use Client;
use State;
use System;
use Grid;

# WGET SYNTAX
# wget --proxy=off --http-user=ras --http-passwd=agent 
# "http://ccadieux:7654/rashttp?GO=Client::Health::list"
#
# http://host:7654/rashttp?GO=Client::Health::summary
# XML: one entry per device
# severity: 1=warning/Major,2=error/Critical,3=Down

sub summary {
  my($q) = @_;

  require State;
  my $h = State->getComponentState();
  print Client->http_OK;

  print "<HEALTH_SUMMARY>\n";
  foreach my $key (sort keys %$h) {
     my $el = $h->{$key};
     my $sev = int($el->[0]+0.5);
     my $date = substr($el->[1],0,19);
     my $desc = substr($el->[1],20);
     print "  <DEVICE ID=\"$key\">
     <SEV>$sev</SEV>
     <DATE>$date</DATE>
     <DESC>$desc</DESC>
  </DEVICE>\n";
  }
  print "</HEALTH_SUMMARY>\n";
}
  


sub list {
  my($q) = @_;

  my $state   = State->read();
  my $Comp    = $state->hash();
  my $Config  = PDM::ConfigFile->read();
  my $DevHash = $Config->deviceHash();
  Grid->readCodes();
  

  print Client->http_OK;
  print "#<pre>\n";
  print "# type key name ip topic sev actionable event_type grid_code grid_no description \n";
  print "# wget --proxy=off --http-user=ras --http-passwd=agent \"http://host:7654/rashttp?GO=Client::Health::list\"\n";
  print "# \n";
  

  foreach my $el (keys %$Comp) {
     my $comp = $Comp->{$el};
     my($type, $key) = split(/\:/, $el);
     my $d = $DevHash->{$key};

     foreach my $topic (keys %$comp) {
       my $tc = $comp->{$topic};
       my $sev = int($tc->[0] + 0.5);
       my $details = State->eventHash($tc->[4]);
       my $et = $details->{EventType};
       my $gc = $details->{GridCode};
       my $ac = $details->{Actionable};
       my $gn = Grid->getNo($gc);
       print "$type\t$key\t$d->{name}\t$d->{ipno}\t$topic\t$sev\t$ac\t$et\t$gc\t$gn\t$tc->[1]\n";
     }
  }

}

1;
