package Client::ProcMgr;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Util;
use AutoForm;
use strict;
use Tasks;
use Cache;
use Html::List;
use System;
use Scheduler;
use Client;
use Process;

use vars qw ($TT);
$TT = "ST";

#
# DELETE A JOB
# Client::ProcMgr::delete&id=$pid&type=diag|process..
# id    = host:prefix:pid
# prefix= ST
#
sub delete {
  my($q) = @_;
  my $type = $q->{type}; # diag or process...
  my $D1 = System->get_home() . "/DATA/Proc";

  print Client->http_OK();

  if ($type eq "diag" || index($q->{id}, ":ST:") > 0) {
     my($host, $prefix, $pid) = split(/\:/, $q->{id});    
     Scheduler->delete($prefix, $pid, $host);

  } else {
     my($host, $pid) = split(/\:/, $q->{id});    
     Process->delete($host, $pid);

  }
}

# ARCHIVE A JOB
# id    = host:prefix:pid
# prefix= ST

sub archive {
  my($q) = @_;
  my $type = $q->{type}; # diag or process...
  my $D1 = System->get_home() . "/DATA/Proc";

  print Client->http_OK();

  if ($type eq "diag" || index($q->{id}, ":ST:") > 0) {
     my($host, $prefix, $pid) = split(/\:/, $q->{id});    
     Scheduler->archive($prefix, $pid, $host);

  } else {
     my($host, $pid) = split(/\:/, $q->{id});    
     Process->archive($host, $pid);
  }

}

#
# JOB DETAILS
# Client::ProcMgr::details&id=$pid&type=diag|process..
#
sub details {
  my($q) = @_;
  my $type = $q->{type}; # diag or process...
  my $renv = System->get_renv();
  my $D1 = System->get_home() . "/DATA/Proc";

  print Client->http_OK();

  if ($type eq "diag" || index($q->{id}, ":ST:") > 0) {
      my($hostname, $prefix, $pid) = split(/\:/, $q->{id});    
      next if (!-d "$D1/$hostname");
      my $list = Scheduler->processList($prefix,$hostname);
      foreach my $l (@$list) {
        # test if the pid of the process matches the id passed in
        if ($pid == $l->{pid}) {
          my $info    = $l->{info};
          my $options = Util->ltrim($l->{opts});
          $options = substr($options,2) if (substr($options,0,2)  eq "-o");
          $options =~ s/\|/, /g;
          my $INFO;
          foreach my $el (keys %$info) {
            my $val = $info->{$el};
            $INFO .= "    <" . uc($el) . ">$val</" . uc($el) . ">\n";
          }

          # get the details info (similar to Diag::status)
          # add these to the XML output
          my ($pinfo, $pro, $out, $err) = Scheduler->read($TT, $hostname, $pid);
          my $error;
          my $output;
          my($x, $y);
          for ($x=0; $x <= $#$err; $x++) {
            #print "error.$x.value\t$err->[$x]";
            $error = $error."error.$x.value\t$err->[$x]";
          }
          for ($x=0; $x <= $#$out; $x++) {
            my $rc = $out->[$x]{rc}; chomp($rc);
            #print "$out->[$x]{output}\n";
            $output = $output."$out->[$x]{output}\n";
          }
          my $status = &_status($l);

          print <<EOF;
<DETAILS>
  <ID>$q->{id}</ID>
  <HOST>$hostname</HOST>
  <STATUS>$status</STATUS>
  <OPTIONS>options</OPTIONS>
  <START_DATE>$l->{start_date}</START_DATE>
  <END_DATE>$l->{end_date}</END_DATE>
  <PID>$l->{pid}</PID>
  <ERROR>$error</ERROR>
  <OUTPUT>$output</OUTPUT>
  <INFO>
$INFO  </INFO>
</DETAILS>
EOF
       }
    }
  } else {  # Process
     require Process;
     my($host, $id) = split(/\:/, $q->{id});
     $host = "" if ($host eq $renv->{hostname});
     my $l= Process->details($host, $id);
     my $status = $l->{status};
     my $ix = index($status, "/");
     my $data  = Process->read($host, $id);
     my $trace = Process->trace($host, $id);
     $trace =~ s/</\[/g;
     $trace =~ s/>/\]/g;

     my $INFO;
     if (ref($data) eq "HASH") {
        #$INFO = "<DATA>\n" . &parse_hash($data). "</DATA>";
     }
       
     $status = Util->rtrim(substr($status,0,$ix)) if ($ix > 0);

        print <<EOF;
<DETAILS>
  <ID>$q->{id}</ID>
  <HOST>$host</HOST>
  <STATUS>$status</STATUS>
  <OPTIONS>$l->{status}</OPTIONS>
  <START_DATE>$l->{start}</START_DATE>
  <END_DATE>$l->{end}</END_DATE>
  <PID>$l->{pid}</PID>
  <INFO>
     <DATA>$INFO</DATA>
     <TRACE>$trace
     </TRACE>
  </INFO>
</DETAILS>
EOF
   }
}

sub parse_hash {
  my($data) = @_;
  my $val;

  foreach my $e (keys %$data) {
     if ($e eq "HASH") {
        $val .= &parse_hash($data->{$e});
     } else {
        $val .= "<$e>$data->{$e}</$e>\n";
     }
  }
}

#
# LIST ALL CURRENT PROCESSES 
#
sub list {
  my($q) = @_;
  my( $devs, $hosts,$notifs, $command, $opts, $sel,$local );
  my $renv = System->get_renv();
  my($out, $tag);
  $q->{prefix}  = "StorTools" if (!$q->{prefix});
  my $prefix = uc(substr($q->{prefix},0,2)) || "ST";
  print Client->http_OK();

  my $PLIST = $q->{PLIST}; # process _list

  my $MODE = $q->{MODE};

  my $cnt = 0;
  my $running;
  my(@DATA);
  my $D1 = System->get_home() . "/DATA/Proc";
  opendir(O, $D1);
  my @hd = readdir(O); closedir(O);
  print "<PROCESSES>\n";

  foreach my $hostname (@hd) {
     next if (!-d "$D1/$hostname");
     my $list = Scheduler->processList($prefix,$hostname, 
                             {status => $MODE, plist => $PLIST} );

     foreach my $l (@$list) {
        my $sh   = Util->shortHostname($l->{host});
        my $host = $l->{host};
        my $cmd  = $l->{command};
        my $pid  = $l->{pid};
        my $prefix = $l->{task_type};
        my $pid0  = sprintf("%6.6d", $l->{pid});
        my $status = &_status($l);
        my $start = $l->{start_date};
        my $end   = $l->{end_date};

        $end = substr($end,11) if (substr($start,0,10) eq substr($start,0,10));
        print <<EOF;
   <PROCESS>
     <ID>$host:$prefix:$pid</ID>
     <HOST>$host</HOST>
     <PID>$pid</PID>
     <TYPE>process.diag</TYPE>
     <NAME>$cmd</NAME>
     <START>$start</START>
     <END>$end</END>
     <STATUS>$status</STATUS>
   </PROCESS>
EOF

     }
  }
  require Process;
  my $L2 = Process->list();
  my $host = $renv->{hostname};
  foreach my $p (@$L2) {
     print <<EOF;
  <PROCESS>
    <ID>$host:$p->{id}</ID>
    <HOST>$host</HOST>
    <PID>$p->{pid}</PID>
    <TYPE>process.$p->{id}</TYPE>
    <NAME></NAME>
    <START>$p->{start}</START>
    <END>$p->{end}</END>
    <STATUS>$p->{status}</STATUS>
  </PROCESS>
EOF
  }
  print "</PROCESSES>\n";

}

sub _status {
  my($p) = @_;

  if ($p->{status} eq "O") {
    return "Running";
  } elsif ($p->{status} eq "OQ")  {
    return "Waiting..";

  } elsif ($p->{rc} =~ /143/)  {
    return "Done:ABORTED";

  } elsif ( ( $p->{rc} >> 8 ) =~ /143/)  {
    return "Done:ABORTED";
  } elsif ($p->{rc} =~ /140/)  {
    return "Done:ISOLATED";

  } elsif ( ( $p->{rc} >> 8 ) =~ /140/)  {
    return "Done:ISOLATED";


  } elsif ($p->{rc} =~ /35072/)  {
    return "Done:ABORTED";

  }elsif ($p->{rc} =~ /999/)  {
    return "Done:SYNC";

  }
  elsif ($p->{rc} !~ /^[0\-,]+$/ ) {
    return "Done:ERROR";
  } else {
    return "Done:OK";
  }
}

#
#  Client::ProcMgr::runAgent&hostID=1.2.3.4&force=1&audit=1&nomax=1
#
sub runAgent {
  my($q) = @_;
  my $ID = "rasagent";

  my $force = "-f" if ($q->{force});
  my $audit = "-A" if ($q->{audit});
  my $nomax = "-M" if ($q->{nomax});

# check if it is a local host

  my $IPS    = System->ifconfigs(); 
  my $ip = "";
  foreach my $i (@$IPS) {
     $ip .= " $i->[1]," if ($i->[1] ne "127.0.0.1");
  }
  chop($ip) if ($ip);
  
  if(!$q->{hostID} || $ip eq $q->{hostID}) {
    my $process = Util->findProcessByName("/rasagent");
    if ($process) {
      print Client->error("xml", 402, "Process rasagent already running!");
      return;
    }

    print Client->http_OK();
    Process->start($ID);

    my $trace = "/opt/SUNWstade/DATA/tmp/$ID"  . "_trace";

    system("/opt/SUNWstade/bin/rasagent -d2 -r -a $force $audit $nomax -P > $trace 2>&1&");
    sleep(2);
    my $date = Util->get_today();
    print "<RUNAGENT>$date</RUNAGENT>\n";
  } else {

    my $T = System->get_home() . "/DATA/tmp/run_agent$q->{PID}.out";

    if (!Util->ping($q->{hostID}, 5)) {
      print Client->error("xml", 403, "$q->{hostID}");
      return;
    }
  
    Util::Http->deleteFile($q->{hostID}, "$T");

    my($err, $rc) = Util::Http->runshell($q->{hostID}, "/bin/rasagent -d2 -r $force $audit $nomax>$T 2>&1");
    sleep(2);

    my $date = Util->get_today();
    print "<RUNAGENT>$date</RUNAGENT>\n";
  }
}

sub getRunAgentResult {
  my($q) = @_;
  my ($err, $rc);
  my $out;
 
  # check if it is a local host

  my $IPS    = System->ifconfigs(); 
  my $ip = "";
  foreach my $i (@$IPS) {
     $ip .= " $i->[1]," if ($i->[1] ne "127.0.0.1");
  }
  chop($ip) if ($ip);

  if(!$q->{hostID} || $ip eq $q->{hostID}) { 
    my $ID = "rasagent";
    my $trace = "/opt/SUNWstade/DATA/tmp/$ID"  . "_trace";
    open(O, $trace);
    my @lines = <O>; 
    close(O);
    $rc = "@lines";
  } else {
    ($err, $rc) = Util::Http->readFile($q->{hostID}, "/tmp/run_agent$q->{PID}.out");
  }
  my $done;
  if ($err) {
    $out .= "Error on $q->{host}: $err \n";
    # Ensure rc has remove pid
    $rc .= "REMOVE_PID";
  } 

  $out .= $rc;

  print "<RUNAGENT>$out</RUNAGENT>\n";
}

1;
