package Client::System;
use Inventory;
use strict;
use Client;

# 
# works with System1/maserati/Unity
#

sub inventory {
  my($q) = @_;
 
  my $inv = Inventory->readInventory();

  print Client->http_OK();

  print $inv->toXML();

}

sub trays {
  my($q) = @_;
  my($renv, $devs) = PDM::ConfigFile->read();
  my %D;
  foreach my $d (@$devs) {
     $D{$d->{name}} = $d;
  }
  print Client->http_OK();

  print "<SYSTEM>\n";
  print " <SYSTEM_ID>$renv->{cust_no}</SYSTEM_ID>\n";
  print " <RACK ID=\"0\">\n";
  my $tray_max = 12;
  print "   <TRAY_MAX>$tray_max</TRAY_MAX>\n";

  my($id, $t, $rack);
  my $lastrack = "0";
  my $tray = 1;
  my $hostid = System->hostid();

  $id++;
  print "   <TRAY NO=\"$id\">\n";
  print "     <NAME>sp</NAME>\n";
  print "     <KEY>sp:$hostid</KEY>\n";
  print "     <ORDER>12</ORDER>\n";
  print "     <DISPLAYTYPE>Service Processor</DISPLAYTYPE>\n";
  print "     <TRAYID>SP Tray</TRAYID>\n";
  print "     <RACK>0</RACK>\n";
  print "   </TRAY>\n";

  $id++;
  print "   <TRAY NO=\"$id\">\n";
  print "     <NAME>spatray</NAME>\n";
  print "     <ORDER>11</ORDER>\n";
  print "     <TRAYID>SPA Tray</TRAYID>\n";
  print "     <DISPLAYTYPE>SPA Tray</DISPLAYTYPE>\n";
  print "     <RACK>0</RACK>\n";
  print "   </TRAY>\n";

  $id++;
  print "   <TRAY NO=\"$id\">\n";
  print "     <NAME>hub</NAME>\n";
  print "     <ORDER>10</ORDER>\n";
  print "     <TRAYID>HUB Tray</TRAYID>\n";
  print "     <DISPLAYTYPE>Ethernet HUB</DISPLAYTYPE>\n";
  print "     <RACK>0</RACK>\n";
  print "   </TRAY>\n";

  foreach my $d0 (sort keys %D) {
      my $d = $D{$d0};
      if ($d->{type} eq "dsp") {
          $id++;
          print "   <TRAY NO=\"$id\">\n";
          print "     <NAME>$d->{name}</NAME>\n";
          print "     <IP>$d->{ipno}</IP>\n";
          print "     <KEY>dsp:$d->{key}</KEY>\n";
          print "     <ORDER>09</ORDER>\n";
          print "     <TRAYID>DSP Tray</TRAYID>\n";
          print "     <DISPLAYTYPE>Data Service Processor</DISPLAYTYPE>\n";
          print "     <RACK>0</RACK>\n";
          print "   </TRAY>\n";
      }
  }

  foreach my $d0 (sort keys %D) {
      my $d = $D{$d0};
      next if (index(",6020,6120,t3,", ",$d->{type},") < 0);
      my $n = $d->{name};
      $n =~ /array(\d+)/;
      $rack = substr($1,0,1);
      if ($rack ne $lastrack) {
          print " </RACK>\n";
          $lastrack = $rack;
          print " <RACK ID=\"$rack\">\n";
          print "   <TRAY_MAX>$tray_max</TRAY_MAX>\n";
      }
      my $tray_cnt = $d->{units};
      for ($t=1; $t <= $tray_cnt; $t++) {
          $id++;
          print "   <TRAY NO=\"$id\">\n";
          print "     <NAME>$d->{name}</NAME>\n";
          print "     <IP>$d->{ipno}</IP>\n";
          print "     <KEY>$d->{type}:$d->{key}</KEY>\n";
          print "     <TRAYID>Tray $rack$tray</TRAYID>\n";
          print "     <ORDER>$rack$tray</ORDER>\n";
          print "     <DISPLAYTYPE>Storage Array</DISPLAYTYPE>\n";
          print "     <RACK>$rack</RACK>\n";
          print "     <UNIT>u$t</UNIT>\n";
          print "   </TRAY>\n";
          $tray++;
      }
  }
  print "  </RACK>\n";
  print "</SYSTEM>\n";

}

sub ejectCD {
  my($q) = @_;

  if (-x "/usr/bin/eject") {
    print Client->http_OK();

    my $com = "/usr/bin/eject";
    my $rc = `$com 2>&1`;

    print "<COMMAND>\n";
    print "  <VALUE>$com</VALUE>\n";
    print "  <RESULT>$rc</RESULT>\n";
    print "</COMMAND>\n";

  } else {
     print Client->error("xml", 202, "Cannot execute command");
  }

}

################################################
#  CORE FILES
################################################
#
sub coreList {
  my($q) = @_;

  print Client->http_OK();
  require Service::Core;
  my $L = Service::Core::core_list();

  print "<COREFILES>\n";
  foreach my $e (@$L) {
     my($id, $relative, $dev, $time, $path) = @$e;
     print <<EOF;
  <CORE>
    <FILE>$id</FILE>
    <RELATIVE>$relative</RELATIVE>
    <DEVICE>$dev</DEVICE>
    <TIME>$time</TIME>
    <NAME>$path</NAME>
  </CORE>
EOF
  }

  print "</COREFILES>\n";
}

#
#  System::coreDelete&file=<filename>
#
sub coreDelete {
  my($q) = @_;

  require Service::Core;
  my $base = Service::Core->coreBase();
  
  if ($q->{file} && substr($q->{file}, 0, length($base)) eq $base) {
     print Client->http_OK();
     unlink $q->{file};
     print "<DELETED>$q->{file}</DELETED>\n";

  } else {
     print Client->error("xml", 301, "Invalid core file: $q->{file}");
  }
}


###################################################
# SOLUTION EXTRACT
###################################################
#
sub extractStart {
  my($q) = @_;
  my $pass = $q->{password} ; # optional
  require Service::Extract;
  if (Service::Extract::start($q)) {
     print Client->http_OK();
     print "<STARTED>Solution Extract</STARTED>";
  } else {
     print Client->error("xml", 302, "Error: Solution Extract already running");
  }
}

sub extractList {
  my($q) = @_;
  require Service::Extract;
  my $L = Service::Extract::list();

  print Client->http_OK();
  print "<EXTRACTS>\n";
  print Client->xmlHashList("EXTRACT", $L);
  print "</EXTRACTS>\n";
}

#
#  extractDelete&file=<download_url>
#
sub extractDelete {
  my($q) = @_;
  require Service::Extract;
  my $D = System->get_home() . "/DATA";
  if (-f "$D/$q->{file}") {
     print Client->http_OK();
     unlink "$D/$q->{file}";
     print "<DELETED>$q->{file}</DELETED>\n";
  } else {
     print Client->error("xml", 303, "Cannot delete $q->{file}: $!");
  }
}




1;
