package Counter;
use RasDB;

use strict;
use vars qw($DB);

# increment and return a counter.

sub count {
  my($class, $key) = @_;

  $DB    = RasDB->new("CACHE");
  my $h  = $DB->hash();
  $DB->Lock();
  my $rc = ++$h->{"counter.$key"};
  $DB->UnLock();
  return $rc;
}

sub set {
  my($class, $key, $value) = @_;

  $DB    = RasDB->new("CACHE");
  my $h  = $DB->hash();
  $DB->Lock();
  $h->{"counter.$key"} = $value;
  $DB->UnLock();
  return $value;
}

sub clear {
  my($class, $key) = @_;

  $DB    = RasDB->new("CACHE");
  my $h  = $DB->hash();
  delete $h->{"counter.$key"};
}
1;
