package DevDB;
use RasDB;
use strict;
sub prefix {""}

use vars qw($DB);
#
# used to store device information
#  DevDB->Lock
#  DevDB->UnLock
#  DevDB->UnLock
#  $dev = DevDB->read($key);
#  DevDB->write($key, $dev);
 
sub read {
  my($class, $k) = @_;
  $DB = RasDB->new("DEVICES");
  my $hash = $DB->hash();
  return $hash->{$class->prefix() . $k} || {};
}

sub write {
  my($class, $k, $obj) = @_;
  $DB = RasDB->new("DEVICES");
  my $hash = $DB->hash();    
  $hash->{$class->prefix() . $k} = $obj;
}

sub save {
  my($class, $k, $name, $val) = @_;
  $DB = RasDB->new("DEVICES");
  my $hash = $DB->hash();
  my $dev = $hash->{$name}|| {};
  $dev->{$name} = $val;
  $hash->{$k} = $dev;
}


sub Lock {
  my($class) = @_;

  $DB = RasDB->new("DEVICES") ;
  return $DB->Lock();
}

sub ReadLock {
  my($class) = @_;

  $DB = RasDB->new("DEVICES");
  return $DB->ReadLock();
}  

sub UnLock {
  my($class) = @_;

  $DB = RasDB->new("DEVICES");
  return $DB->UnLock();
}  

1;

__END__

=head1 NAME

DevDB.pm - Static package used to read/write device specific information in a database.

=head1 SYNOPSIS

  use DevDB;

  DevDB->Lock();
  DevDB->ReadLock();
  DevDB->UnLock();

  $dev = DevDB->read($key);
  $dev->{"last_reboot"} = Util->get_today();
  DevDB->write($key, $dev);

=head1 DESCRIPTION

  This module is used to save arbitrary information about a device.

=head1 METHODS

=over 4

=item Lock()

Lock the DEVICES db. Using the locking methods is optional. The module will work 
without specifying locking but may be slower if a large number of records are updated.

=item ReadLock()

Lock the DEVICES for reading.

=item UnLock()

Unlock the database.

=item read($key)

Read a device record given a key. The key is a string.

=item  write($key, $obj);

Write the $obj information in the record identified by $key.

=back 4

=head1 USAGE

  DevDB->Lock();  # optional

  $dev = DevDB->read('wwn1');
  $dev->{'last_reboot'} = Util->get_today();
  DevDB->write('wwn1', $dev);

  DevDB->Unlock(); # optional

=head1 COPYRIGHT

Copyright (c) 2000 Sun Microsystems

=cut




