package DeviceReport;
use strict;

use System;


sub xml {
  my($class, $S, $values) = @_;
  my $out;
  foreach my $el (sort keys %$S) {
     $out .= "  <$el>\n";
      my $V = $S->{$el};
      foreach my $el2 (sort keys %$V) {
         my $r = $V->{$el2};
         if (index(",$values,", ",$el,") >= 0) {
           $out .= "   <VALUE ID=\"$el2\">$r->{value}</VALUE>\n";
         } else {
           if (ref($r) eq "HASH") {
             $out .= "   <COMPONENT ID=\"$el2\">\n";
             foreach my $r0 (sort keys %$r) {
                $out .= "    <VALUE ID=\"$r0\">$r->{$r0}</VALUE>\n";
             }
             $out .= "   </COMPONENT>\n";
           } else {
             $out .= "   <COMPONENT ID=\"$el2\">$r</COMPONENT>\n";
           }
         }
      }
      $out .= "  </$el>\n";
  }
  return $out;
}

#
# THIS FUNCTION SUPPORT 2 FORMATS:
# INFO.attribute => 'value'               # like system, info, id
# or
# SECTION1.INSTANCE1.attribute => 'value' # like frus, volume etc..
#
sub standardReport {
  my($class, $r, $arg) = @_;

  my $all_fields = $arg->{allFields};
  my $sort2      = $arg->{sort2}; # sort on field2 which is numeric
  my $skipC = lc($arg->{skipColumns});
  my $skipS = lc($arg->{skipSections});

  my $v = $r->value();
  my $devname = $r->id("deviceName");
  my $name    = $r->id("name");
  my ($last, %HEADERS, %R, %COLS, %SECTIONS, @SECTION1, @SECTION2);
  my(%COL_CNT);

  my $out .= "<table border=0 cellspacing=0 width=100%>
            <tr><td><big><b>$name - $devname</table>";

  # CREATE MAPS
  #
  foreach my $el (sort keys %$v) {
     my($type, $cnt, $name) = split(/\./, $el, 3);
     my $cols=3;
     if (!$name) {
        $name = $cnt;
        $cols=2;
     }
     next if ($skipC && index(",$skipC,", lc(",$type.$name,")) >= 0);
     if (!$all_fields) {
       next if (substr($name,0,1) ne "_");
       $name = substr($name,1);
     }
     $COL_CNT{$type} = $cols;
     if ($cols == 3) {
       $HEADERS{$type}{$name} = 1;
       $cnt = sprintf("%3.3d", $cnt) if ($sort2);
       $R{$type}{$cnt}{$name} = $v->{$el};
     } else {
       $HEADERS{$type}{Value} = 1;
       $R{$type}{$name} = $v->{$el};
     }

     next if ($skipS && index(",$skipS,", ",$type,") >= 0);
     $SECTIONS{$type} = 1;
  }
  #
  # MOVE DISK/UNIT AT THE TOP OF THE LIST
  #
  foreach my $s (keys %SECTIONS) {
     if ($s eq "disk" || $s eq "unit") {
       push(@SECTION1, $s) ;
     } else {
       push(@SECTION2, $s) ;
     }
  }

  #
  # HOW MANY COLUMNS PER SECTION TYPE (ctrl, volume, disk etc..);
  #
  foreach my $el (keys %HEADERS) {
    my $v = $HEADERS{$el};
    my $tot;
    foreach my $e (keys %$v) {
      $tot++;
    }
    $COLS{$el} = $tot;
  }
  #
  # MAKE REPORT
  #
  my ($last);

  foreach my $type (@SECTION1, @SECTION2) {
    my $cols = $COLS{$type} + 1;
    $out .= "</table>&nbsp;" if ($out);
    $out .= "<table border=1 bgcolor=white cellspacing=0 width=100%>";
    $out .= "<tr bgcolor=#E0E0E0><td colspan=$cols><b>" . ucfirst($type) . "(s)</td>";

    my $t = $R{$type};
    if ($COL_CNT{$type} == 2) {
      foreach my $el (sort keys %$t) {
         $out .= "<tr><td>$el&nbsp;</td><td>$t->{$el}&nbsp;</td>";
      }
    } else {
      $out .= "<tr><td><b>Id</td>";

      # COLUMN HEADERS
      foreach my $el (sort keys %{$HEADERS{$type}}) {
         $out .= "<td><b>$el</td>";
      }
      foreach my $cnt (sort keys %$t) {
         $out .= "<tr><td>$cnt</td>";
         foreach my $el (sort keys %{$HEADERS{$type}}) {
            $out .= "<td>$t->{$cnt}{$el}&nbsp;</td>";
         }
      }
    }
  }
  $out .= "</table>&nbsp;<p>&nbsp;<p>";

  return $out;
}



1;
