package DeviceReport::3310;
use System;
use strict;
use DeviceReport;
use Agent::3310;



# no $q->{summary}                    # only frus,vols, system, id
# $q->{summary} = "controller.u1ctr." # this controller
# $q->{summary} = "controller."       # all controllers
# Main sections:
# <FRU> <LOGICAL> <SYSTEM> <ID>

sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $product_id = "$rep->{'info.Product'} $rep->{'info.unique_id'}";

  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'}},
      device_type            => {order => 2, value => $rep->{'id.device_type'} },
      device_key             => {order => 3, value => $rep->{'id.device_key'} },
      device_ip              => {order => 4, value => $rep->{'id.ipno'} },
      product_ID             => {order => 5, value => $product_id },
      };

  my $order = 6;
  foreach my $el (sort keys %$rep) {
     if ($el =~ /^info\.(.+)/)  {
       my $n = $1;
       next if (index( Agent::3310->report_exclude(), ",$n,") >= 0);

       $S{HEADER}{$n} = { order => $order, value => $rep->{$el} };
       $order++;
     }
  }

  my (%WWN);
  foreach my $el (sort keys %$rep) {
     if ($el =~ /port.(\d+).id/) {
       my $no = $1;
       my $id = $rep->{$el};
       $WWN{$id} = $rep->{"port.$no.wwn"};
     }
  }
  
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       next if (index($el, "fruDiskPerf") >= 0);
       if (!$summary) {
          if ($L[1] eq "disk" && $L[3] eq "model") {
              $k = "$L[0].$L[1].$L[2]";

              $S{FRU}{$k}            = { name    => $L[1], 
                                           id    => $k,
                                         state   => "",
                                         status  => $rep->{"$k.status"},
                                         type    => $rep->{"$k.fruType"},
                                         revision=> $rep->{"$k.product_revision"},
                                           model => $rep->{"$k.model"},
                                          serial => $rep->{"$k.serial_number"},
                                         keyLabel=> "serialno",
                                         keyValue=> $rep->{"$k.serial_number"},
                                       };

          } elsif ($L[0] eq "fru" && $L[2] eq "item") {
              my $name = $rep->{"$k.fru_location"} || $k;
              $S{FRU}{$k}            = { name    => $name,
                                           id    => $k,
                                         state   => "",
                                         status  => "",
                                         type    => $rep->{"$k.description"},
                                         revision=> $rep->{"$k.revision"},
                                           model => $rep->{"$k.model"},
                                          serial => $rep->{"$k.serial_number"},
                                         keyLabel=> "serialno",
                                         keyValue=> $rep->{"$k.serial_number"},
                                       };

          } elsif ($L[0] eq "channel") {
              if ($rep->{"$k.mode"} eq "Host") {
                 my $wwn = $WWN{$rep->{"$k.sid"}} || $WWN{$rep->{"$k.pid"}};

                 $S{PORT}{$k} = {name => $k,
                                   id => $k,
                               state  => "",
                               status => "",
                             keyLabel => "WWN",
                             keyValue => $wwn,
                                 type => $rep->{"$k.type"} . "/" . $rep->{"$k.curclk"},
                                       };
              }
          } elsif ($L[0] eq "system") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } elsif ($L[0] eq "logical_drive" && $L[2] eq "status")  {
              $S{LOGICAL}{$k} =  { name => $k,
                                    id  => $k,
                                  type  => "logical_drive",
                                 status => $rep->{"$k.status"},
                                 };

          } elsif ($L[0] eq "logical_volume" && $L[2] eq "status")  {
              $S{LOGICAL}{$k} =  { name => $k,
                                    id  => $k,
                                  type  => "logical_volume",
                                 status => $rep->{"$k.status"},
                                 };
                                           
          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return $out;
}




1;
