package DeviceReport::A5K;
use System;
use strict;
use DeviceReport;


sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'} },
      device_type            => {order => 2, value => $rep->{'id.device_type'} },
      device_key             => {order => 3, value => $rep->{'id.device_key'}  },
      device_wwn             => {order => 4, value => $rep->{'id.device_key'}  },
      device_label           => {order => 5, value => Util->abb("a5k.medium")  },
      loopA_status           => {order => 9, value => $rep->{'loop.A.info'}},
      loopB_status           => {order =>10, value => $rep->{'loop.B.info'}},
  };

  foreach my $k ('power.0', 'power.1', 'power.2', 'fan.0', 'fan.1') {
     my($type, $no) = split(/\./, $k);
     $S{FRU}{$k}    = { name    => $k,
                          id    => $k,
                        state   => "",
                        status  => $rep->{"$k.status"},
                        type    => $type,
                       revision => $rep->{"$k.rev"},
                          model => "",
                         serial => "",
                 };
  }

  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       if (!$summary) {
          if (($L[0] eq "disk_front" || $L[0] eq "disk_rear") && $L[2] eq "product_id") {

              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => $rep->{"$k.state"},
                                         status  => $rep->{"$k.status"},
                                         type    => "disk",
                                         revision=> $rep->{"$k.revision"},
                                           model => $rep->{"$k.product_id"},
                                          serial => $rep->{"$k.serial_no"},
                                         keyLabel=> "WWN",
                                         keyValue=> $rep->{"$k.wwn"},
                                       };

          } elsif ($L[0] eq "interface_board" && $L[2] eq "rev") {

              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => "",
                                         status  => $rep->{"$k.status"},
                                         type    => "interface",
                                         revision=> $rep->{"$k.rev"},
                                           model => "",
                                          serial => "",
                                         keyLabel=> "KEY",
                                         keyValue=> $k,
                                       };


          } elsif ($L[0] eq "system") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return $out;
}




1;
