package DeviceReport::INTERNAL;
use System;
use strict;
use DeviceReport;


sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'} },
      device_type            => {order => 2, value => $rep->{'id.device_type'} },
      device_key             => {order => 3, value => $rep->{'id.device_key'}  },
      device_label           => {order => 4, value => Util->abb("internal.medium")  },
  };

  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       if (!$summary) {
          if ($L[0] eq "disk" && $L[2] eq "ProductID") {

              $S{FRU}{$k}            = { name    => $k,
                                              id => $k,
                                           state => "",
                                          status => $rep->{"$k.Status"},
                                            type => "disk",
                                        revision => $rep->{"$k.Revision"},
                                           model => $rep->{"$k.Vendor"} . "." . $rep->{"$k.ProductID"},
                                          serial => $rep->{"$k.SerialNum"},
                                        keyLabel => "serial",
                                        keyValue => $rep->{"$k.SerialNum"},
                                       };


          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return $out;
}




1;
