package EmailMessage::Audi;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Name:  $ 
#  $Id: Audi.pm,v 1.1 2004/05/20 17:04:48 ccadieux Exp $

use strict qw(vars);
use State;
use PDM::Parse;
use Report;
use Policies;
use Trap;


#--------------------------------------------------------------
#  REGISTER():
#  register for specific email based on email content
#--------------------------------------------------------------
#
sub REGISTER {
   return [ { style => 'name_value_content',
              name  => 'System',
              value => 'Sun Microsystems, Inc. StorEdge Model 3410 NAS',
            }
          ];
}

#--------------------------------------------------------------
# RUN():
# called by the framework only once with a list of interesting traps.
#--------------------------------------------------------------
#
sub RUN {
  my($trap_agent, $messages, $errors) = @_;

  my $renv   = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  my(%DEV, $x);
  my $policies = Policies->new("audi_policies");

  my $devs = $Config->devices();
  foreach my $d (@$devs) {
     $DEV{$d->{ipno}} = $d;
  }

  for ($x = 0; $x <= $#$messages; $x++ ) {

     my $message = $messages->[$x];
     use Data::Dumper;
     print "IN EmailMessage:Audi: Printing message $x \n";
     print Dumper($message);

     my $sev = 2;
     my $ip  = "1.1.1.1";
     my $line = $messages->[$x];
     my $id  = "ID";
     my $desc = "desc";
     my $topic = "topic";
     my $key  = "key";
     my $dev_name = "devname";

     # create a logline that is easy to read , this line will be used in the
     # CIM event as the description and/or data.
     # this logline is used in the 'pattern=' section of the policy file.

     my $loglines = ["$line->{DATE} $line->{TIME} $line->{DEVICE} $ip Sev:$sev Type:$topic SystemID:$id $desc"];

     my $y = 0;

     # Topic is used to aggregate together multiple traps about the same topic.

     my $key = "audi:$key:$topic";
     my $key0= "audi:$key";
     $policies->run($errors, 
                    $loglines, \$y, 
                    $topic,
                    $dev_name, 
                    $key, 
                    $ip,
                    $key0, 
                    1);
  }
}

1;

__END__

# Example Message:

$VAR1 = {
  'Content-Type' => 'text',
  'CONTENT' => [
    '                               SYSTEM NOTIFICATION',
    '',
    'System    : Sun Microsystems, Inc. StorEdge Model 3410 NAS',
    'Host      : diag-v65d [172.20.35.143]',
    'URL       : http://diag-v65d.central.sun.com',
    'Subsystem : Internal',
    'Severity  : Error',
    'When      : Tue May 18 14:39:41 2004',
    'Location  :',
    '',
    'Problem:',
    'File system /trapCheckv65 is 98% full.',
    '',
    'Course of Action:',
    '1. Delete any unused or temporary files. OR',
    '2. Extend the partition by using an unused partition. OR',
    '3. Add additional disk drives and extend the partition after creating a new partition.'
  ],
  'From' => 'Christian Cadieux <ccadieux>',
  'FROM' => 'root@ccadieux.Central.Sun.COM Thu May 20 09:31:53 2004',
  'Date' => 'Thu, 20 May 2004 09:31:53 -0600 (MDT)',
  'Message-Id' => '<200405201531.i4KFVrs18540@ccadieux.Central.Sun.COM>',
  'Received' => '(from ccadieux@localhost)
                 by ccadieux.Central.Sun.COM (8.11.7p1+Sun/8.11.7) id i4KFVrs18540
                 for storade@ccadieux; Thu, 20 May 2004 09:31:53 -0600 (MDT)'
};






