package FSA::DSPrules;
use strict;
use FSA;
use base 'FSA';


# remove LOG_CRITICAL if there is
# already a stateChangeEvent which is more conclusive
# this is a filter rule, which means that
# it does not generate a fault and other rules will run.
#

sub RULE1 {
  my($class, $Config, $topo, $targets, $elist) = @_;

  $DB::single = 1;
  return () if (substr($targets->[0],0,3) ne "dsp");
  my ($state, $x);

  for ($x=0; $x <= $#$elist; $x++) {
    my $ed    = $elist->[$x];
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    $state++ if ($et =~ /StateChangeEvent/);
  }
  return() if (!$state);
  my(@del);
  for ($x=0; $x <= $#$elist; $x++) {
    my $ed    = $elist->[$x];
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");

    if ($et =~ /LogEvent.log_critical/) {
       push(@del, $x);
    }
  }
  $elist->delete(@del);
  
  return ();
}

   
1;
