package FSA::RuleSet1;
use strict;

#
# Confirmed communication lost oob
# returns ($ev, $pertains)
#
sub RULE1 {
 my($class, $Config, $topo, $targets, $elist) = @_;
 my ($cnt, $cl, $seen, $ev, $pertains);

 foreach my $ed (@$elist) {
    my $ev = $ed->instances(0);
    
    if ($ev->value("EventType") =~ /CommunicationLostEvent/ && 
        $ev->value('Caption') eq "e") {
      $cl = $ev;
      $cnt++;
    } elsif ($ev->value("Component") =~ /^port.\d+/ || 
             $ev->value("Caption") =~ /driver/ ) {
      $seen = 1;
    }
 }
 if ($cl && ($cnt==1) && $seen) {
    my $targetName = $cl->value("TargetName");
    my $target     = $cl->value("Target");
    my $ix = index($target, ":");
    $target = substr($target,$ix+1) if ($ix > 0);
    my ($type, $et) = split(/\./, $cl->value("EventType"));
    my $desc = "$type device $targetName is not available anymore, ". 
               "confirmed by the following subEvents:";

    my $key = CIM::Key->new( ['NWS_System',
                                Name  => $target,
                    CreationClassName => 'NWS_System']);
  
    Grid->setCode("$type.DeviceLostEvent");
    my $id = PDM->getEventSequence(); 
    ($ev,$pertains) = FSA->newEvent($elist, $targets, $cl, $desc,
              { Fault => "RuleSet1:RULE1",
                EventType => "$type.DeviceLostEvent",
              });

    return ($ev, $pertains);
 }
 return ();
}





#
# aggregate around missing loopcable E: u1l2: UP cable not present
# when volume, disks and loopcard not present appear at the same time.
#

sub RULE2 {
 my($class, $Config, $topo, $targets, $elist) = @_;
 my ($vol, $disk, $cable, $log, $other);
 my ($cl, $details);
 foreach my $ed (@$elist) {
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    my $cap   = $ev->value("Caption");
    my $class = $ed->id("class");
    my $desc  = $ed->id("Description");
    if ($et =~ /ValueChangeEvent/ && $cap =~ /volume/) {
       $vol++;
    } elsif ($et =~ /ValueChangeEvent/ && $cap =~ /disk/) {
       $disk++;
    } elsif ($et =~ /LogEvent/ && $cap =~ /loopcard/ && $desc =~ /cable not present/) {
       $details = $cap;
       $cl = $ev;
       $cable++;
    } else {
       $other++;
    }
  }
  if ($disk && $cable && $vol) {
    my $targetName = $cl->value("TargetName");
    my $target     = $cl->value("Target");
    my $ix = index($target, ":");
    $target = substr($target,$ix+1) if ($ix > 0);
    my ($type, $et) = split(/\./, $cl->value("EventType"));
    my $desc = "Loop Interconnect Cable $details was disconnected on $target, ".
               "confirmed by the following  subEvents:";

    my $key = CIM::Key->new( ['NWS_System',
                                Name  => $target,
                    CreationClassName => 'NWS_System']);
  
    Grid->setCode("$type.LoopCableDisconnect");
    my $id = PDM->getEventSequence(); 

    my $ev = CIM::Instance->new('NWS_Event', [
                  [ EventId     => $id          ],
                  [ EventType   => "$type.LoopCableDisconnect"   ],
                  [ Target      => $cl->value("Target")    ],
                  [ TargetName  => $cl->value("TargetName")],
                  [ Caption     => $details ],
                  [ Component   => $cl->value("Component") ],
                  [ SourceIP    => $cl->value("SourceIP")  ],
                  [ Actionable  => $cl->value("Actionable")],
                  [ Severity    => 2            ],
                  [ Aggregate   => ($#$elist+1) ],
                  [ Description => $desc        ],
                         ]);

    my $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $key ],
                    ]);

    return ($ev, $pertains);
  }
  return ();
}



     
   
1;
