package GUI;
use System;
use strict;
use Util;
use Cache;
use Grouping;
use TO;

sub getFilter {
  my($class, $filter, $topo, $auto) = @_;
  my $filter_out;
  my $to = TO->readExistingTopo($topo);
  my $ruser = System->get_ruser();
  return () if (!$to);
  my($switches) = $to->switchList();
  my($hosts) = $to->hostList();
  my $G = Labels->read();

  my $filter0 = "<select name=FILTER ";
  if ($auto) {
     $filter0 .= " onChange='window.document.forms[0].submit()'";
  }
  my $renv = System->get_renv();
  my $IP = $renv->{solution_prefix} || "XX";
  $filter0 .= "><option value=\"*\">[ $G->{filter} ]</option>";
  my ($cnt, %Z);
  my $found = 0;
  $filter_out = $filter0 . $filter_out;
  foreach my $sw1 (@$switches) {
     my $zones = $sw1->zones();
     if ($zones) {
        foreach my $z (@{$zones->{hd_name}}) {
          chop($z) if (substr($z,-1) eq "\"");
          $z = substr($z,1) if (substr($z,0,1) eq "\"");
          next if (!$z);
          $Z{$z} =1;
        }
     }
     next if (substr($sw1->{info}{sw_ipAddr},0,length($IP)) eq $IP);
     my $sel = "";
     if ($sw1->name() eq $filter) {
        $sel = "selected";
        $found = 1;
     }
     my $n1;
#     if  (!$sw1->isCascaded()) {
     $n1 = $sw1->{info}{BoxName} || $sw1->{info}{sw_ipName} ||  $sw1->{info}{sw_ipAddr};
     $n1 = $sw1->{info}{sw_ipAddr} if ($n1 =~ /- name unknown/);
     $n1 = $sw1->{info}{sw_ipAddr} if ($n1 =~ /UNKNOWN/);
     next if ($n1 =~ /UNKNOWN/);
     my $ti = $sw1->type();
     $filter_out .= "<option $sel value=" . $sw1->name() . ">$ti:$n1</option>";
     $cnt++;
  }
  foreach my $z (sort keys %Z) {
     my $sel;
     if ($filter eq "zone:$z") {
        $sel = "selected"; $found = 1;
     }
     $filter_out .= "<option $sel value=\"zone:$z\">zone:$z</option>";
  }

  if (0) {
  foreach my $ho1 (@$hosts) {
     my $sel = "";
     if ($ho1->name() eq $filter) {
        $sel = "selected";
        $found = 1;
     }
     my $n1 = Util->shortHostname(substr($ho1->{info}{name},5));
     $filter_out .= "<option $sel value=" . $ho1->name() . ">host:$n1</option>";
  }
  }
  my $glist = Grouping->groupList($topo);

  foreach my $el (@$glist) {
     my $sel = "";
     my $v = "group:" . $el->{host} . ":" . $el->{group};
     if ($v eq $filter) {
        $sel =  "selected";
        $found =1;
     }
     $filter_out .= "<option $sel value=\"$v\">gr:$el->{group}</option>";
     
  }
  if (!$found && $filter ne "*" && $filter) {
       if (substr($filter,0,2) eq "gr") {
         my $f1 = substr($filter,6);
         my $ix = index($f1,":");
         $f1 = substr($f1,$ix+1) if ($ix > 0);
         $filter_out .= "<option selected value=\"$filter\">gr:$f1</option>";
       } else {
         $filter_out .= "<option selected value=\"$filter\">$filter</option>";
       }
       $found = 1;
  }
     
  $filter_out .= "</select>";
  return($filter_out, $found, $to);
}

sub topoPage {
  my($class, $q) = @_;
  my($type);

  my $renv = System->get_renv();

  if ($renv->{solution} ne "N") {
     my $to = TO->readExistingTopo();
     return ("", "", $q->{topo}, $to);
  }

  $q->{topo} = $q->{stopo} if ($q->{stopo});
  my $first;

  if ($q->{enc}) {  # sub-grouping
    my ($type,$host, $group,$cat) = split(/:/, $q->{enc});
    $q->{FILTER} = "group:$host:$group";
  }
  $q->{topo} = Cache->cache("st_last", "topo", $q->{topo}) ;

  if ($q->{topo}) {
    $q->{FILTER} = Cache->cache("st_last", "filter_$q->{topo}", $q->{FILTER}) ;
  }

  my($filter,$found, $to) = GUI->getFilter($q->{FILTER}, $q->{topo}, 0);
  $q->{FILTER} = "*" if (!$found);
  my $hlist = TO->topoList();
  my $select_host = "<select name=topo onchange=form.submit() >";

  foreach my $c (sort @$hlist) {
      next if (substr($c,0,6) eq "MERGE-");
      my $sel = $c eq $q->{topo} ? "selected":"";
      $first = $c if (!$first);
      my $c1 = Util->shortHostname($c);
      $select_host .= "<option $sel value=$c>$c1";
  }
  foreach my $c (sort @$hlist) {
      next if (substr($c,0,6) ne "MERGE-");
      my $sel = $c eq $q->{topo} ? "selected":"";
      $first = $c if (!$first);
      my $c1 = Util->shortHostname($c);
      $c1 = "san:" . substr($c1,6);
      $select_host .= "<option $sel value=$c>$c1";
  }
  $select_host .= "</select>";
  $q->{topo} = $first if (!$q->{topo});  # new line
  return ($select_host, $filter, $q->{topo}, $to);
}

# now optional function
sub needToPush {
  my($class, $hosts) = @_;
  my $flag = 0;
  return undef;

  foreach my $h (@$hosts) {
     next if ($h->{dh} eq "Y");
     $flag++ if (!$h->{last_push});
  }
  if ($flag) {
    return "<table border=1 cellspacing=1 cellpadding=4 bgcolor=white>
     <tr><td><b><a href=$Http::WEBPROC?GO=GUI::Hosts::pushSlaves>
      <font color=red>$flag slave(s) need to be updated, click here to 'Push Slave Configs'</font></a>
    </table>";
  }
  return undef;
}

#  returns last selected topo and a <select> html field with the last topo selected

sub test_head {
  my($class, $q) = @_;

  my $sel = "<select name=stopo>";
  my $DD = System->get_home() . "/DATA/topo";
  opendir(O, $DD); my(@files) = readdir(O); closedir(O);
  my($in) = 0;
  my($hn) = System->hostname();
  my($first, $last);

  $last = Cache->cache("tests","st_last_seen_topo", $q->{stopo});
  my $check = $last || $hn;

  foreach my $f (sort @files) {
    next if (-d "$DD/$f");
    next if (substr($f,0,1) eq "." || substr($f,0,6) eq "MERGE-");
    my $i = index($f, ".");
    my $f0 = $f;
    $first = $f if (!$first);
    $f0 = substr($f,0, $i) if ($i > 0);
    my $ck;
    if ($f eq $check) {
       $ck = "selected";
    }
    $sel .= "<option value=$f $ck>$f0</option>";
  }
  $sel .= "</select>";
  return ($check,$sel);
}





1;


