package GUI::Errlog;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Errlog.pm,v 1.9 2004/02/11 18:59:44 mckenney Exp $

use System;
use Util::Http;
use Html;

sub list {
  my($q, $post) = @_;
  my(@S, $out, $tabs);
  my($renv) = System->get_renv();
  my($acronym) = $renv->{GSV_ACRONYM};
  my $L = Labels->read("GUI::Errlog");

  print Html->body();

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $hid = System->hostid;

  print Html->header2("monitor.log.errors");

  my (@array);
  push(@array, 
    [ "<a href=$Http::WEBPROC?GO=GUI::Errlog::detail&loc=master&name=Master>$L->{master}</a>",
       $hid, Util->name2ip() ]);

  my(@H);
  foreach $h (@$host) {
     my $url = $h->{dh} eq "Y" ? "$h->{hostname} (Datahost)" :
                    "<a href=$Http::WEBPROC?GO=GUI::Errlog::detail&loc=$h->{ip}&name=$h->{hostname}>$h->{hostname}</a>";
     push(@array, [ $url, $h->{hostid}, $h->{ip} ]);
     $cnt++;
  }

  my $scr = Html::Screen->new();
  $scr->list($q , { title => $L->{select} },
   [
   [ l => $L->{host} ],
   [ l => $L->{hostid} ],
   [ l => $L->{location} ],
   ],
   \@array,  
   );
  print $scr->out();
}

sub detail {
  my($q, $post) = @_;
  my($renv)    = System->get_renv();
  my($acronym) = $renv->{GSV_ACRONYM};
  my $L = Labels->read("GUI::Errlog");
  print Html->body();
  my $title = $q->{name} eq "Master" ? $L->{master} : $q->{name};
  print Html->header2("monitor.log.errors", undef, $title);
  print "</center>";

  if ($q->{max} =~ /^\d+/) {
     $MAX = $q->{max} + 0;
  } else {
     $MAX = 100;
  }

  $out = "<center>$h
  <table border=1 cellspacing=0 cellpadding=1 width=95% bgcolor=white>
   <form  method=get>
      <input type=hidden name=GO value=GUI::Errlog::detail>
      <input type=hidden name=loc value=$q->{loc}>
      <input type=hidden name=name value=$q->{name}>
   <tr><td colspan=3 bgcolor=$Style::DARK>
     <table border=0 cellspacing=0 cellpadding=0 width=100%>
      <tr><td>
         <font color=white>&nbsp;<b>$MAX $L->{recent}</td>
      </td><td align=right>
       <font color=white><b>$L->{errors}:<small>
     <input type=text name=max size=3 value=$MAX>&nbsp;
     <input type=submit name=ACTION value=$L->{refresh}>
   </td></table></table></center><pre>\n";

  if ($q->{loc} eq "master") {
    print "$L->{accessing}<br>";
    $q->{max} = $MAX;
    $out .= &get_readlog($q);

  } else {
    print "$L->{accessing1}<br>";

    $out .= Util::Http->getCommand( $q->{loc},
                   "GUI::Errlog::readlog&max=$MAX&http=1", 30) || "Error";
  }

  $out .="&nbsp;<p>&nbsp;</form>";
  print $out;

}

sub get_readlog {
  my($q) = @_;
  my($out, $cnt,  $cnt3, @S, @a);
  my $SEEK = 100000;
  my($MAX) = $q->{max} || 100;
  my $F = System->get_home() . "/log/errors.log";
  my $L = Labels->read("GUI::Errlog");

  if (!open(O, $F)) {
    if ($q->{http}) {
       print "$L->{empty}";
    } else {
       return "$L->{empty}";
    }
  }
  $cnt = 0;
  my $fsize = (stat($F))[7];
  if ($fsize > $SEEK) {
    seek(O, -$SEEK, 2);
    $l = <O>;
  }
  while ($l = <O>) {
     next if (length($l) <= 2);
     if ($l =~ /^\d\d-\d\d/) {
       $S[$cnt] = $l;
       $cnt++;
     } else {
       chop($l);
       $S[$cnt] = $l;
     }
  }
  close(O);
  $cnt3 = ($MAX <= ($#S+1)) ? $MAX : ($#S +1);
  my $start = $#S;
  my $end = ($#S+1) - $cnt3;

  while($start >= $end){
    @a = split(/ +/, $S[$start], 4);
    $a[0] =~ s/^\s+//;
    $out .=  "   $a[0]  $a[1]  $a[2]   $a[3]";
    $start--;
  }
  if ($q->{http}) {
    print $out;
  } else {
    return $out;
  }
  
}

1;
