package GUI::Frequency;
use System;
use strict;
use Agent;

sub list {
  my($q) = @_;
  my $SKIP = "datahost,sve,sve2,se,san,se2,dsp,internal";

  my $L = Labels->read("GUI::Frequency");
  print Html->body();
  print Html->header2("admin.gen_maint.freq");

  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();

  my $categories = Agent->findSelectableAgents($renv->{solution});
  if ($q->{ACTION_update}) {
    foreach my $el (keys %$q) {
      if (substr($el,0,5) eq "freq_") {
         my $t = substr($el,5);
         $renv->{"frequency.$t"} = $q->{$el} if (exists($q->{$el}));
      }
    }
    PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);
    print Html->info("$L->{updated}");
  }

  my(@array, $x);
  my $list = "0=$L->{def}|";
  foreach $x (5,10,20,30,40,50,60,90,120,180,240,360) {
    $list .= "$x=$x $L->{mins}|";
  }
  chop($list);
  foreach my $m (sort @$categories) {
     my($type, $rest) = split(/=/, $m);
     next if (index(",$SKIP,", ",$type,") >= 0);
     #Skip types that aren't selected to be monitored
     next if (index("|$renv->{categories}|", "|$type|") < 0);
     my $freq = Html->makeSelect("freq_$type", $list, $renv->{"frequency.$type"});
     push(@array, [ uc($type), $rest, $freq ]);
  }    

  my $scr = Html::Screen->new();
  $scr->add(" <form><input type=hidden name=GO value=GUI::Frequency::list>");
  $scr->list( $q, { title =>  $L->{title} , interactive => 5 },
    [
    [ l => $L->{dev} , '+'],
    [ l => $L->{name}, '+' ],
    [ l => $L->{freq} ],
    ],
    \@array,
    [
    [ l => 'ACTION_update', $L->{submit} ],
    ]);
  $scr->add("</form>");
  print $scr->out();

}

1;
