package GUI::Groups;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
use strict;
use AdminGroup;
use Roles;


sub update {
  my($q) = @_;
  my $G = Labels->read();
  my $LB = Labels->read('GUI::AdminGroup');

  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  if ($q->{ACTION} eq "ip") {
     my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
     my $groups = AdminGroup->new();
     my (%IP);
     foreach my $d (@$devs) {
	next if (!$d->{ipno});
        my (@l) = split(/\./, $d->{ipno});
	my $ag = "$l[0].$l[1].$l[2]";
	$IP{$ag} = 1;
	$d->{adm_group} = $ag;
     }
     PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);
     
     foreach my $ip (keys %IP) {
        $groups->{$ip} = "Group $ip" if (!exists $groups->{$ip});
     }
     $groups->save(); 
     print Html->info("Groups created!");
  }

  print Html->header2("admin.system.device_groups", undef, undef, {noHelp => 1});
  my $sel = "<select name=ACTION>
    <option value=\"\">[$LB->{sel_group}]</option>
    <option value=ip>$LB->{create_and_assign}</select>";

  print "<table border=0 width=$Style::WIDTH>
    <tr><td>
     <form>
     $sel
     " . Html::Screen->submitButton("submit", $G->{go}) . "</table>";

  if (my $err = Roles->verifyRole($q, "admin|c_admin")) {
     print $err;
     return;
  }
  my $groups = AdminGroup->new();

  if ($q->{ACTION_delete}) {
     my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
     my $UPD;
     foreach my $el (keys %$q) {
        if (substr($el,0,4) eq "del_") {
           my $k = substr($el,4);
           delete $groups->{$k};
           foreach my $not (@$notifs) {
              if (index("|$not->{groups}|", "|$k|") >= 0) {
                 delete $not->{groups}; $UPD++;
              }
           }
 
        }
     }
     PDM::ConfigFile->write($renv, $devs, $hosts, $notifs) if ($UPD > 0);
     $groups->save(); 
     $groups = AdminGroup->new();
     my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
     foreach my $d (@$devs) {
	if (!exists $groups->{$d->{adm_group}}) {
           delete $d->{adm_group};
        }
     }
     PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);

  } elsif ($q->{ACTION_submit}) {
     my $update;
     foreach my $k (keys %$groups) {
        delete $groups->{$k};
     }
     my ($err, $codes);
     foreach my $el (keys %$q) {
        if (substr($el,0,3) eq "gr_") {
           my $no = substr($el,3) + 0;
           my $code = $q->{"gr_$no"};
           my $val  = $q->{"val_$no"} || $code;
           $code = Util->trim($code);
           $code =~ s/ /_/g;

           if ($code && $val) {
              if (index(",$codes,", ",$code,") >= 0) {
                $err .= "<br>" if ($err);
                $err .= $LB->expand(already => $code);
              } else {
                $codes .= "$code,";
                $groups->{$code} = $val;
                $update = 1;
              }
           }
        }
     }
     print Html->error($err) if ($err);
     if ($update) {
         $groups->save(); 
     }
  }
out:

  my @array;
  my $gr_cnt = 1;
  foreach my $gr (sort keys %$groups) {
     my $del  = "<input type=checkbox name=\"del_$gr\">";
     push(@array,
         [ $gr_cnt, $del, "<input size=11 maxlength=11 type=text name=gr_$gr_cnt  value=\"$gr\">",
                    "<input type=text size=40 name=val_$gr_cnt value=\"$groups->{$gr}\">" ]);

     $gr_cnt++;
  }
  my $MAX = $q->{DOC} ? 8: 20;
  while ($gr_cnt <= $MAX) {
     push(@array, 
         [ $gr_cnt, "&nbsp;", "<input size=11 maxlength=11 type=text name=gr_$gr_cnt>",
                    "<input type=text size=40 name=val_$gr_cnt>" ]);

     $gr_cnt++;
  }

  my $scr = Html::Screen->new();

  $scr->add(" <form><input type=hidden name=GO value=\"GUI::Groups::update\">");

  $scr->list( $q, { title => $LB->{title}},
   [
   [ l => '#' ],
   [ c => $LB->{del} ],
   [ l => $LB->{code} ],
   [ l => $LB->{desc} ],
   ],
   \@array ,
   [ 
   [ l => 'ACTION_delete' , $LB->{del_sel}  ],
   [ l => 'ACTION_submit' , $LB->{submit_1} ],
   ]);
      
  $scr->add(" </form>");
  print $scr->out();

}
1;

