package GUI::Navigation;
use Html;
use System;
use Navigation;
use GUI::Welcome;
use strict "vars";

sub version {
  my($q) = @_;
  my $G = Labels->read();
  my $renv = System->get_renv();

  my $copyright = Util->readHtdocs("copyright");

  print Html->body(undef, 
            { body => 1, 
              extra => " marginheight=0 marginwidth=0 leftmargin=0 topmargin=0"
             } );

  print "
   <img src=/gif/loginW.gif>
   &nbsp;
   <table border=0 cellpadding=0 cellspacing=0 width=95%>
   <tr>
    <td><img src=/gif/dot_clear.gif height=300 width=1 align=left>
       <b>$G->{product_version} - $renv->{pstamp}</b><p>
       $copyright</td>
   <tr><td  align=right><hr></td><form>
   <tr><td  align=right>" .
    Html::Screen->submitButton("ACTION", $G->{close}, undef, {extra => "onclick = window.close()"} ) . "</td>
   </table></form>
   ";

}



sub index {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  #print Http->text_header("Set-Cookie: RAS_LANG=" . $ruser->{language}. "; path=/;");
  my $window = $ruser->{window} || $renv->{window};
  my $lang = $ruser->{language} || $renv->{language} || "en";
  print Html->text_header();
  print Html->add_css();

  if ($window eq "N") { # no top frame
     if ($q->{MENU}) {
       if (substr($q->{MENU},0,1) eq ">") {
          $q->{MENU} = substr($q->{MENU},1);
          #Navigation::nf_top($q);
          &welcome($q);
       } else {
          eval {
            Http->runFunction($q->{MENU}, $q);
          };
          if ($@) {
             print "Execution error: $@<br>\n";
          }
       }
     } else {
       #Navigation::nf_top($q);
       require GUI::DeviceReport;
       $renv->{solution} eq "N" ? GUI::Welcome::welcome($q):
                                  GUI::DeviceReport::alarmRun($q);
     }
     return;
  #} elsif ($ENV{HTTPS} || $Http::httpua !~ /la\/4.7/ || $lang ne "en" ) {  # 7 no javascript on top frame
  } else {
     if ($q->{MENU}) {
       if (substr($q->{MENU},0,1) eq ">") {
          $q->{MENU} = substr($q->{MENU},1);
       }
       $q->{FRAME} = 1;

       print Navigation::nf_top($q);
     } else {
       my $nav = Navigation->read();
       my $in = $nav->{ROOT}{info};
       my $welc;
       if ($in->{frame2}) {
         $welc = $in->{frame2};
       } elsif ($renv->{solution} eq "N") {
          $welc = "GUI::Welcome::welcome";
       } else {
          $welc = "GUI::DeviceReport::alarmRun";
       }
       my $short = Util->shortHostname($renv->{hostname});
       print <<EOF;
       <header><title>$short - $in->{desc}</title></header>
       <frameset rows=$Style::TOP_FRAME_HEIGHT,* border=0>
         <frame src=$Http::WEBPROC?GO=GUI::Navigation::index&MENU=X name=top scrolling=no>
         <frame src=$Http::WEBPROC?GO=$welc name=bottom scrolling=auto>
       </frameset>
EOF
     }
     return;

  }

}

sub top {
  my($q) = @_;
  print "\n";
  print Navigation::nf_top($q);

}


# Navigation::file&FILE=/help.html&MENU=help

sub file {
  my($q) = @_;

  my $file = $q->{FILE};

  print Html->body();
  print Html->header2("$q->{menu}");
  print "</center>";

  Html->readHtdocs($file, undef, "PRINT");
}

sub doc {
  my($q) = @_;
  my $file = $q->{FILE};

  print Html->body();
  print Html->header2("$q->{MENU1}");
  if ($q->{DOC}) {
    Html->readHtdocs("${file}_doc", undef, "PRINT");
  } else {
    Html->readHtdocs($file, undef, "PRINT");
  }
}


sub ReleaseNotes {
  my($q) = @_;
  print Html->body();
  print Html->header2("doc.admin.release_notes");

  my($out, $l);
  opendir(DIR, System->get_home() . "/docs");
  my @files = readdir(DIR);
  closedir(DIR);
  my $list = "Select other file: ";
  my ($cnt, $first);
  foreach my $f (@files) {
    if ($f =~ /^ReleaseNotes/) {
       $first = $f if (!$first);
       $list .= "<a href=$Http::WEBPROC?GO=GUI::Navigation::ReleaseNotes&file=$f>$f</a> | ";
    }
  }
  if ($list) {
     chop($list); chop($list);
  }
  my $f1 = $q->{file} || $first;
  my $f2 = Html->find_file($f1, "docs");

  print $list;
  open(O, $f2);
  while ($l = <O>) {
    last if ($l =~ /MEDIA CONTENTS/);
    $out .= $l;
  }
  close(O);
  print "</center>\n<pre><b>File: $f1</b>\n$out";
}


# LEFT/RIGHT FRAME if needed

sub frame {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  print Html->text_header();
  
  if ($window ne "N") { # window eq B/S/N
     my $fr = $renv->{adjust_frames} eq "Y" ? 1:0;
     print <<EOF;
<frameset cols=$Style::LEFT_FRAME_WIDTH,* border=$fr>
    <frame src=$Http::WEBPROC?GO=GUI::Navigation::left_menu&MENU=$q->{MENU} name=main scrolling=auto>
    <frame src=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$q->{MENU} name=detail scrolling=auto>
</frameset>
EOF
  } else {
    GUI::Navigation::welcome($q);
  }
}

# LEFT MENU 

sub left_menu {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $nav = Navigation->read();
  my $style = $nav->{ROOT}{info}{style};
  my $js;
  my $cnt = 1;
  print Html->text_header();
  print "\n\n$style";
  my $ext = $Style::LEFT_GIF_EXT;

  if (exists $nav->{$q->{MENU}}) {
    my $nav1 = $nav->{$q->{MENU}};
    my $head = &menu_head( $nav1->{info}{title});
    my $out = "<table border=0 cellpadding=0 cellspacing=1 width=100%>";
    my @O = split(/,/, $nav1->{order});
    foreach my $el (@O) {
        my $item = $nav1->{items}{$el};
        next if ($item->{skip} && index($item->{skip}, "m") >= 0);

        my($url, $out0, $targ) = Navigation->read_url($item);
        $out .= $out0;
        my $target = $item->{target} || "detail";
        my $t = $out0 ? "" : ($targ || "target=$target");
        my $act = Navigation::active($item, $ruser, $renv);
        my $title = $item->{short} || $item->{title};
        if (($act == 2 || $act == 1) && $item->{separator}) {
           $out .= "<tr><td colspan=2>$item->{separator}</td>";
        }
        if ($act == 2) {
           $out .= "<tr><td valign=middle><img name=b$cnt src=gif/bout$ext.gif width=9 height=9>" .
          "</td><td><a href=\"$url\" $t onmouseover=bover($cnt) " .
          "onmouseout=bout($cnt) onclick=bclick($cnt)>$title</a></td>\n";
           $out .= "<tr><td></td>";
           $out .= "<tr><td></td>";
        } elsif ($act == 1) {
           $out .= "<tr><td valign=top><font color=silver>&nbsp;-</td><td><font color=silver>$title</td>\n";
           $out .= "<tr><td></td>";
           $out .= "<tr><td></td>";
        }
        $cnt++;
    }
    print $head;
    print $out;
    print "</table>";
  } else {
    print "Cannot access $q->{MENU} in navigation file!";
  }
}




# RIGHT MENU

sub welcome {
  my($q, $TOPDONE) = @_;

  my $renv   = System->get_renv();
  my $ruser  = System->get_ruser();
  my $sysLb =  Labels->read();
  $TOPDONE = $q->{TOPDONE} if (exists $q->{TOPDONE} && !$TOPDONE);
  print Html->text_header();

  my $window = $ruser->{window} || $renv->{window};
  my $nav    = Navigation->read();

  my $style = $nav->{ROOT}{info}{style};
  my $ix     = index($q->{MENU}, ".");
  my $tab    = substr($q->{MENU}, 0, $ix);
  my $crumb;
  if (!$TOPDONE && $window eq 'N') {
     $q->{ITEM} = $nav->{$q->{MENU}}{info} if ($nav->{$q->{MENU}});
     print Navigation::nf_top($q);
  }

  if (exists $nav->{$tab}) {
    if ($window eq 'N') {
     $crumb = "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$tab\">$nav->{$tab}{info}{title}</a> >";
    #} else {
    #  $crumb = "$nav->{$tab}{info}{title}.";
    }
  }
  if ($q->{MENU} ne 'ROOT') {
   if ($window eq 'N') {
     #$crumb = "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=ROOT\">$nav->{ROOT}{info}{title}</a> > $crumb";
   } else {
     #$crumb = "$nav->{ROOT}{info}{title} > $crumb";
   }
  }

  if (exists $nav->{$q->{MENU}}) {
    my $nav1 = $nav->{$q->{MENU}};
    my $run = $nav1->{info}{run};
    #my ($help, $u) = Html->help($nav1->{info}{help});
    my $help; # = "<script> function Xo_win(x){ var w=window.open('/rashttp?GO=GUI::Navigation::help&ROOT=$q->{MENU}','help','menubar=yes,scrollbars,resizable,width=600,height=700'); w.focus(); } </script> <a href=javascript:o_win()>$sysLb->{help}</a>";
    my $desc;
    if ($nav1->{info}{desc} ne $nav1->{info}{title}) {
       $desc = "<table border=0 width=$Style::WIDTH cellpadding=5 bgcolor=white><tr><td>
                  $nav1->{info}{desc}</table>" ;
    } else {
       $desc = "<table border=0><tr><td></table>";
    }
    $desc = "";
    if ($run) {
       my $ix = rindex($run, "::");
       my $p = substr($run,0,$ix);
       eval "require $p";
       $desc = &$run();
    }

    my $out =<<EOF;
     \n$style<body bgcolor="$Style::BGCOLOR" vlink=navy><center>
      <table border=0><tr><td></table>
      <table border=0 width=$Style::WIDTH cellpadding=2>
      <tr><td><font color=black>$crumb <b>$nav1->{info}{title}</td>
          <td align=right> $help </table>
      $desc
      <table border=1 width=$Style::WIDTH cellspacing=0 cellpadding=4>
      <tr><td colspan=2 bgcolor=$Style::DARK><img src=/gif/dot_clear.gif height=5></td>
EOF
    my ($links, $html) = Navigation->links($nav1, $ruser, $renv);
    $out .= $html;
    foreach my $l (@$links) {
       my $i = $l->[1];
       if ($l->[0] == 2) {
         my ($extra, $x, $b);
         if (substr($i->{url},0,1) eq ">") {
           my($links2) = Navigation->links($nav->{substr($i->{url},1)}, $ruser, $renv, "class=t10");
           $extra = "<table border=0 cellspacing=0 width=100%><tr>";
           my $per_cols = int($#$links2 / 2) + 1;
           for ($x=0; $x <= $#$links2; $x++) {
             if (($x % $per_cols) == 0) {
               $extra .= "</td><td valign=top width=50%>";
             }
             $extra .= "<i>$links2->[$x][2]</i><br>";
           }
           $extra .= "</table>"; $b = "<b>";
         }
         $out .= "<tr><td bgcolor=$Style::WELCOME_BG1 width=25% align=right>".
                 "[ $l->[2] ]</td><td bgcolor=white>$b $i->{desc} $extra</td>";
       } elsif ($l->[0] == 1) {
         $out .= "<tr><td bgcolor=$Style::WELCOME_BG1 width=25% align=right>".
                 "<font color=#404040>[ $l->[2] ]</td><td bgcolor=white>$i->{desc}</td>";
       }
    }
    $out .= "</table></table>";
    print $out;

  } else {
    print "Cannot access $q->{MENU} in navigation file!";
  }
}
       

use vars qw($TITLE);

sub get_titles {
  my($lang) = @_;
  if (exists $TITLE->{$lang}) {
     return $TITLE->{$lang};
  }
  my $file = System->get_home() . "/Lang/htdocs/Help/$lang/titles.txt";
  if (!-f $file) {
    $file = System->get_home() . "/htdocs/Help/titles.txt";
  }
  my ($l);
  if (open(O, $file)) {
     while ($l = <O>) {
        chop($l);
        my @a = split(/\t/, $l);
        $TITLE->{$lang}{$a[0]} = $a[1];
     }
  }
  close(O);
  return $TITLE->{$lang};
}

sub help_loop { 
  my($q, $sp, $titles, $item, $el, $act) = @_;
  my ($out, $x);
  my $cnt = 0;
  my $title0 = $item->{title};

  my @helps = split(/,/, $item->{help});
  if ($#helps > 1) {
     $DB::single = 1;
  }
  my $last = $q->{SUMMARY} ? 0 : $#helps;
  my $IN = "&INFRAME=1" if ($q->{INFRAME} || $q->{FRAME});
  $last = $#helps if ($#helps < $last);
  my $searchf = $q->{search};
  $searchf =~ s/(\W)/\\$1/g;
  my($first_title);

  for ($x=0; $x <= $last; $x++) {
       my $help = $helps[$x];
       my ($t, $t2, $ind);
       if ($cnt == 0) {
         $t = $title0;
         $t2 = $item->{desc};
         $first_title = $item->{title};
         $ind = "-";
       } else {
         $t2 = $t = $titles->{$help};
         $ind = "&nbsp;&nbsp;&nbsp;&nbsp;";
       }
       my ($c1, $c2);
       if ($act == 1) {
           $c1 ="<font color=gray>"; $c2 ="</font>";
       }
       my $found = 0;
       my $extra;
       if ($q->{search}) {
          my $file = &find_help_file($help);
          open(O1, $file); my @L = <O1>; close(O1);
          my $ss = "@L";
          $ss =~ s/$searchf/$found++/egi;
	  if ($x && $found){
	     foreach my $l (@L){
	       if($l =~ /table.*spacing/){
	          $l =~ s/<//egi;
	          $l =~ s/>//egi;
	          if($l =~ /.*trtd b(.*)/){
	             $extra = " > $1";
	          }
	       }
	     }
	  }
       }
       if (!$q->{search} || $found) {
         my $sch = Util->encode($q->{search});
         my $target = "target=help_main" if ($q->{FRAME});
         my ($url_name, $url);
         if ($q->{DOC}) {
           if ((index($item->{skip}, "m") < 0 || $item->{doc})) {
             print $out; $out = "";
             print "\n<a name=\"$el\">&nbsp;<br><page node=\"$el\">\n" if (!$q->{SUMMARY});
             $q->{file} = $item->{help}; $q->{ROOT} = $el;
             my($out, $cnt, $last, $a2) = GUI::Navigation::help2_display($q); # display doc
             if ($x == 0) {
               &print_module($a2, $item); #  display browser page
             }
             print "$out</UL>";
             print "&nbsp;<p>&nbsp;<br>";
           }
           last if ($x == 0);
         } elsif ($q->{NOHREF}) {
           $url_name = "$t$extra";
           $url = "<a href=#$el>$c1$url_name$c2</a>";
         } else {
           my $h1 = ($x == 0) ? $item->{help} : $help;
           $url_name = "$t$extra";
           $url = "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::help2&file=$h1&ROOT=$el&search=$sch$IN\" $target>$c1$url_name$c2</a>" . ($found? "&nbsp&nbsp;[$found]" : "");
         }
         next if (!$url_name);
         if ($q->{FRAME}) {
           $out .= "<tr><td nowrap>$sp$ind$url</td>\n";
         } else {
           $out .= "<tr><td>$sp$ind$url</td><td>$t2&nbsp;</td>\n";
         }
         $cnt++;
       }
   }
   if ($#helps < 0 && $q->{DOC} && (index($el, ".") != rindex($el, ".")) ) {
      print "<font color=red>No help file available for this page: $el</font><br>\n";
   }
   return ($out, $cnt);
}

# DOC 
sub print_module {
  my($crumbs , $item) = @_;
  my $q = {};
  my $found = 0;
  my(@urls, $cnt);
  push(@urls, $item->{url}); 
  my @u = split(/,/, $item->{doc_url}); # more pages that should be displayed in the doc
  push(@urls, @u); 
  foreach my $url (@urls) {
    if (substr($url,0,1) ne "/") {
       $cnt++;
       my $ix = index($url, "&");
       if ($ix > 0) {
         Http::parse(substr($url, $ix+1), $q, 1);
         $url = substr($url, 0,$ix) ;
       }
       my $ix = rindex($url, "::");
       if ($ix > 0) {
          my $mod = substr($url, 0, $ix);
          $mod =~ s/\:\:/\//g;
          eval {
            require "$mod.pm";
          };
          if (!$@) {
             print STDERR "$mod\n";
             print "<table border=0 cellspacing=0 cellpadding=2 width=100%>$crumbs</td>
                    <tr><td></td>
                    <tr><td>
                    <table border=1 cellspacing=0 cellpadding=0 width=100%><tr><td>";
             $crumbs = "";
             my $f = $url;
             $q->{DOC} = 1;
             &$f($q);
             print "</table></table></b></center>";
             print "<table border=0 cellspacing=0 width=99%><tr><td align=right><small>[ $url ]</table>";
             $found = 1;
          }
       }
    }
  }
  if (!$found) {
     print "$crumbs";
  }
  return $found;
}

sub find_help_file {
  my($f) = @_;
  my $renv  = System->get_renv();
  my $ruser = System->get_ruser();
  my $lang = $ruser->{language} || $renv->{language} || "en";
  my $L = $Html::LANG{$lang} || "english";
  
  my $file = System->get_home() . "/htdocs/Help/$L/$f.html";
  if (!-f $file) {
     $file = System->get_home() . "/htdocs/Help/$f.html";
  }
  return $file;
  
  # NOT USED
  #
  my $file = System->get_home() . "/Lang/htdocs/Help/$lang/$f.html";
  if (!-f $file) {
     $file = System->get_home() . "/htdocs/Help/$f.html";
  }
  return $file;
}
 
sub help_header {
   my($q) = @_;
   my $L = Labels->read("GUI::Navigation");
   return "";
}

sub help2 {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $lang = $ruser->{language} || $renv->{language};
  my $G    = Labels->read();

  my $window = $ruser->{window} || $renv->{window};
  my $nav = Navigation->read();

  print Html->body(undef, {body => 1, color => "white",extra => "leftmargin=3 marginleft=3", title => $G->{help} });

  $q->{INFRAME} ||= $q->{WIN};
  if (!$q->{FRAME} && !$q->{INFRAME}) {
   #print Html->header2("doc.guide.user_guide", undef, undef, undef, {noHeader => 1}) 
  } else {
   print &help_header($q);
  }

  my ($out, $cnt, $last, $a2) = &help2_display($q, $nav);

  if (!$cnt) {
    &help({ });
  } else {
    print "
    <table border=0 cellspacing=0><tr><td></td></table>
    <table border=0 cellspacing=0 cellpadding=0 width=100% bgcolor=white>$a2</table></center>";
    print  $out;
  }
}

sub help2_display {
  my($q, $nav) = @_;
  my ($l, $out, $cnt);
  $nav = Navigation->read() if (!$nav);

  my ($last, $a2) = &header_($q, $q->{ROOT}, $nav);

  my @F    = split(/,/, $q->{file});

  foreach my $f (@F) {
    my $file = &find_help_file($f);
    if (open(O, $file)) {
      my $cnt2 =0;
      while ($l = <O>) {
         if ($cnt2++ < 10 && $l =~ /^#include (.+)/) {
            open(O2, System->get_home() . "/htdocs/$1");
            my @LL = <O2>; close(O2);
            $out .= "@LL";
         } else {
           $l =~ s/<a name=\w+>//ig;
           #$l =~ s/<a href/<ahref/ig;
           #next if ($l =~ /<body/ || $l =~ /<html/ || $l =~ /DOCTYPE/ || $l =~ /META/);
           #$l =~ s/<\/*body>//g;
           #$l =~ s/<\/*html>//g;

           $l =~ s/<link rel/<linkrel/g;
           $l =~ s/ src="/xsrc="/g;
           $l =~ s/#CCCCFF/#E0E0E0/g;
           $l =~ s/<a href="(.*)">/&fix_see_also($1)/egi;
           #$l =~ s/<script /<Xscript /g;
           $l =~ s/<div align="right">/<div>/g;
           $l =~ s/cellspacing="\d+" /cellspacing=1 /ig;
           if ($q->{search}) {
             my $searchf = $q->{search};
             $searchf =~ s/(\W)/\\$1/g;
             $l =~ s/($searchf)/<font color=red><u>$1<\/u><\/font>/ig ;
           }
           $out .= $l;
         }
      }
      close(O);
      $cnt++;
    }
  }
  $out .= "<table border=0 cellspacing=0 width=99%><tr><td align=right><small>[ $q->{ROOT}:$q->{file} ]</table>";
  return ($out, $cnt, $last, $a2);
}
sub fix_see_also {
  my($q) = @_;
  if ($q =~ /(stor[\w\-]+)\.html/) {
    my $f = $1;
    return "<a href=/rashttp?GO=GUI::Navigation::help2&file=$f>";

  } elsif ($q =~ /(\w+)\.html/) {
    return "<a href=/rashttp?GO=GUI::Navigation::help2&file=$1>";

  } else {
    return "<ahref $q>";
  }
}

#  Navigation->help({ ROOT => "admin", SUMMARY => 1, FRAME=>1});
sub help {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $role = $ruser->{role};
  my $window = $ruser->{window} || $renv->{window};
  my $nav = Navigation->read();
  my $lang = $ruser->{language} || $renv->{language};
  my $F = System->get_home() . "/DATA/toc_$lang.html";
  my $G = Labels->read();
  print Html->body(undef, {color => "#F0F0F0", margin => "vlink=navy"} ) if (!$q->{NOHREF});


  $q->{INFRAME} ||= $q->{WIN};
  if (!$q->{FRAME} && !$q->{INFRAME}) {
    #print Html->header2("doc.guide.user_guide", undef, undef, undef, {noHeader => 1});
  } elsif ($q->{FRAME}) {
    my ($b1,$b2, $b3, $b4);
    if ($q->{SUMMARY} == 1) {
       $b1 = "<b>"; $b3 = "</b>";
    } else {
       $b2 = "<b>"; $b4 = "</b>";
    }
    print "<table border=0 cellpadding=3 width=110% bgcolor=$Style::DARK>
    <tr><td align=right><font color=white>
    [ <a href=\"/rashttp?GO=GUI::Navigation::help&SUMMARY=0&FRAME=1\"><font color=white>${b2}$G->{open}$b4</font></a> | 
    <a href=\"/rashttp?GO=GUI::Navigation::help&SUMMARY=1&FRAME=1\"><font color=white>${b1}$G->{close}$b3</font></a> ]&nbsp;
    <tr><td></td>
    <tr><td></td>
    </table>
    ";
  } else {
    print &help_header();
  }
  my ($tab_list, $sub_tab);
  my $cnt = 0;
  my ($i, $out, $sub);
  my $toc;
  my $opt = "1 cellspacing=0 class=Tbl";

  if ($q->{FRAME}) {
    $toc = "<table border=$opt width=110% cellpadding=2>";
  } else {
    $toc = "<table border=$opt width=$Style::WIDTH bgcolor=white cellpadding=2>";
  }
  my $titles = &get_titles($lang);

  my($toc0,$cnt0) = &help_($titles, $ruser, $renv, $nav, $q->{ROOT} || "ROOT", 0, $q);
  $toc .= $toc0;
  $toc .= "</table>";
  print $toc;
  if (!$cnt0  && !$q->{NOHREF}) {
    print Html->warning("No help found for '$q->{search}'");
  }
}

sub header_ {
  my($q, $node, $nav) = @_;
  my ($base, $el);
  my ($v, $x,$crumb, $last);
  my $nav1 = {};
  my $G = Labels->read();
  my @a = split(/\./, $node);
  my $IN = "&INFRAME=1" if ($q->{INFRAME} || $q->{FRAME});
  my $arrow;
  for ($x=0; $x <= 1; $x++) {
    $v .= "." if ($x);
    $v .= $a[$x];
    last if (!$a[$x]);
    if ($a[$x] ne "ROOT") {
      $nav1  = $nav->{$v};
      my $cr = $nav1->{info}{title};
      $last  = $cr;
      if ($cr) {
        $crumb .= "$arrow<a href=\"$Http::WEBPROC?GO=GUI::Navigation::help&ROOT=$v$IN\">$cr</a>";
        $arrow = " > ";
      } elsif (exists $nav->{$a[$x-1]}{items}{$a[$x]} ) {
        $crumb .= "$arrow$nav->{$a[$x-1]}{items}{$a[$x]}{title}";
        $arrow = " > ";
      }
    }
  }
  if ($#a == 2 && $nav1) {
     $last = $nav1->{items}{$a[2]}->{title}; $last =~ s/ /&nbsp;/g;
     $crumb .= " > $last";
  }

  #my $start = ($q->{NOHREF}||$q->{DOC}) ? "" : "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::help&SUMMARY=1$IN\">$G->{help}</a>";
  my $start;
  my ($x1, $x2, $frm);
  if (!$q->{INFRAME}) {
    $x1  = "<a href=$Http::WEBPROC?GO=GUI::Navigation::help&SUMMARY=1$IN>$G->{index}</a> | ";
  }
  $x2  = "<a href=$Http::WEBPROC?GO=GUI::Navigation::help$IN>$G->{toc}</a>";
  if ($q->{WIN}) {
    $frm = "<a href=\"/rashttp?GO=GUI::Navigation::help_frame2&ROOT=$q->{ROOT}&file=$q->{file}&INFRAME=1\">$G->{frame}</a> | ";
  }
  if ($q->{search} && length($q->{search}) < 3) {
    delete $q->{search};
    $q->{SUMMARY} = 1;
    print Html->warning($G->{enter3});

  } elsif ( index(",body,title,href,html,", ",$q->{search},") >= 0) {
    delete $q->{search};
    $q->{SUMMARY} = 1;
    print Html->warning("Invalid search word!");
  }
  my $search = $q->{search} || $G->{search};
  my $x3 =<<EOF;
    <input type=hidden name=GO value=GUI::Navigation::help>
    <input type=hidden name=INFRAME value=$q->{INFRAME}>
    <input type=text name=search size=12 value=\"$search\"
           onfocus="if(this.value==this.defaultValue) this.value='';">
    <xinput type=submit name=ACTION_search value="$G->{go}">
EOF

  my ($hc,$big, $form);
  if ($q->{NOHREF} == 9) {
    return ($last, "<tr><td colspan=2>");

  } elsif ($q->{NOHREF}) {
    $big   = "<big>";
    $crumb = substr($crumb, 2);
    $hc    = "";
    $form = "<td align=right nowrap>[ <a href=#_TOP>Top</a> ]</td>" if ($crumb);
  } else {
    $hc = "bgcolor=#F0F0F0";
    $form = "<td align=right nowrap>[ $frm $x1 $x2 ] &nbsp; $x3</td>";
  }

  $crumb =~ s/ href=/ nothing=/g if ($q->{NOHREF});

  return ($last, "<tr><td colspan=2 hc>
   <table border=0 cellspacing=0 cellspacing=0 width=100%>
        <tr><td valign=top><form autocomplete=off>$big<b>$start $crumb</td>$form</form>
   </table>
   <table border=0><tr><td></table>
    ");
  
}

sub help_frame2 {
  my($q) = @_;

  print Html->text_header();
  print <<EOF;
  <frameset border=0 rows=80,*>
     <frame src=/htdocs/help_top.html scrolling=off  marginheight=0 marginwidth=0 leftmargin=0 topmargin=0>
   <frameset cols=230,* border=1>
       <frame src=/?GO=GUI::Navigation::toc&ROOT=$q->{ROOT}&file=$q->{file} name=help_left scrolling=auto>
       <frame src=/?GO=GUI::Navigation::help2&ROOT=$q->{ROOT}&file=$q->{file}&INFRAME=$q->{INFRAME} name=help_main scrolling=auto>
   </frameset>
</frameset>
EOF

}


sub toc {
  my($q) = @_;

  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $role = $ruser->{role};
  my $window = $ruser->{window} || $renv->{window};
  my $nav = Navigation->read();
  my $lang = $ruser->{language} || $renv->{language};
  my $F = System->get_home() . "/DATA/toc_$lang.html";
  my @M;
  my $G = Labels->read();

  print Html->body(undef, {body => 1, color => "#F0F0F0", extra => "leftmargin=3 marginwidth=3" });
  print "</center>";
  &toc_($ruser, $renv, $nav, "ROOT", "", \@M);

  print "<table border=0 cellpadding=2 cellspacing=1 width=110%>
    <tr><td><b>$G->{index}</td>
    <td align=right>
    [ <a href=/rashttp?GO=GUI::Navigation::toc&level=10>$G->{open}</font></a> | 
      <a href=/rashttp?GO=GUI::Navigation::toc&level=0>$G->{close}</font></a> ]&nbsp;
    <tr><td></td>
    <tr><td></td>
    </table>
    ";

  require Html::Tree;
  my $tree =  Html::Tree->new({
                this => "$Http::WEBPROC?GO=GUI::Navigation::toc",
                   q => $q,
              sysgif => '/gif',
             target  => "help_main",
              nosort => 1,
                name => "ROOT"});

  print $tree->read(\@M, undef, $q->{ROOT});

}

sub toc_ {
  my($ruser, $renv, $nav, $node, $level, $M) = @_;
  my($i);
  my $nav1 = $nav->{$node};
  my @O = split(/,/, $nav1->{order});
  my $this = $nav1->{info}{title};
  $this = "" if (!$this eq "Start");

  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];
    my $item = $nav1->{items}{$el};
    next if (index($item->{skip}, "h") >= 0);
    my $act = Navigation::active($item, $ruser, $renv);
    next if ($act == 0);

    if (substr($item->{url},0,1) eq ">") {
       my $dir = $this eq "Start" ? $item->{title} : "$this/$item->{title}";
       &toc_( $ruser, $renv, $nav, substr($item->{url},1), $dir, $M);

    } elsif ($item->{help}) {
      my $url = "$Http::WEBPROC?GO=GUI::Navigation::help2&file=$item->{help}&ROOT=$node.$el&INFRAME=1";
      my $t1 = $item->{title}; 
      $t1 =~ s/[ \/]/&nbsp;/g;
      push(@$M, ["$level/$t1", $url, undef, undef, undef, "$node.$el" ]);
    }
  }
}


sub help_ {
  my($titles, $ruser, $renv, $nav, $node, $level, $q) = @_;
  my $out;
  my $nav1 = $nav->{$node};
  my @O = split(/,/, $nav1->{order});

  if ($q->{NOHREF} && $q->{DOC}) {
     if ($level == 1) {  # admin, monitor etc..
     }
  }
  if ($level == 0 && !$q->{FRAME}) {
     my ($last, $out0) =  &header_($q,$node, $nav) ;
     $out .= $out0;
     if (index($node, ".") > 0) {
        $out .= "<tr bgcolor=$Style::LIGHT><td colspan=2><b>$last</td>";
     }
  }
  my $scol =  "bgcolor=$Style::LIGHT";
  my $FR = "&INFRAME=1" if ($q->{FRAME} || $q->{INFRAME});
  my ($last, $i, $cnt);
  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];

    if ($q->{FILTER}) {  # request a subset of the doc document
       my $l1 = length($q->{FILTER});
       my $v  = "$node.$el";
       $v     = "ROOT.$v" if (substr($v,0,4) ne "ROOT");
       my $l2 = length($v);
       my $l3 = $l1 < $l2 ? $l1 : $l2;  
       next if (substr($v,0,$l3) ne substr($q->{FILTER},0,$l3) );
    }
    my $item = $nav1->{items}{$el};
    my $sp = "&nbsp;&nbsp;&nbsp;" x ($level -1) if ($level > 0);
    #next if ($item->{skip} && index($item->{skip}, "t") >= 0);

    my $act = Navigation::active($item, $ruser, $renv);
    next if ($act == 0);

    if (substr($item->{url},0,1) eq ">") {
      my $t1;
      my $target = "target=help_main" if ($q->{FRAME});
      my $u;
      if ($q->{NOHREF}) {
         $u = $item->{title};
      } else {
         $u = $q->{search} ? $item->{title} : 
                "<a href=$Http::WEBPROC?GO=GUI::Navigation::help&ROOT=" . 
                substr($item->{url},1) . "$FR $target>$item->{title}</a>";
      }
      if ($level == 0) {
        $t1 = "<tr><td></td><tr $scol><td>$sp<b>$u</td>";
        $t1 .= " <td>&nbsp;<b>$item->{desc}</td>\n" if (!$q->{FRAME});
      } else {
        $t1 = "<tr><td>$sp-$u</td>";
        $t1 .= " <td>&nbsp;$item->{desc}</td>\n" if (!$q->{FRAME});
      }
      if (!$q->{SUMMARY} || $level < 1) {
        my($out1, $cnt1) = &help_loop($q, $sp, $titles, $item, "$node.$el", $act) ;
        $out .= $out1;
        $cnt += $cnt1;
      }
      my ($out0, $cnt0) = &help_($titles, $ruser, $renv, $nav, substr($item->{url},1), $level+1, $q);
      $out .= $t1 if ($cnt0);
      $out .= $out0;
      $cnt+= $cnt0;

    } else {
      if (( $q->{SUMMARY} && $level == 1) ||
          (!$q->{SUMMARY} || $level <  1)) {
         my($out1, $cnt1) = &help_loop($q, $sp, $titles, $item, "$node.$el", $act);
         $out .= $out1;
         $cnt += $cnt1;
      } else {
         $cnt++;
      }
    }
    $last = $item;
  }
  return ($out, $cnt);
}



sub site {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $role = $ruser->{role};
  my $window = $ruser->{window} || $renv->{window};
  my $nav = Navigation->read();
  print Html->body();
  print Html->header2('doc.other.site_map');

  my ($tab_list, $sub_tab);
  my $cnt = 0;
  my ($i, $out, $sub);
  print "<table border=0 cellspacing=1 width=$Style::WIDTH bgcolor=white cellpadding=2>";

  print &site_($q, $ruser, $renv, $nav, 'ROOT', 0);
  print "</table>&nbsp;<p>&nbsp;";
}

sub site_ {
  my($q, $ruser, $renv, $nav, $node, $level) = @_;
  my $out;
  my $nav1 = $nav->{$node};
  my @O = split(/,/, $nav1->{order});
  my ($last, $i, $level0_cnt);
  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];
    my $item = $nav1->{items}{$el};
    my $sp = "&nbsp;&nbsp;&nbsp;" x ($level -1) if ($level > 0);
    next if ($item->{skip} && index($item->{skip}, "s") >= 0);
    my $act = Navigation::active($item, $ruser, $renv);
#   print "$item->{url}, $item->{role}, $item->{rack}, $act<br>";
    next if ($act == 0);
    $level0_cnt++;
    if ($level == 0) {
      if ($level0_cnt % 5 == 0) {
        $out .= "<tr><td valign=top>";
      } else {
        $out .= "</td><td valign=top>";
      }
    }

    if (substr($item->{url},0,1) eq ">") {
      if ($level == 0) {
        $out .= "<table border=0 cellspacing=0 cellpadding=2 bgcolor=$Style::DARK width=100%><tr><td>" . 
                 "$sp<font color=white><b>$item->{title}</b></font></table>\n";
      } else {
        $out .= "$sp<b>$item->{title}</b><br>\n";
      }
      $out .=  &site_($q, $ruser, $renv, $nav, substr($item->{url},1), $level+1);
    } elsif (substr($item->{url}, 0, 1) eq "/")  {
      if ($act == 2) {
        $out .= "$sp<a href=$item->{url}>$item->{title}</a><br>\n";
      } elsif ($act == 1) {
        $out .= "$sp<font color=gray>$item->{title}</font><br>\n";
      }
    } else {
      if ($act == 2) {
        $out .= "$sp<a href=$Http::WEBPROC?GO=$item->{url}>$item->{title}</a><br>\n";
      } elsif ($act == 1) {
        $out .= "$sp<font color=gray>$item->{title}</font><br>\n";
      }
    }
    $last = $item;
  }
  return $out;
}


  

sub menu_head {
  my($name) = @_;
  my ($corners, $W);
  my $renv = System->get_renv();
  $W = "110%";
  my $ext = $Style::LEFT_GIF_EXT;
  if (substr($renv->{color_scheme},0,4) eq "hci2"){
    $corners = ""; 
  } else {
    $corners = " <tr> <td valign=top><img src=/gif/rcorner2.gif ></td>
      <td align=right valign=top><img src=/gif/lcorner2.gif></td>";
  }

  my $head =<<EOF;
<head>
 <script> var click = 0;  function pic(id,gif) {     if (navigator.appName == "Netscape") {       document.images["b" + id].src = "/gif/" + gif + "$ext.gif";     } else {       document.all["b" + id].src = "/gif/" + gif + "$ext.gif";     }  }  function bover(id) {     pic(id,'bover');   }  function bout(id) {     if (click) {        pic(click, 'bclick');     }     if (id == click) {        return;     }     pic(id,'bout');   }  function bclick(id) {     if (click) {       pic(click,'bout');     }     click = id;     pic(id,'bclick');   } 
</script>
</head>
<body bgcolor=$Style::LEFT_BG link=$Style::LEFT_FG vlink=$Style::LEFT_FG  alink=red leftmargin=0 marginwidth=0 marginheight=0 topmargin=0><center>
 <table border=0  cellspacing=0 cellpadding=0 bgcolor=$Style::LEFT_HEAD_BG width=$W>
    <tr><td colspan=2><center>
        <table border=0 cellspacing=0 cellpadding=2 width=70%>
           <tr><td><center><font color=$Style::LEFT_HEAD_FG><b>$name</table>
              $corners
        </table>
    <table border=0><tr><td></table>
EOF

  return $head;
}



1;
