package GUI::Providers;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use System;
use Html::Tabs;
use strict;

sub display {
  my($q, $post, $util) = @_;
  my(@M, @tabs, $out);

  my $DEV_FILTER = ",SAE,SSRR,";
  my $MAS_FILTER = ",NetConnect,SunMC,SAE,";
  my $GRIZ_FILTER = ",SunMC,SSRR,SAE,Trap,";

  print Html->body();
  my $L = Labels->read('Provider')->section('names');
  my $G = Labels->read();

  if (my $err = Roles->verifyRole($q, "admin")) {
     print $err;
     return;
  }

  my ($renv) = PDM::ConfigFile->read();
  print Html->header2("admin.not_maint.providers", undef , undef, " ");

  opendir(O, System->get_home() . "/lib/Provider");
  my @list = ();
  my $G = Labels->read();
  my @list0 = readdir(O); closedir(O);
  my $cnt = 1;
  my ($form, $pack);
  $q->{option} = 1 if (!$q->{option});
  my $select = "<select name=option onchange=form.submit() >";

  foreach my $el (sort @list0) {
     next if ($el !~ /.pm$/);
     my $name = substr($el,0,-3);
     my $name0 = lc($name);
     next if ($name eq "NSM" || $name eq "Email");

     if ($renv->{solution} eq "N") {
       next if (index($DEV_FILTER, ",$name,") >= 0);
     } elsif ($renv->{solution} eq "se2") {
       next if (index($MAS_FILTER, ",$name,") >= 0);
     } elsif ($renv->{solution} eq "se99") {
       next if (index($GRIZ_FILTER, ",$name,") >= 0);
     }

     if (!(eval "require \"Provider/$name.pm\"")) {
       print Html->warning("Provider $name: $!");
     }
     if ($q->{option} eq $cnt) {
         my $module = "Provider::$name";
         $form = $module->UPDATE($q);
         ($renv) = PDM::ConfigFile->read();
         $pack = $name;
     }
     my $module = "Provider::$name";
     my $desc   = $L->{$name0};
     my $flag;
     if ($module->can("ISACTIVE")) {
        $flag = $module->ISACTIVE($renv);
        if ($flag eq "NA") {
           next;
        }
     } else {
        $flag = ($renv->{"pro.$name0.active"} eq "Y")? "<b>($G->{mode_on})</b>":"($G->{mode_off})";
     }
     my $sel = "selected" if ($cnt == $q->{option});
     $select .= "<option value=$cnt $sel>$desc $flag</option>";
     $cnt++;
  }
  $select .= "</select>";

  my($info) = Util->readHtdocs("provider_$pack");

  my $go = Html::Screen->submitButton('ACTION', $G->{go});
  print "\n<table border=0 cellspacing=0 cellpadding=0><tr><td><form>
             <input type=hidden name=GO value=GUI::Providers::display>
         </table>
         <table border=0 cellspacing=0 cellpadding=1 width=$Style::WIDTH>
        <tr><td>
             $L->{sel2}: <b>$select </td>
        </table>";
  print "<table border=0 cellspacing=0 cellpadding=0><tr><td></form></table>";
  print "<table border=0 bgcolor=#F0F0F0 width=$Style::WIDTH cellpadding=0><tr><td>$info</table>";
  print $form;

}

1;
