package GUI::Test;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use Util;
use AutoForm;
use Roles;
use strict;
use TO;
use TO::Applet;
use GUI;
use Diag;
use Tasks;
use Tests;
use Cache;
use Html::List;
use Html;
use GUI::Graph;
use GUI::ProcMgr;
use Html::Tabs;
use System;
use Scheduler;
use Data::Dumper;

sub list_frame {
  my($q) = @_;
  my($renv) = System->get_renv();
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  if ($window ne "B") {
     GUI::Test::from_list($q);
  } else {
     print Html->text_header();
     print <<EOF;
<frameset cols=*,37% border=0>
    <frame src=$Http::WEBPROC?GO=GUI::Test::from_list name=main scrolling=auto marginwidth=1 marginheight=1>
    <frame src=empty.html name=details scrolling=auto  xmarginheight=1>
</frameset>

EOF
  }
}

sub frame {
  my($q) = @_;
  my($renv) = System->get_renv();
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  my $scroll = $renv->{topo_mode} eq "G" ? "auto" : "no";

  if ($window ne "B") {
     $q->{LINKH} = 1;
     GUI::Graph::run3($q);
  } else {
     print Html->text_header();
     print <<EOF;
<frameset cols=*,37% border=0>
    <frame src=$Http::WEBPROC?GO=GUI::Graph::run3&LINKH=1 name=main scrolling=$scroll marginwidth=1 marginheight=1>
    <frame src=/graph_help.html name=details scrolling=auto  xmarginheight=1>
</frameset>
EOF
  }
}


sub NUtopo {
  my($q) = @_;
  $q->{LINKH} = 1;
  GUI::Graph::run3($q);
  return;
# foreach my $x (keys %$q) {print "$x=$q->{$x}<br>"}

  print "\n<body  bgcolor=white link=blue alink=blue vlink=blue marginheight=0>
    <script>
    function win2(t) {
      var b = '$Http::WEBPROC?GO=GUI::Graph::search&target=diag&topo=' + t;
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=300,height=600');
      O.focus();
    }
    </script>
";
  my($renv) = System->get_renv();

  my($select_host, $filter) = GUI->topoPage($q);
# my($selected, $head) = GUI->test_head($q);

  my $links =  "<a href=javascript:win2('$q->{topo}')>Search</a> | <a href=$Http::WEBPROC?GO=GUI::Graph::run3>Topo</a>&nbsp;";
  my $header = "<table border=0 cellspacing=0 cellpadding=0 bgcolor=#F0F0F0 width=100%>
   <tr><td nowrap width=40%>
       <form><input type=hidden name=GO value=GUI::Test::topo>
       <b>&nbsp;&nbsp;Host:$select_host Filter:$filter
      </td><td><small><b>".
          Html::Screen->submitButton('ACTION', "GO") . 
   "<td align=right>$links</td>
   <tr><td></td>
   </table>";
  
  my($o1, $meta);

  my($out2, $running) = TO::Applet->genAppletData($q, 1); # returns <parms ...
  if ($running) {
     my $ref = $renv->{'test.refresh_rate'} || 60;
     #$meta = "<meta http-equiv=Refresh content=\"$ref;URL=$Http::WEBPROC?GO=GUI::Test::topo\">";
  }

  my $current = $q->{topo};
  my($applet, $parm1, $parm2);
  my $zoom = $q->{zoom}  + 0;

  $applet = System->appletHeader("code=VertexApplet.class codebase=Topo archive=topo22.jar", 6,40);

  $parm1 =<<EOF;
  <param name=url value="GETX=GUI::Graph::topos&topo=$current&FILTER=$q->{FILTER}">
  <param name=urlRefresh value="GET=GUI::Graph::topos&topo=$current">
  <param name=timeRefresh value="10000">
  <param name=circle value="$q->{key}">
  <param name=showLinkHandle value=1>
  <param name=drop1 value="Test |details|g|GO=GUI::Test::get_test&TAB=1&topo=$current">
  <param name=drop2 value="Current Tests|details|gh|GET=GUI::Test::show_tests&topo=$current">
  <param name=drop3 value="List Members|details|has|GET=GUI::Graph::report&topo=$current">
  <param name=drop4 value="DrillDown on|main|hsa|GO=GUI::Test::topo&topo=$current&FILTER=$q->{FILTER}">
  <param name=drop5 value="Report on|details|hg|GET=GUI::Graph::report&topo=$current">
  <param name=drop6 value="Discman on|details||GET=GUI::Graph::details&topo=$current">
  <param name=drop7 value="Alerts|details|hg|GET=GUI::Graph::report&Roption=2&topo=$current">

  <param name=ldrop1 value="Link Test|details||GET=GUI::Test::testlink&topo=$current">
  <param name=ldrop2 value="Display Error|details|h|GET=GUI::Graph::fibrelog&topo=$current">
  <Xparam name=ldrop3 value="Clear Error|t|r,h|GET=GUI::Graph::clearlog&topo=$current">
  <param name=browser value="sun">
EOF

   print $meta .  $header .  $applet .  $parm1 .  $out2 . " </applet> </form>";
  
}
# Exclude following tests from linktest if one node is of the following:
my $LT_EXCLUDE = ",hub,d2,group,inrange,dsp,";

# Create a list of nodes to exclude from linktest if both nodes
# are the same type.
my $LT_EXCLUDE_END_NODE = ",mcdata,";

sub get_testlink {
  my($q) = @_;
  my (@T, @K, @P);
  my(@node, @PORT, $x);
  my $Config = PDM::ConfigFile->read();
  my $L = Labels->read('GUI::Test')->section('get_test_link');

  if ( my $deny = Roles->verifyRole($q, "test")) {
     print Html->body();
     print $deny;
     return;
  }
  if ($q->{ACTION_se} && $q->{startend}) {
     ($q->{start}, $q->{end}) = split(/\|/, $q->{startend});
  }
  ($T[1], $K[1], $P[1]) = split(/:/, $q->{start});
  ($T[2], $K[2], $P[2]) = split(/:/, $q->{end});

  print Html->body();
  delete $q->{TAB};
  print Html->header2('diagnose.test.topo_test');

  my $ev_out;
  foreach my $k0 ("$T[1]:$K[1]", "$T[2]:$K[2]") {
    my $ev_list = State->components($k0);
    foreach my $ev0 (keys %$ev_list) {
       if ($ev0 =~ /fc_link$/) {
          my $v =  $ev_list->{$ev0}[1];
          $v =~ s/Detector:/<td><b>Detector:<\/b>/;
          $v =~ s/Link:/<br><b>Link:<\/b>/;
          $ev_out .= "<tr><td width=40%>$v</td>";
       }
    }
  }
  print "<table border=1 width=$Style::WIDTH cellspacing=0>$ev_out</table>&nbsp;" if ($ev_out);

  if ( index($LT_EXCLUDE, ",$T[1],") >= 0){
       print Html->error($L->expand('test_not_avail', "$T[1]"));
       return;
  }
  if ( index($LT_EXCLUDE, ",$T[2],") >= 0){
       print Html->error($L->expand('test_not_avail', "$T[2]"));
       return;
  }

  if ( index($LT_EXCLUDE_END_NODE, ",$T[1],") >= 0 &&
       index($LT_EXCLUDE_END_NODE, ",$T[2],") >= 0 ) {
       print Html->error($L->{test_not_avail_on_nodes});
       return;
  }


  my $to = TO->readTopo($q->{topo});
  ($node[1], $PORT[1]) = $to->nodeByName($q->{start});
  ($node[2], $PORT[2]) = $to->nodeByName($q->{end});
  if (!$node[1] || !$node[2]) {
     print Html->error("Invalid node(s)");
     return;
  }
  if (exists $node[1]->{info}{datahost} || exists $node[2]->{info}{datahost}) {
     print Html->error($L->{test_not_avail_on_nodes});
     return;
  }
  if ($node[1]->{portInfo}[0]{portType} eq "scsi" || 
      $node[2]->{portInfo}[0]{portType} eq "scsi") {
     print Html->error($L->{test_not_avail_scsi});
     return;
  }
       
     
  my $node1Name = $node[1]->name();
  my $node2Name = $node[2]->name();
  my $node1Port = $node[1]->portLabel($PORT[1]);
  my $node2Port = $node[2]->portLabel($PORT[2]);

  my $mto = TO->readTopo("MERGE-MASTER");
  if ($mto) {
    my ($m_n1, $m_port1) = $mto->nodeByName($q->{end});
    if ($m_n1) {
      my $m_ports = $m_n1->port();
      my $m_target = $m_ports->[$m_port1];
      if (substr($m_target,0,6) eq "switch" && $m_target ne $q->{start}) {
         print "<table border=1 cellspacing=0 cellpadding=4 width=95% bgcolor=white>
           <tr><td>
              <b><font color=red>" .
               $L->expand('cannot_run', $m_target) . 
              "</table>";
         return;
      }
    }
  }
  my $list = Scheduler->processList("ST", "*", 'O');
  if ($#$list >= 0) {
        print Html->info($L->{err_interactive}); 
        return;
  }

  if (!$node[1] || !$node[2]) {
     print "<font color=red>" . $L->expand('err_no_id', $q->{start}, $q->{end});
     return;
  }
  my $n_ports = $node[1]->port();
  my $link_select = "<select name=startend>";
  my $dev = $Config->deviceByKey($node[1]->name());
  my $name;
  if ($dev) {
    $name = $dev->{name};
  } else {
    $name = $node[1]->name();
  }
  for ($x=0; $x <= $#$n_ports; $x++) {
      my $p = $n_ports->[$x];
      next if (!$p);
      my $s1 = $node[1]->name() . ":$x|$p";
      my $sel = ($p eq $q->{end})? "selected":"";
      $link_select .= "<option $sel value=\"$s1\">$name:$x</option>\n";
  }
  $link_select .= "</select>";
  my $n1 =  $node[1]->id();
  my $n2 =  $node[2]->id();
  my $xx = index($n1, " "); $n1 = substr($n1,$xx) if ($xx > 0);
  $xx = index($n2, " "); $n2 = substr($n2,$xx) if ($xx > 0);

  my $cache = Cache->read('tests','tests');
  if (!defined($cache)){
     $cache = {};
     $cache->{DEFAULTS}{'v'} = 1;
  }
  my $email_address = $cache->{DEFAULTS}{'#EMAIL'};
  my $option_email;
  $option_email = "value=" . $email_address if ( $email_address );
  my $verbose = $cache->{DEFAULTS}{'v'};
  my $option_verbose = "checked" if ( $verbose );
  $q->{PATTERN} = "0x7e7e7e7e" if (!$q->{PATTERN});
  $q->{PTYPE} = "critical" if (!$q->{PTYPE});
  my $ptype = Html->makeSelect("PTYPE", "user|critical|all", $q->{PTYPE});

  print "
   <script>
  function openw(a) {
    var b = '$Http::WEBPROC?GO=GUI::Test::man&test=' + a;
    var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=500,height=500');
    O.focus();
  }
   </script>
   <table border=1 cellspacing=0 width=95% bgcolor=white>
           <tr>
           <td colspan=2 bgcolor=$Style::DARK>
     <table border=0 cellspacing=0 width=100%>
      <tr><td><form>
         <input type=hidden name=GO value=GUI::Test::get_testlink>
         <font color=white><b>$L->{l_link} </td>
      <td align=right><font color=white>
         [ <a href=\"javascript:openw('linktest')\"><font color=white>ManPage</font></a> ]
     </table>
           <tr><td align=right bgcolor=$Style::LIGHT>$L->{l_start}: </td><td>$node1Name $node1Port<br>$n1" .
           "<tr><td align=right bgcolor=$Style::LIGHT>$L->{l_end}: </td><td>$node2Name $node2Port<br>$n2" .
           "<tr><td align=right bgcolor=$Style::LIGHT>$L->{l_type}: </td>
               <td>$ptype
           <tr><td align=right bgcolor=$Style::LIGHT>$L->{l_user}: </td>
               <td><input type=text size=10 name=PATTERN value=\"$q->{PATTERN}\"></td>

           <tr><td colspan=2><b>&nbsp;$L->{l_gen}: </td>
           <tr><td align=right bgcolor=$Style::LIGHT>$L->{l_verb}: </td>
               <td><input type=checkbox name=VERBOSE $option_verbose></td>
           <tr><td align=right bgcolor=$Style::LIGHT>$L->{l_email}: </td>
               <td><input type=text name=EMAIL $option_email size=20></td>
           </table>";

  my $renv = $Config->renv();
 
  my (@PARM, $dev1, $dev2, $ip, $fc, $ix);
  my ($warns, $errs);

  my $isl = 0;
  if ($T[1] eq "switch" && $T[2] eq "switch") {
     my $ports = $node[1]->port();
     my $l = "$T[2]:$K[2]";
     foreach my $p (@$ports) {
           if (substr($p, 0 , length($l)) eq $l) {
              $isl++;
           }
     }
  }
  for ($ix = 1; $ix <= 2; $ix++) {
    my $n      = $node[$ix];
    my $class0 = $n->class0();
    if ($T[$ix] eq "host") {
       my $ip     = $n->info("ipno") || substr($n->info("name"),5);
       my $pi     = $n->portInfo();
       my $driver = $pi->[$PORT[$ix]]{DriverName};
       my $path   = $pi->[$PORT[$ix]]{path};
       my $bitMode = $n->info("bitMode");
       $path = substr($path,1) if (substr($path,0,1) eq " ");
       $PARM[$ix] = "driver=$driver|type=hba|ip=$ip|path=$path|monHost=$ip|bitMode=$bitMode|key=$n->{info}{name}";

    } elsif ($class0 eq "switch") {
       $dev1 = $Config->deviceByKey($K[$ix]);
       if (!$dev1) {
         $warns .= "switch:$K[$ix] not in ConfigFile, may not be monitored, ";
       }
       my $ni = $n->{info};
       my $monH = $dev1->{hostIpno} || $n->info("host");
       if ($ni->{sw_remote_fcaddr} && $ni->{sw_remote_fcaddr} ne "0x0" &&
           $dev1->{primary} ) {
          $ip = $ni->{sw_ipAddr_remote}; $fc = $ni->{sw_remote_fcaddr};
       } else {
          $ip = $ni->{sw_ipAddr}; $fc = "";
       }
       my $tt = $n->type();
       $PARM[$ix] = "type=$tt|ip=$ip|monHost=$monH|port=$PORT[$ix]|fcaddr=$fc|WWN=$K[$ix]|name=$dev1->{name}|key=$dev1->{key}";


    } else {
       my $logical;
       my $pi = $node[$ix]->portInfo();
       my $di = $node[$ix]->diskInfo();
       $dev1 = $Config->deviceByKey($K[$ix]);
       if (!$dev1) {
         $warns .= "$T[$ix]:$K[$ix] not in ConfigFile, may not be monitored, ";
       }

       my $po = $PORT[$ix];
       my $po2 = ($po == 0)? 1:0;
       my $monH = $pi->[$po]{dataHost};
       if (!$monH) {
          if ($n->info("host_type") eq "ib") {
             $monH = $n->info("host");
          } elsif ($n->info("host2_type") eq "ib") {
             $monH = $n->info("host2");
          } else {
             $errs .= "<tr><td nowrap><small>-Cannot find InBand host to test " . $n->name() . "</td>";
          }
       }
       my $name = $dev1->{name};
       if ($T[$ix] eq "a5k") {
         for ($x=0; $x <= 10; $x++ ) {
           $logical = $di->{"f$x"}{LogicalPath} ;
           last if ($logical);
           $logical = $di->{"r$x"}{LogicalPath} ;
           last if ($logical);
         }
       } else {
         $logical = $pi->[$po]{LogicalPath} || $pi->[$po2]{LogicalPath};
         if ($logical ne $pi->[$po]{LogicalPath}) {
            $warns .= "No LogicalPath available on " . $n->name() . " port:" . ($po+1) ;
         }
       }
       if (!$logical) {
         $errs .= "<tr><td nowrap><small>-No LogicalPath for Port:$PORT[$ix] of ". $n->name(). "</td>";
       }
       my $ctrl = "|ctrl_model=$dev1->{ctrl_model}" if ($dev1->{ctrl_model});
       $PARM[$ix] = "type=$T[$ix]|port=$po|logical=$logical|ip=$dev1->{ipno}$ctrl|monHost=$monH|portWWN=1|name=$name|key=$dev1->{key}";
        
    }
  }
  my ($com1, $opts);
  if (0) { # $errs
    print "<table border=1 cellspacing=0 cellpadding=0><tr><td><table border=0 cellspacing=0 cellpadding=1 bgcolor=white width=100%>".
          "<tr><td><b>Warning(s):</b>$errs</table></table>";
  }
  if (!$PARM[1] || !$PARM[2]) {
    print "<table border=1 cellspacing=0 bgcolor=white width=95%>".
          "<tr><td><font color=red><b>Warnings:<br>Incomplete link</table>";
  } else {
    my $test_command = "linktest -a $PARM[1] -b $PARM[2]";
    $opts = ($q->{VERBOSE})? "-v ": "";
    $opts .= ($q->{STRESS})? "-s " : "";
    $opts .= ($q->{PTYPE})  ? "-T \"$q->{PTYPE}\" " : "";
    $opts .= ($q->{PATTERN})? "-p \"$q->{PATTERN}\" " : "";
    $opts .= ($isl)? "-I $isl " : "";

    rename "/tmp/last_linktest_command.1" , "/tmp/last_linktest_command.2";
    rename "/tmp/last_linktest_command" , "/tmp/last_linktest_command.1";
    open(O, ">/tmp/last_linktest_command");
    print O "linktest $opts -a \"$PARM[1]\" -b \"$PARM[2]\" \n";
    close(O);


    if ($q->{ACTION_start}) {
      my($err, $pid) = Scheduler->run('ST', $renv->{hostname}, "linktest",
                       "$opts -a \"$PARM[1]\" -b \"$PARM[2]\"", "",0, 1, $q->{EMAIL}, 1, 
                { 
                  ports    => "",
                  target   => $q->{start},
                  target2  => $q->{end},
                  dev_type => $T[1],
                  node     => $q->{start},
                  key      => $q->{start},
                  comp     => "",
                }, 10);
      if ($err) {
        print "<font color=red><b>Error on linktest: $err</b></font>";
      } else {
        print "&nbsp;<br><b>linktest (pid=$pid) started on " . 
                Util->shortHostname($renv->{hostname}) . "</b></small>";
        print &pop_list($pid);
      }
      #return;

    } else {
      if ($q->{ACTION_command}) {
        my $c = "-a \"$PARM[1]\" -b \"$PARM[2]\"";
        $c =~ s/\|/| /g;
        $c =~ s/\-b /<br>-b /;
        print "&nbsp;<table border=0 cellpadding=3 bgcolor=white><tr><td><b>Command:</b><br> linktest $opts $c</table>";
      }
    }
    print "<input type=hidden name=start value=\"$q->{start}\">
             <input type=hidden name=end value=\"$q->{end}\">
             <input type=hidden name=topo value=\"$q->{topo}\">
             <b>".
              Html::Screen->submitButton('ACTION_start', "Start LinkTest") . 
               "&nbsp;" .
              Html::Screen->submitButton('ACTION_command', "Display Command") . 
             "&nbsp; </b><p>";
  }
  print "<table border=1 cellspacing=0 width=95% bgcolor=white>
           <tr><td colspan=2 bgcolor=$Style::LIGHT>Test other Links from " . 
                $node[1]->name() . ":</td>
           <tr><td nowrap> $link_select &nbsp;<b> ".
           Html::Screen->submitButton("ACTION_se", "GO") . 
           "</table></form>";

  print "&nbsp;<br>&nbsp;<br><hr></center><font color=red>Warning: $warns</font>" if ($warns);
  #print "</center><br>Debug: last command(s) in /tmp/last_linktest_command";
}

sub pop_list {
  my($pid) = @_;
  return "<script>
   function win1(a) {
     var b = '$Http::WEBPROC?GO=GUI::ProcMgr::list&MODE=O&PLIST=$pid&WIN=1';
     var O = window.open(b, 'test_mon',
            'menubar=no,resizable=yes,scrollbars=yes,width=600,height=650');
     O.focus();
   }
   win1();
  </script> ";
}



sub from_list {
  my($q) = @_;

  my $h = Html->header2("diagnose.test.list_test", "96%");
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  my $L = Labels->read('GUI::Test')->section('from_list');

  print "\n
<head>
<script>
  function openwindow(a) {
      var b = '$Http::WEBPROC?GO=GUI::Test::details&' + a;
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
      O.focus();
  }
</script>
</head>
<body bgcolor=$Style::BGCOLOR>
<center>$h";

  my($selected0,$head)= GUI->test_head($q);
  my($select_host, $filter, $selected) = GUI->topoPage($q);

  my $filter1 = "<select name=filter1><option value=\"\">All";
  foreach my $f ('host','a5k','t3','switch') {
     my $sel = ($f eq $q->{filter1}) ? "selected":"";
     $filter1 .= "<option $sel>$f";
  }
  $filter1 .= "</select>";

  print "
     <table border=0><tr><td></table>
     <table border=0 cellspacing=0 cellpadding=0 width=96% bgcolor=white>
       <tr><td nowrap bgcolor=$Style::DARK><form><font color=white>
       <input type=hidden name=GO value=GUI::Test::from_list>
        <b>&nbsp;$L->{host}: $select_host &nbsp;
        $L->{filter}: $filter1 &nbsp; 
        " . Html::Screen->submitButton("ACTION", "GO") . 
       "&nbsp;</td></table>
     <table border=0><tr><td></table>";
  
  my $to = TO->readTopo($selected);
  if (!$to) {
     print "<b><center>" . $L->expand('err_no_topo', $selected);
     return;
  }

  my $hosts = $to->hostList();
  my $switches = $to->switchList();
  my $storages = $to->storageList();
  my($err,$af) = AutoForm->new("System/Tests", {noInfo => 1});

  my(@L, $x);
  my $State = State->read();
  my $comps = $State->components();
  my $filter2 = $q->{filter2};

  if (!$q->{SORT}) {
     $q->{SORT} = 1;
     $q->{SIGN} = 1;
  }
  my $target= "target=details";
  my $from;
  if ($window ne "B") {
    $target =  "";
    $from = "&FROM_LIST=1";
  }

  foreach my $host (@$hosts) {
     last if ($q->{filter1} && $q->{filter1} ne "host");
     my $hbas = $host->{portInfo};
     my $hn = $host->boxName();
     next if ($filter2 && substr($hn,0,length($filter2)) ne $filter2);

     if (exists($host->{diskInfo})) {
         my $hname = Util->shortHostname($hn);
         my $url = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&option=1&TAB=1&topo=$selected&enc=".
                     $host->name() . ":e $target>FC-Disk</a> ";  # h$x
         push(@L, ["host:$hname", "Internal Disk Test" , "", $url]);
     }
     for ($x=0; $x <= $#$hbas; $x++) {
         my $hba = $hbas->[$x];
	 #fix for bug 4620277
	 #we want to test even if no storage attached
         #next if ($hba->{al_pa} == -1);
         my($t, $hname) = split(/\:/, $host->{name});

         my $tests = Tasks->ST_getTestList($af, "host", $host, "p$x");
         my $htest = $tests->[0];
         next if (!$htest);
         $htest = $htest->name();
         my $url = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&testName=$htest&topo=$selected&enc=".
                     $host->name() . ":h$x $target>$htest</a> ";  # h$x
         
         $hname = Util->shortHostname($hn);
         my $status = &getLinkStatus($target, $comps, $host->name() . ":$x") || [undef,'&nbsp;'];
         my $enc = "<a href=$Http::WEBPROC?GO=GUI::Graph::get_report&enc=$host->{info}{name}:e&topo=$selected $target>host:$hname</a>";

         push(@L, [$enc, "hba$x / $hba->{RegisterName}" , $status->[1], $url]);
     }
  }

  foreach my $sw (@$switches) {
     my $ports = $sw->{portInfo};
     last if ($q->{filter1} && $q->{filter1} ne "switch");
     my $sname = $sw->boxName();
     next if ($filter2 && substr($sname,0,length($filter2)) ne $filter2);

     my(@L2, $error, $goodport, $goodurl, $goodn);
     my $sw_name = $sw->type() . ":" . ($sw->{info}{BoxName} || $sw->ipAddr());
     my $enc = "<a href=$Http::WEBPROC?GO=GUI::Graph::get_report&enc=$sw->{info}{name}:e&topo=$selected $target>$sw_name</a>";

     for ($x=0; $x <= $#$ports; $x++) {
         my $port = $ports->[$x];
         next if (!$port);
         my $tests = Tasks->ST_getTestList($af, $sw->type(), $sw, "p$x");
         my $htest = $tests->[0];
         my $url;
         if ($htest) {
           $htest = $htest->name();
           $url = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&testName=$htest&topo=$selected&enc=".
                     $sw->name() . ":p$x $target>$htest</a>";
         }
         if (!$goodport) {
           $goodport = $x;
           $goodurl = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&topo=$selected".
                    "&enc=".  $sw->name() . ":e $target>".
                    ucfirst($sw->type()) . "-Test(s)</a>";
         }

         my $status = &getCompStatus($target, $comps, $sw->name(), $sw->getPortId($x)) ||
                      &getLinkStatus($target, $comps, $sw->name() . ":$x") || [undef, '&nbsp;'];
         if ($status->[1] && $status->[1] ne "&nbsp;") {
           $error++;
           push(@L, [$enc, "port$x", $status->[1], $url]);
         }
     }
     if (!$error && $goodport) {
           push(@L, [$enc, "All Ports", "", $goodurl]);
     }
  }

  foreach my $st (@$storages) {
     my $ports = $st->{portInfo};
     next if ($q->{filter1} && $q->{filter1} ne $st->type());
     my $sname = $st->boxName();
     my $enc = "<a href=$Http::WEBPROC?GO=GUI::Graph::get_report&enc=$st->{info}{name}:e&topo=$selected $target>". $st->type() . ":$sname</a>";
     
     next if ($filter2 && substr($sname,0,length($filter2)) ne $filter2);

# PORTS, one port per line

     for ($x=0; $x <= $#$ports; $x++) {
         next if ($st->type() =~ /T3/i); #no port Tests for T3's
         my $port = $ports->[$x];
         next if (!$port);
         my $short = "s" . ($x+1);
         my $tests = Tasks->ST_getTestList($af, $st->type(), $st, $short);
         my $htest = $tests->[0];
         next if (!$htest);
         my $cname = "port.$x";
         $htest = $htest->name();
         my $url = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&testName=$htest&topo=$selected&enc=".
                     $st->name() . ":$short $target>$htest</a>";
         #my $url2 = "<a href=$Http::WEBPROC?GO=GUI::Test::get_expert&testName=stexpert&topo=$selected&enc=".
         #            $st->name() . ":d $target>StExpert</a>";

         my $status = &getCompStatus($target, $comps, $st->name(), $st->getPortId($x) ) ||
                      &getLinkStatus($target,$comps, $st->name() . ":" . ($x+1)) || [undef, '&nbsp;'];

         push(@L, [$enc, "port$x", $status->[1], "$url&nbsp;"]);
                    # $status->[1], "$url&nbsp;|&nbsp;$url2"]);
     }

# VOLUMES , one volume per line

     my $vols = $st->volInfo();
     my $v_cnt = 1;
     foreach my $v (sort keys %$vols) {
         my $port = $vols->{$v};

         my $short = "v$v_cnt"; 
         my $tests = Tasks->ST_getTestList($af, $st->type(), $st, $short);
         my $htest = $tests->[0];
         next if (!$htest);
         my $cname = "port.$x";
         $htest = $htest->name();
         my $url = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&testName=$htest&topo=$selected&enc=".
                     $st->name() . ":$short $target>$htest</a>";

         my $status = [undef, "&nbsp"];
         if ($v_cnt < 5) {
            my $u1 = ($v_cnt > 2) ? 2:1;
            my $v1 = ($v_cnt % 2) + 1;
            $status = &getCompStatus($target, $comps, $st->name(), "volume\..*", 1) || [undef, '&nbsp;'];
         }
         my $v0 = $v; $v0 =~ s/\/dev\/rdsk\///;
         my $ll = length($v0)/2;
         $v0 = substr($v0,0,$ll) . " &nbsp;" . substr($v0,$ll+1) if ($ll > 10);
         push(@L, [$enc, "lpath <small>$v0", $status->[1], "$url&nbsp;"]);
                    # $status->[1], "$url&nbsp;|&nbsp;$url2"]);
         $v_cnt++;
     }

#  DISKS/OOB , all in one line

     foreach my $el ('d=All Disks','oob=OutOfBand') {
        my($el1,$el_name) = split(/\=/, $el);
        my $tests = Tasks->ST_getTestList($af, $st->type(), $st, $el1);
        if ($#$tests >= 0) {
          my($x, $url, $list);
          for ($x=0; $x <= $#$tests; $x++) {
            my $htest = $tests->[$x];
            if ($htest) {
               $list .= ", " if ($list);
               my $n1 = $htest->name();
               $list .= " <a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&testName=$n1&topo=$selected&enc="
                    . $st->name() . ":$el1 $target>$n1</a>";
            }
          }
          if ($list) {
             my $status =  &getDiskStatus($target, $comps, $st) if ($el1 eq 'd');
             push(@L, [$enc, $el_name, $status->[1], $list]);
          }
        }
     }
  }
 
  my($pageInfo, $list) = Html::List->makeList($q,
                        \@L,
                    [$L->{system}, $L->{comp},$L->{status},$L->{run}],
                    [  'l',       'l',     'l',    'l'   ],
                    [  '+sn',   undef,    '-'    ],
                       {pageSize => 20, interactive => 1});
   my $out .= "
  <table border=1 cellspacing=0 cellpadding=0 width=96% bgcolor=white>
    $list
  </table>
  <table border=0><tr><td></table>
  <table border=0 width=95%>
    <tr><td>$pageInfo</td>
        <td align=right>
  </table>
  ";
  print $out;


}

sub details {
  my($q) = @_;
  my $State = State->read();
  print Html->body();
  print Html->header2('diagnose.test.list_test', undef, 'Error', undef, {noTabs => 1, noCrumb => 1});
  print "<table border=0><tr><td></table>";
  my ($f1, $f2);

  if ($q->{comp}) {
    my($t, $k, $topic) = split(/\:/, $q->{comp});
    my $comp = $State->components("$t:$k");
    return if (!$comp || !exists $comp->{$topic} );
    my $comp = $comp->{$topic};
    my($gif,$t);
    if ($comp->[0] == 2) {
       $gif = "state_2.gif";
       $t = "ComponentError:";
    } else {
       $gif = "state_1.gif";
       $t = "ComponentWarning:";
    }
    $f1 = "&nbsp;<img src=/gif/$gif>&nbsp;$t ";
    $f2 = $comp->[1];
  }
  print "<table border=1 cellpadding=2 cellspacing=0 width=90% bgcolor=white>
   <tr><td bgcolor=navy><font color=white><b>Alert Status</td>
   <tr><td>$f1</td><tr><td>$f2</table>";

}

sub getLinkStatus {
  my($target, $comps, $port) = @_;
  $target = "";
  my($t, $k, $topic) = split(/\:/, $port);
  foreach my $l (keys %$comps) {
     if ($l eq "$t:$k") {
        my $comp = $comps->{$l};
        foreach my $t (keys %$comp) {
            if ($t eq "port.$topic.fc_link") {
               my $c = $comp->{$t};
               if ($c->[0]) { # severity != 0
                  return [$c->[1],"<a href=\"javascript:openwindow('comp=$l:port.$topic.fc_link')\" $target><img src=/gif/state_2.gif alt=\"SAN Link, click for details\" border=0>&nbsp;link</a>"];
               }
            }
        }
     }
  }
  return undef;
}

sub getDiskStatus {
  my($target, $comps, $st) = @_;
  $target = "";

  my $l = $st->getDiskList();
  my $name = $st->name();

  foreach my $d (@$l) {
     my $c = $comps->{"$name:$d"};
     if ($c->[0]) {
        my $gif = ($c->[0] == 2) ? "state_2.gif": "state_1.gif";
        return [$c->[1],
          "<a href=\"javascript:openwindow('comp=$name:$d')\" $target><img src=/gif/$gif alt=\"Disk Error/Warn, click for details\" border=0>&nbsp;comp"];
     } 
  } 
  return undef;
}


sub getCompStatus {
  my($target, $comps, $name, $port, $re) = @_;
  $target = "";
  if ($re) {
     foreach my $c (keys %$comps) {
         my $val = $comps->{$c};
         next if ($val->[0] <= 0);
         my($type, $n1, $n2) = split(/\:/, $c, 3);
         if ("$type:$n1" eq $name && $n2 =~ /^$port/) {
            $port = $n2;
            last;
         }
     }
  }

  my $c = $comps->{"$name:$port"};
  return undef if (!$c);
  if ($c->[0]) {
     my $gif = ($c->[0] == 2) ? "state_2.gif": "state_1.gif";
     return [$c->[1],
      "<a href=\"javascript:openwindow('comp=$name:$port')\" $target><img src=/gif/$gif alt=\"Component Error/Warn, click for details.\" border=0>&nbsp;comp"];
  } 
  $c = $comps->{"$name:e"};
  return undef if (!$c);
  if ($c->[0]) {
     my $gif = ($c->[0] == 2) ? "state_2.gif": "state_1.gif";
     return [$c->[1],
    "<a href=\"javascript:openwindow('comp=$name:e')\" $target><img src=/gif/$gif alt=\"Component Error/Warn, click for details.\" border=0>&nbsp;enc"];
  } 
  
  return undef;
}


# display recent tests tests
#
sub get_show_tests {
  my($q) = @_;
  my($type, $name, $comp)  = split(/\:/, $q->{enc});
  print "\n<body bgcolor=$Style::BGCOLOR><center>";
  my $h = Html->header("Test List","97%","","test_defaults");
  print $h;

  my $Tests = Scheduler->processMap('ST');

  my $tests = $Tests->{"$type:$name"};
  if (!$tests) {
     print "<center>&nbsp;<br><b><font color=blue>No test found for $type:$name ";
     return;
  } 
  print "<table border=1 cellspacing=0 cellpadding=1 width=100% bgcolor=white>
  <tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>$type:$name</td>
  <tr bgcolor=$Style::LIGHT><td><b>Host<td><b>Process<td><b>Status
      <td><b>Start / End</td>";
  my $tc;
  foreach my $t (reverse @$tests) {
     last if ($tc++ > 20);
     my $host = Util->shortHostname($t->{host});
     print "<tr bgcolor=#F0F0D0>
     <td>&nbsp;$host</td>
     <td>&nbsp;$t->{pid} $t->{command}</td>
     <td>&nbsp;" . $t->statusText() . "</td>
     <td><small>&nbsp;$t->{start_date}<br>&nbsp;$t->{end_date}";

     my ($info, $pro, $out, $err) = Scheduler->read('ST', $t->{host}, $t->{pid});
     my $cnt = 0;
     print "<tr><td colspan=4><small>" . GUI::ProcMgr::_display1($out, \$cnt) . "</td>";
  }
  print "</table>";
    

}

#pid | command | arg | host | start | end | err




sub get_test {
  my($q, $header_done) = @_;
  my $h0 = "<a href=$Http::WEBPROC?GO=GUI::Test::from_list>Test from List</a>&nbsp;&nbsp;> " if ($q->{FROM_LIST});
  print Html->body();
  print Html->header2(
          "diagnose.test." . ($q->{FROM_LIST} ? "list_test":"topo_test"),
          undef,undef,undef,{noDoc => 1});
  &get_test0($q);
}

# $q->{topo} = diag176.central.sun.com,
# $q->{enc}  = switch:100000c0dd008467:e
# display form to start test.

sub get_test0 {
  my($q, $post) = @_;

  my($s, $a, $af, $err, $upd, $updG);
#  foreach $a (keys %$q) { $s .= "$a=$q->{$a}, "}
#  print $s;
   my $LB = Labels->read("GUI::Test")->section("get_test");

  my $D = System->get_home() . "/lib/Test";
  my $deny = Roles->verifyRole($q, "test");

  my($type, $key, $comp) = split(/\:/, $q->{enc});
  my ($have_options);
  my $renv = System->get_renv();
  my $to = TO->readTopo($q->{topo});
  my($p, $dev);
  $dev = $to->nodeByName("$type:$key") if ($to);
  if (!$dev) {
    print Html->error($LB->{no_dev_in_topo}); 
    return;
  }
  my $mgmtLevel = $dev->info("mgmtLevel");
  if (!$dev) {
    print Html->error($LB->expand(cannot_find => "$type:$key") );
    return;
  }
  if (!-d System->get_home() . "/Diags") {
    print Html->error($LB->{no_diag});
    return;
  }
  my $class0 = $dev->class0();
  my $id     = $dev->id();
  my $info   = $dev->info();
  my $ports  = $dev->portInfo();
  my $hp;
  if ($type eq "host") {
     $hp = $ports->[substr($comp,1)];
  }

  ($err,$af) = AutoForm->new("System/Tests", {noInfo => 1});

  my(@L, @T, $selected_test);

  my $cnt = 1;
  my $tests = Tasks->ST_getTestList($af, $type, $dev,$comp);
  if ($#$tests == -1) {
    $comp = 'e';
    $tests = Tasks->ST_getTestList($af, $type, $dev, $comp);
  }
  if ($#$tests < 0) {
      print Html->warning($LB->expand('no_test_avail',$id)); 
      return;
  }
  my ($ss, @DESC);
  foreach my $t (@$tests) {
       my $tn = $t->name();
       $DESC[$cnt] = $t->{info}{title};
       $q->{option} = $cnt if ($tn eq $q->{testName} && !$q->{option});
       push(@L, "$cnt=$tn");
       $ss .= "$cnt=$tn|";
       $T[$cnt] = $t->sectionName();
       $cnt++;
  }
  $q->{option} = 1 if (!$q->{option});
  my $tab1;
  if ($q->{TAB}) {
    $tab1 = Html->makeSelect("option", $ss, $q->{option}, {head => 'onchange=form.submit()'});
    my $tab = Html::Tabs->create(list  =>  \@L,
                       url  => "$Http::WEBPROC?GO=GUI::Test::get_test&FROM_LIST=$q->{FROM_LIST}&TAB=1&enc=$q->{enc}&topo=$q->{topo}",
                     width  => $Style::WIDTH,
             selectedColor  => $Style::DARK,
         selectedTextColor  => "white",
           backgroundColor  => $Style::LIGHT,
        backgroundTextColor => 'black',
                  selection => $q->{option}
               );
    print "<table border=0><tr><td></table>";
    print $tab if ($cnt > 2);
  } else {
    $tab1 =  $T[$q->{option}];
  }

  $selected_test = $T[$q->{option}];

  my $cache = Cache->read('tests', 'tests');
  $cache = {} if (!defined($cache));
  my($pre_err, $pre_data);

#########

  my $c2 = $af->commandByName($selected_test);
  my $c2_info = $c2->info();
  my ($s1, $s2, $first_host);

  my $Hdev = $dev;
  if ($q->{host}) {
    if ($q->{host} ne $q->{topo}) {
       my $to2 = TO->readExistingTopo($q->{host});
       $Hdev = $to2->nodeByName("$type:$key") if ($to2);
    }
  } else {
    ($s1, $s2, $first_host) = &find_host($info, $c2_info, $dev);
    if ($first_host && $first_host ne $q->{topo}) {
      my $to2 = TO->readExistingTopo($first_host);
      $Hdev = $to2->nodeByName("$type:$key") if ($to2);
    }
  }
#########

  my $DISPLAY;
  if ($q->{ACTION} eq "Start Test" || $q->{ACTION} =~ /Display CLI Command/) {
   $q->{ACTION} = "Display Command" if ($dev->{info}{datahost});
   $have_options = 1;
   while (1) {
     my $af_test = $af->commandByName($selected_test);
     if (!$q->{register} && $af_test->info('node') ne "oob" && $af_test->info('agent') ne "sa2") {
        print Html->error($LB->{no_dev});
        last;
     }
     my $host = $q->{host} || $first_host;
     my $enc  = $q->{enc};

     my($valid_err, $run_err, $text, $pid, $test_command, $opts ) = Diag->run($af, $host, $q, $af_test, $selected_test, $to, $dev, $q->{enc}, 0 );

     print Html->error( $valid_err) if ($valid_err);

     if ($q->{ACTION} =~ /Display/) {
        $text =~ s/<p>//;
        $DISPLAY = Html->info($LB->{cli_command} .": $text");
        last;
        if ($dev->{info}{datahost}) {
           print Html->warning($LB->{data_host});
        }
        return;
     }
     if ($run_err) {
       print Html->error("Error on $test_command: $run_err");
     } elsif($valid_err){
       # Print nothing, error aleady printed
     }else {
        print Html->info($LB->expand(started => "$test_command $opts", Util->shortHostname($host) . " (#$pid)")); 
       if ($renv->{window} ne "B") {
         GUI::ProcMgr::list({ PLIST=>$pid});
         return;
       } else {
         print &pop_list($pid);
       }
     }
     last;
   }
  }

  my $command = $af->commandByName($selected_test);
  my $warning = $command->info("warning");
  my $manpage = $command->info("manpage") || $selected_test;
  ($pre_err, $pre_data) = Diag->validation($command, $selected_test,  $to, $dev, $q, "preForm", "Warning");
  print Html->error($pre_err) if ($pre_err && !$have_options);

  if($pre_data->{"#WARN"}){
    $warning = $pre_data->{"#WARN"}.$warning;
  }
  if ($q->{ACTION}) {
     foreach my $x (keys %$q) {
         $pre_data->{$x} = $q->{$x};
     }
  }
  my $UPD;
  ($err, $upd, $UPD) = $af->updateForm($selected_test, {xheader => "", debug => 0}, $cache, $pre_data);
  print Html->error($err) if ($err);

  my $product = $info->{VendorID};

  if($info->{ProductID} !~ /6920/){
    $product .= $info->{ProductID};
  }
    
  my $sw_wwn = $info->{sw_WWN};
                   #<option value=\"\">[Select Device]</option>";
  my $reg_select;
  my $REG_SEL = [];

  my($cn, $reg_select, $all, $all_reg, $node, $multiple) = 
      Diag->register_list($type, $af, $selected_test, $Hdev, $comp, {mode => 'html'});

  my $submit = 1;

  if ($reg_select) {
    my($size) = $cn;
    $size = 3 if ($size > 3);
    if ($size == 1) {
      $REG_SEL = ["Select", "<select name=register>$reg_select</select>"];

    } elsif ($q->{EXPERT}) {
      $REG_SEL = ["Select", "<select name=register size=$size>$reg_select</select>"];

    } elsif ($size >= 0) {
      $REG_SEL = [ "Select", "<select name=register $multiple size=$size>$reg_select<option value=\"[ALL]\">$LB->{all_dev}</select>"];
    }
  } else {
    print Html->error($LB->{no_port});
    $submit = 0;
  }
  my (@HEADER, $header);
  if ($class0 eq "switch") {
    my ($sel_host, $sel_cnt) = &find_host($info, $c2_info, $dev);
    my $selected_host = &host_list($q, $sel_host, $sel_cnt, $c2_info);
    return if (!$selected_host);

    push(@HEADER, [$LB->{agent}, $selected_host], [$LB->{product}, $product], ["WWN", $sw_wwn]);

  } elsif (index(",sp,host,", ",$type,") >= 0) {
    my ($t, $h) = split(/:/, $info->{name});

    push(@HEADER, [$LB->{agent}, "$h <input type=hidden name=host value=\"$h\">"], 
                  ["Model", $info->{model} ] );

  } else {  # storage / hosts
    my $t = $info->{LGroup};
    my $ix = rindex($t,"-");
    $t = substr($t,0,$ix) if($ix > 0);
    if(($t =~ /3511/) || ($t =~ /3510/) ){
      $t = "";
    }

    my $bn = [ $LB->{dev_name}, $info->{BoxName} ] if ($info->{BoxName});
    
    my ($sel_host, $sel_cnt) = &find_host($info, $c2_info, $dev);
    my $selected_host = &host_list($q, $sel_host, $sel_cnt, $c2_info);
    return if (!$selected_host);

    my $ttype = ($c2_info->{node} eq "oob")? "OutOfBand":"InBand";
    
     push(@HEADER, [$LB->{agent}, $selected_host ],
                   [$LB->{dev_key}, $info->{name}  ],
                   $bn,
                   [$LB->{product}, "$product $t"]);
  }

  my $but; #  = &submit_b($submit, $deny, $warning, 0);

  print "
 <script>
 function openw(a) {
   var b = '$Http::WEBPROC?GO=GUI::Test::man&test=' + a;
   var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=600,height=500');
   O.focus();
 }
 </script>

   <table border=0 cellpadding=1 cellspacing=0 width=$Style::WIDTH bgcolor=white>
   <tr bgcolor=$Style::DARK><td colspan=2><font color=white>
   <form method=post>
    <input type=hidden name=GO value=\"GUI::Test::get_test\">
    <input type=hidden name=EXPERT value=$q->{EXPERT}>
    <input type=hidden name=enc value=\"$q->{enc}\">
    <input type=hidden name=topo value=\"$q->{topo}\">
    <input type=hidden name=node value=\"$node\">
    <input type=hidden name=option value=\"$q->{option}\">
    &nbsp;$all_reg
    <b>" . ucfirst($selected_test) . " $id</td>
     <td align=right><font color=white><b> $but </b>
     &nbsp;<font>[ <a href=\"javascript:openw('$manpage')\"><font color=white>$LB->{manpage}</font></a> ]</td>
    </table>";

  print "<table border=1 cellpadding=1 cellspacing=0 width=$Style::WIDTH bgcolor=white>";

  my $cnt;
  my $renv   = System->get_renv();
  my $ruser  = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  my $COLS   = $window eq "N" ? 2:1;

  foreach my $el (@HEADER) {
    next if (!$el->[0]);
    print "<tr>" if ($cnt++ % $COLS == 0);
    print "<td bgcolor=$Style::LIGHT align=right>$el->[0]:</td><td bgcolor=$Style::LIGHT nowrap>$el->[1]</td>\n";
  }
  print "<tr><td></td>";
  foreach my $el ($REG_SEL, @$UPD) {
    next if (!$el->[0]);
    print "<tr>" if ($cnt++ % $COLS == 0);
    print "<td  bgcolor=$Style::LIGHT align=right>$el->[0]:</td><td >&nbsp;$el->[1]</td>\n";
  }
  print "<td colspan=2>&nbsp;</td>" if ($cnt % 2 == 1);
  print "</table>";
  
  print "<table border=0 cellspacing=0 width=$Style::WIDTH> <tr><td>" . 
          &submit_b($submit, $deny, $warning, 1) . "</table>";
  print "</form>";
  print $DISPLAY;
  print "<br>\n";
}

sub man {
   my($q) = @_;
   my $test = $q->{test};
   print Html->body(undef, {color => "#F0F0F0"});
   print "<table border=0 cellspacing=0 cellpadding=2 width=100% bgcolor=$Style::DARK>
   <tr><td><font color=white>Man Page for $q->{test}</table></center><pre>";
   my $D = System->get_home() . "/man";
   my $l;
   if (-f "$D/man1m/$test.1m") {
     open(MAN, "/usr/bin/man -M $D $test|");
     my @o = <MAN>; close(MAN);
     my $out = join("", @o);
     $out =~ s/_//g;
     $out =~ s/\n\n+/\n\n/g;
     $out =~ s/\n([A-Z]+)\n/\n<b>$1<\/b>\n/g;
     print $out;
   } else {
     print "<b>Man page for $test not available!";
   }
}


sub host_list {
  my($q, $sel_host, $sel_cnt, $c2_info) = @_;

    my %X = (ib => "DataPath/ InBand", oob => "Ethernet/ OutOfBand");
    if (!$sel_host) {
       print "&nbsp;<br>";
       print Html->warning("Cannot Test $X{$c2_info->{node}}!");
       return undef;
    }
    my $selected_host;
    if ($sel_cnt > 1) {
      $selected_host = Util->makeSelect("host",$sel_host, $q->{host});
      $selected_host = substr($selected_host,0,7) . " onchange=form.submit() " .
                     substr($selected_host, 7);
      $selected_host .= Html::Screen->submitButton('ACTION', "go");
    } else {
      $selected_host = "<table border=0><tr><td><b>$sel_host</table>";
    }
    return $selected_host;
}

sub skip {
  my($c2_info, $host_type) = @_;

  if ($c2_info eq "oob") {
     return 1 if ($host_type ne "oob");
  } else {
     return 1 if ($host_type eq "oob");
  }
}

sub find_host {
  my($info, $c2_info, $node) = @_;
  my ($sel_host, $sel_cnt, $first, $ix);
  my $SW = 1 if (substr($info->{class} ,0,6) eq 'switch');

   # switch tests are oob even if Tests/switch.test says 'p'
   # this is a bug in the way the Tests/<file>.test were designed
  if ($c2_info->{agent} eq "sa2") {
     my $ip = $node->info("ipName") || $node->info("ipAddr") || $node->info("sw_ipAddr");
     return ($ip, 1, $ip);
  } 
  if ($c2_info->{node} eq "oob" || $SW) {
    my $renv = System->get_renv();
    my $C = PDM::ConfigFile->read();
    my $dev = $C->deviceByKey($info->{name});
    if ($dev) {
      $sel_host = ($dev->{host} || $renv->{hostname}) . "|" ;
      $first    = ($dev->{host} || $renv->{hostname});
      $sel_cnt++;
    }
  }
  foreach my $t1 ('host') {
      next if (!$info->{host});
      next if (&skip($c2_info->{node}, $info->{host_type}));

      if (index($sel_host, $info->{host}) < 0) {
        $sel_host .= "$info->{host}|" ;
        $first = $info->{host} if (!$first);
        $sel_cnt++;
      }
  }
  my $hosts = $info->{hosts};
  my $hostsT = $info->{hosts_type};
  for ($ix = 1; $ix <= $#$hostsT; $ix++) {
      next if (&skip($c2_info->{node}, $hostsT->[$ix]));
      if (index($sel_host, $hosts->[$ix]) < 0) {
        $sel_host .= "$hosts->[$ix]|" ;
        $first = $hosts->[$ix] if (!$first);
        $sel_cnt++;
      }
  }
  chop($sel_host) if (substr($sel_host, -1) eq "|");
  return ($sel_host, $sel_cnt, $first);

}




sub submit_b {
  my($submit, $deny, $warning, $dc) = @_;
  my $o;
  my $renv = System->get_renv();
  if ($submit && !$deny) {
    if ($warning) {
       $o .= "<b>" . Html::Screen->submitButton("ACTION", "Start Test", undef, { confirm => $warning } ) 
              . "&nbsp;";
    } else {
       $o .= "<b>" . Html::Screen->submitButton("ACTION", "Start Test") . "&nbsp;";
    }
  }
  if ($dc && $renv->{solution} eq "N") {
     $o .= Html::Screen->submitButton("ACTION", "Display CLI Command Only");
  }
  return $o;
}


sub mode {
  my($q) = @_;
  my($err, $af, $upd);

  my $cache = Cache->read('tests','tests');
  $cache = {} if (!defined($cache));

  my($out, $w, $info);
  if (defined($q->{online})) {
     $cache->{MODE}{online} = $q->{online}; $w=1;
  }
  if (defined($q->{expert})) {
     $cache->{MODE}{expert} = $q->{expert}; $w=1;
  }

  Cache->write('test','tests', $cache) if ($w);

  $out .= "<tr><td><b>";
  if ($cache->{MODE}{online}) {
    $out .= "<a href=$Http::WEBPROC?GO=GUI::Test::mode&online=0 onmouseover=\"window.status='Click here to run tests OFFLINE'\"><font color=red>ON LINE</font></a>";
  } else {
   $out .= "<a href=$Http::WEBPROC?GO=GUI::Test::mode&online=1 onmouseover=\"window.status='Click here to run tests ONLINE'\">OFF LINE</a>";
  }
  $out .= "<tr><td><b>";
  if ($cache->{MODE}{expert}) {
    $out .= "<a href=$Http::WEBPROC?GO=GUI::Test::mode&expert=0 onmouseover=\"window.status='Click here to turn Expert-Mode OFF'\">EXPERT-ON</a>";
  } else {
    $out .= "<a href=$Http::WEBPROC?GO=GUI::Test::mode&expert=1 onmouseover=\"window.status='Click here to turn Export-Mode ON'\">EXPERT-OFF</a>";
  }
  print "\n<body bgcolor=$Style::DARK link=navy vlink=navy blink=navy><center>
  <table border=0 bgcolor=white width=110% cellpadding=2 cellspacing=1>
   <tr><td bgcolor=$Style::LIGHT><b><center>Test Mode
   $out
   </table>&nbsp;";

}


sub defaults {

  my($q) = @_;
  my(@T, @tests, $info);
  my $renv = System->get_renv();

  my $deny = Roles->verifyRole($q, "admin");

  my $G = Labels->read();
  my $L = Labels->read('GUI::Test')->section('defaults');


  print Html->body();
  my @tt = ('1=' . $L->{defaults});
  my $h = Html->header2("diagnose.tools.defaults");
  print $h;
  
  $T[1] = "DEFAULTS";

  my($af, $cache, $err,$err2, $upd, $test, $updG, $err1, $err3);
  ($err,$af) = AutoForm->new("System/Tests", {width=> "95%"});
  print $err if ($err);

  my $cnt = 2;
  my $select = "<select name=option onchange=form.submit()><option value=1>$L->{defaults}";
  $q->{option} = 1 if (!$q->{option});

  foreach my $com (sort $af->commandList()) {
     next if ($com eq "DEFAULTS"|| $com eq "MODE");
     my $c = $af->commandByName($com);
     if ($renv->{solution} ne "N") {
         next if (index(",". SE->device_included() . "," , ",$c->{info}{devType},") < 0);
         next if (index(",p,oob,", ",$c->{info}{node},") < 0);
     }

     my $info = $c->info();
     $T[$cnt] = $com;
     my $ck = ($q->{option} == $cnt) ? "selected" : "";
     my $lb = Util->abb("$info->{devType}.short");
     my $lb2 = "[ $lb ]" if ($lb);
     $select .= "<option value=$cnt $ck>$com $lb2</option>";
     push(@tt, "$cnt=". $info->{name});
     $cnt++;
  }
  $select .= "</select>";
 
#  my $tab = Html::Tabs->create(list  =>  \@tt,
#                       url  => "$Http::WEBPROC?GO=GUI::Test::defaults",
#                     width  => "95%",
#             selectedColor  => "white",
#         selectedTextColor  => "blue",
#                        rows  => 2,
#           backgroundColor  => $main'LIGHT,
#        backgroundTextColor => 'black',
#                  selection => $q->{option}
#               );


  if ($q->{option} == 1) { # Defaults
    $cache = Cache->read('tests','tests');
    $cache = {} if (!defined($cache));

    if ($q->{ACTION_reset}) {
        $cache->{DEFAULTS} = $af->defaults('DEFAULTS');
        Cache->write('tests','tests', $cache);
        $info = "<font color=green>$L->{reset_done}</font>";

    } elsif ($q->{ACTION_update}) {
        ($err1, $cache->{DEFAULTS}) = $af->values('DEFAULTS', $q);
        if ($err1) {
           $err = "<font color=red><b>Error: $err1</font>";
           $info = "<font color=red>$L->{update_failed}</font>";
        } else {
           Cache->write('tests','tests', $cache);
           $info = "<font color=green>$L->{update_done}</font>";
        }
    }
   ($err, $upd) = $af->updateForm('DEFAULTS', {xheader => "", debug => 1 },
                          $cache);

    print "<form><input type=hidden name=GO value=GUI::Test::defaults>
           <xinput type=hidden name=option value=1>";
    print "<table border=1 cellspacing=0 cellpadding=2 width=$Style::WIDTH bgcolor=white>
    <tr><td bgcolor=$Style::DARK colspan=3><font color=white>&nbsp;<b>$L->{label}</td>
    <tr><td bgcolor=$Style::LIGHT align=right>$L->{select_test}: </td><td colspan=2><b> $select ".
      Html::Screen->submitButton("ACTION", $G->{go}) . "</td>
   <tr bgcolor=white><td colspan=2><font color=black><b>&nbsp;$L->{default_option}: <td><font color=black><b>$L->{variable_name}:<center>$info</td> ";
    print $upd;
    print "<b></table>";
    if (!$deny) {
       print 
       Html::Screen->submitButton("ACTION_update", $L->{submit_update}) . "&nbsp;" .
       Html::Screen->submitButton("ACTION_reset",  $L->{submit_reset}) ;
    }
    print "</form>";


  } else { # specific test

    $test = $T[$q->{option}];
    $cache = Cache->read('tests','tests');
    $cache = {} if (!defined($cache));

    if ($q->{ACTION_reset}) {
        ($err, $cache->{$test})          = $af->defaults($test);
        if (exists($cache->{DEFAULTS})) {
           ($err1 ,$cache->{$test}{DEFAULTS}) = $cache->{DEFAULTS};
        } else {
           ($err1 ,$cache->{$test}{DEFAULTS}) = $af->defaults('DEFAULTS');
        }
        Cache->write('tests','tests', $cache);
        $info = "<font color=yellow>$L->{reset_done}</font>";

    } elsif ($q->{ACTION_update}) {
        ($err1, $cache->{$test})          = $af->values($test, $q);
        ($err2, $cache->{$test}{DEFAULTS}) = $af->values('DEFAULTS', $q);
        if ($err1 || $err2) {
          $err = "<font color=red><b>Error: $err1 $err2</font>";
          $info = "<font color=yellow>$L->{update_failed}</font>";
        } else {
          $info = "<font color=yellow>$L->{update_done}</font>";
          Cache->write('tests','tests', $cache);
        }
    }


    ($err3, $upd) = $af->updateForm($test, {xheader => "", debug => 1 , hideConst => 1},
                          $cache);
    if ($err3) {
       $err .= "<font color=red>" . L->expand('update_err', $err3). "</font>";
    }
    
    print "<form><input type=hidden name=GO value=GUI::Test::defaults>
           <Xinput type=hidden name=option value=$q->{option}>";
    if ($err) {
       print "<table border=1 cellpadding=1 cellspacing=0 width=80% bgcolor=white><tr><td><center>$err</table><table border=0><tr><td></table>";
    }
    print "<table border=1 cellspacing=0 width=$Style::WIDTH bgcolor=white>
   <tr>
    <tr><td bgcolor=$Style::LIGHT align=right><b>$L->{select_test}: </td><td colspan=2> $select </td>
   <tr><td colspan=2 bgcolor=$Style::DARK><font color=white>&nbsp;<b>$test $L->{option_name} <td bgcolor=$Style::DARK><font color=white><b>$L->{variable_name}$info</td>
    $upd
    <b></table>";
    if (!$deny) {
      print 
      Html::Screen->submitButton("ACTION_update", $L->{submit_update}) . "&nbsp;".
      Html::Screen->submitButton("ACTION_reset",  $L->{submit_reset}) ;
    }
    print "</form>";
    
  }
  
}


  
  
  

sub run {
  my($q) = @_;
  my($err, $add, $update);
  print "\n<body bgcolor=white><center>";

  my $af = AutoForm->new("System/Tests", {language => 'fr', width=> "90%"});

  ($err, $add) = $af->addForm('DEFAULTS', {header => "extra", debug => 0} );

  ($err, $update) = $af->updateForm('DEFAULTS',
            {xheader => "", debug => 0},
            {A => 'val1', B=> 'val2', C => 0},
          );
  print "<font color=red>$err" if ($err);

  print "<form>";
  print "<table border=1 cellspacing=0 width=90%>";
  print $update;
  print "</table></form>";
  return;



}

#
# used to test automatic lists
#
sub XXXlist {
  my($q) = @_;
  my($x0, $x, $page, $list);
  print "\n<body bgcolor=$Style::BGCOLOR>";
  print "<table border=1 cellspacing=0 width=90% bgcolor=white>";
  System->set_language('fr');
  my @L;
  for ($x0=0; $x0 <= 100; $x0++) {
    $x = sprintf("%3.3d", $x0);
    push(@L, ["r$x c1","r$x c2","r$x c3" ,"r$x c4"]);
  }
  ($page, $list) =  Html::List->makeList($q, \@L,
                           ['Col1','Col2','Col3', 'Col4'],
                           ['l',     'r',     'c'],
                           ['+','-'],
                           {pageSize => 10, map => 'list1'}
                       );

  print "$list </table>&nbsp;<br></center> ".
        "<table border=0 cellpadding=3 bgcolor=white><tr><td>$page</table>";

}



1;
