package GUI::Thresholds;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Thresholds.pm,v 1.7 2004/02/13 01:25:09 ccadieux Exp $

use Thresholds;

sub th {
  my($q) = @_;
  print Html->body();
  print Html->header2("report.system.thresholds" );
  my $G = Labels->read();
  my $L = Labels->read("GUI::Thresholds");

  if ($q->{ACTION_clear}) {
     Thresholds->clear();
  }

  print "<table border=0 cellspacing=0 cellpadding=2 width=90%><tr><td align=right>
    [ <a href=$Http::WEBPROC?GO=GUI::Thresholds::th&ACTION_clear=1>$L->{clear}</a> ]
        </table>
     ";

  my(@array, $DB);
  ($DB, $th) = Thresholds->init();
  $data = $DB->hash();
  my $FNAME = Thresholds->fileName();
  open(O, $FNAME);
  my ($cnt, $last, %T);
  while ($l = <O>) {
    chop($l);
    next if ($l =~ /^ *$/ or substr($l,0,1) eq "#");
    next if (substr($l,0,1) eq "'");
    @a = split(/ *[\.\=\,] */, $l);
    last if ($cnt++ > 50 && $q->{DOC});
    $freq = $a[3];
    $repeat = $a[4];
    $type = ($a[5] eq "W")? $G->{warning} : $G->{error};
    $unit = ($a[3] =~ /m$/) ? "ins":"ours";
    $unit2 = ($repeat =~ /m$/) ? "ins":"ours";
    my $desc = $a[6];
    $p = $data->{"$a[0].$a[1]"};
    $xx = 0;
    my $info;
    foreach $k (keys %$p) {
      $v  = $p->{$k};
      $xx++;
      $d1 = Util->get_date($v->[0]*60);
      if ($v->[1] == 0) {
        $text = $L->expand(last => $d1);
      } else {
        $text = $L->expand(received => $v->[1], $d1);
      }
      $info .= "$k: $text<br>";
    }
    $T{$a[0]} = 1;
    if (!$q->{TYPE} || $a[0] eq $q->{TYPE}) {
      push(@array, [$a[0], $a[1], "$a[2]/ $a[3]$unit", "$repeat$unit2", $type, "", $info ]);
    }
  }
  close(O);
  my $select = "=["  . $L->{select} . "]|";
  foreach my $e (sort keys %T) {
    $select .= "$e|";
  }

  $q->{SORT} = 1 if (!$q->{SORT});
  my $scr = Html::Screen->new();
  $select = $scr->goForm(["GO=GUI::Thresholds::th"],
             Html->makeSelect("TYPE", $select, $q->{TYPE}));

  $scr->list($q, { title => $L->{thresholds}, pageSize => 500, interactive => 1, line2 => "6,2" },
  [
  [ l => "Type", '+sn' ],
  [ l => $L->{name}, '+' ],
  [ l => $L->{freq}, '+' ],
  [ l => $L->{quiet} ],
  [ l => $L->{type}, '+' ],
  ],
  \@array, 
    [
    [ l => 'DATA', $select ] 
    ]);
  print $scr->out(); 

  if ($q->{DOC}) {
     print "Note: The complete report can be seen using the StorA.D.E. GUI.<br>";
  }
}


1;
