package GUI::TopoList;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use Util;
use AutoForm;
use strict;
use TO;
use GUI;
use Tasks;
use Tests;
use Cache;
use Html::List;
use Html;
use GUI::Graph;
use System;

sub list_frame {
  my($q) = @_;
  my($renv) = System->get_renv();
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};

  if ($window ne "B") {
     GUI::TopoList::from_list($q);
  } else {
     print Html->text_header();
     print <<EOF;
<frameset cols=*,37% border=1>
    <frame src=$Http::WEBPROC?GO=GUI::TopoList::from_list&TEST=$q->{TEST} name=main scrolling=auto xmarginwidth=1 xmarginheight=1>
    <frame src=empty.html name=details scrolling=auto  xmarginheight=1>
</frameset>

EOF
  }
}

sub list {
  my($q) = @_;

  my $TEST   = $q->{TEST};  # ran from diagnose environment
  print Html->body();
  my $L      = Labels->read('GUI::TopoList')->section('from_list');
  my $url_list;
 $url_list = "<a href=$Http::WEBPROC?GO=GUI::TopoList::from_list&TEST=$q->{TEST}>$L->{test_list}</a>";

  print Html->header2($TEST? "diagnose.test.list_test": "monitor.topo", $Style::WIDTH,
                         undef, undef, {right => $url_list} );

  opendir(O1, System->get_home() . "/DATA/topo");
  my @files = readdir(O1);
  closedir(O1);

  print "
  <table border=0><tr><td></table>
   <table border=1 width=$Style::WIDTH bgcolor=white cellspacing=0 cellpadding=1>
   <tr><td colspan=4 bgcolor=$Style::DARK><font color=white><b>$L->{host_list}</td>
   <tr bgcolor=$Style::LIGHT>
       <th>$L->{select}</th>
       <th>$L->{hbas}</th>
       <th>$L->{devices}</th>
       <th>$L->{switches}</th>
   ";
  my $sans;
  foreach my $f (sort @files) {
     next if (substr($f,0,1) eq ".");
     if (substr($f,0,5) eq "MERGE") {
       #
       my $name = substr($f,6);
       my $u = "<a href=$Http::WEBPROC?GO=GUI::TopoList::from_list&topo=$f&TEST=$q->{TEST}>$name</a>";
       $sans .= "<tr><td colspan=4>&nbsp;$u</td>
              ";
     } else {
       my $to = TO->readExistingTopo($f);
       my $hosts    = $to->[0];
       my $switches = $to->[1];
       my $storages = $to->[2];
       my $hubs     = $to->[3];
       my($cnt_st, $cnt_sw, $cnt_ports);
       foreach my $e (keys %$hosts) {
          my $h = $hosts->{$e};
          my $ports = $h->{port};
          $cnt_ports = $#$ports + 1;
          last;
       }
       foreach my $e (keys %$switches) {
          $cnt_sw++;
       }
       foreach my $e (keys %$storages) {
          $cnt_st++;
       }
       next if ($cnt_st + $cnt_sw + $cnt_ports == 0);
       my $u = "<a href=$Http::WEBPROC?GO=GUI::TopoList::from_list&topo=$f&TEST=$q->{TEST}>$f</a>";
       print "<tr><td>&nbsp;$u</td>
                 <td align=right>$cnt_ports&nbsp;</td>
                 <td align=right>$cnt_st&nbsp;</td>
                 <td align=right>$cnt_sw&nbsp;</td>
              ";
     }
  }
  if ($sans) {
    print "<tr><td colspan=5 bgcolor=$Style::LIGHT><b>&nbsp;SANs</td>
           $sans";
  }
  print "</table>
   <p>
   <table border=0 bgcolor=white><tr><td>
   $L->{note}
   </table>";

}

# can be used for Test from list or Monitor from List
# TEST=1 : test from list
# TEST=0 : topo from list

sub from_list {
  my($q) = @_;
  my $TEST   = $q->{TEST};  # ran from diagnose environment
  my $renv   = System->get_renv();
  my $ruser  = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  my $L      = Labels->read('GUI::TopoList')->section('from_list');
  my $G      = Labels->read();
  my $Config = PDM::ConfigFile->read();
  my $dev_list = $Config->typeList();

  my $url_list = "<a href=$Http::WEBPROC?GO=GUI::TopoList::list&TEST=$q->{TEST}>$L->{host_list}</a>" if ($renv->{solution} eq "N");
  print Html->body();
  my $h = Html->header2($TEST? "diagnose.test.list_test": "monitor.topo", $Style::WIDTH,
                         undef, undef, {right => $url_list} );

  print "
<head>
<script>
  function openwindow(a) {
      var b = '$Http::WEBPROC?GO=GUI::TopoList::details&' + a;
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
      O.focus();
  }
</script>
</head>
<body bgcolor=$Style::BGCOLOR>
<center>$h";

  #my($selected0,$head)= GUI->test_head($q);
  my($select_host, $filter, $selected) = GUI->topoPage($q);

  my $filter1 = Html->makeSelect("filter1", "=$G->{all}|$dev_list",$q->{filter1});

  my $scr = Html::Screen->new();

  my $goForm = $scr->goForm( [ "GO=GUI::TopoList::from_list","TEST=$q->{TEST}"],
     "$L->{host}: $select_host &nbsp; $L->{filter}: $filter1 ") 
       if ($renv->{solution} eq "N");

  my $to = TO->readTopo($selected);
  if (!$to) {
     print "<b><center>" . $L->expand('err_no_topo', $selected);
     return;
  }

  my $hosts = $to->hostList();
  my $switches = $to->switchList();
  my $storages = $to->storageList();
  my($err,$af) = AutoForm->new("System/Tests", {noInfo => 1});

  my(@L, $x);
  my $comps = State->components();
  my $filter2 = $q->{filter2};

  if (!$q->{SORT}) {
     $q->{SORT} = 1;
     $q->{SIGN} = 1;
  }
  my $target= "target=details";
  my $from;
  if ($window ne "B") {
    $target =  "";
    $from = "&FROM_LIST=1";
  }

  foreach my $host (@$hosts) {
     last if ($q->{filter1} && $q->{filter1} ne "host");
     my $hbas = $host->portInfo();
     my $ports = $host->port();
     my $hn = $host->boxName();
     next if ($filter2 && substr($hn,0,length($filter2)) ne $filter2);

     for ($x=0; $x <= $#$hbas; $x++) {
         my $hba = $hbas->[$x];
	 #fix for bug 4620277
	 #we want to test even if no storage attached
         #next if ($hba->{al_pa} == -1);

         my($t, $hname) = split(/\:/, $host->{name});
         $hname = Util->shortHostname($hn);
         my $url;
         #my $enc = "<a href=$Http::WEBPROC?GO=GUI::Graph::get_report&enc=$host->{info}{name}:e&topo=$selected $target>host:$hname</a>";
         my $enc = "host $hname";

         if ($TEST) {
            my $tests = Tasks->ST_getTestList($af, "host", $host, "p$x");
            my $htest = $tests->[0];
            next if ($q->{TEST} && !$htest);
            $htest = $htest->name();
            $url = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&testName=$htest" . 
                   "&topo=$selected&enc=" .  $host->name() . ":h$x $target>$htest</a> ";  # h$x
         } else {
            $url = $to->linkName($ports->[$x]);
         }
         my $status = &getLinkStatus($target, $comps, $host->name() . ":$x") || [undef,'&nbsp;'];
         
         push(@L, [$enc, "hba$x / $hba->{RegisterName}" , $status->[1], $url]);
     }
  }

  foreach my $sw (@$switches) {
     my $portInfo = $sw->portInfo();
     my $ports    = $sw->port();
     next if ($q->{filter1} && $q->{filter1} ne $sw->type());
     my $sname = $sw->boxName();
     next if ($filter2 && substr($sname,0,length($filter2)) ne $filter2);

     my(@L2, $error, $goodport, $goodurl, $goodn);
     my $sw_name = $sw->type() . ":" . ($sw->{info}{BoxName} || $sw->ipAddr());
     #my $enc = "<a href=$Http::WEBPROC?GO=GUI::Graph::get_report&enc=$sw->{info}{name}:e&topo=$selected $target>$sw_name</a>";
     my $enc = $sw_name;

     for ($x=0; $x <= $#$portInfo; $x++) {
         my $port = $portInfo->[$x];
         next if (!$port);
         my $status = &getCompStatus($target, $comps, $sw->name(), $sw->getPortId($x)) ||
                        &getLinkStatus($target, $comps, $sw->name() . ":$x") || [undef, '&nbsp;'];
         my $url;
         if ($TEST) {
            my $tests = Tasks->ST_getTestList($af, $sw->type(), $sw, "p$x");
            my $htest = $tests->[0];
            if ($htest) {
              $htest = $htest->name();
              $url = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&testName=$htest&topo=$selected&enc=".
                     $sw->name() . ":p$x $target>$htest</a>";
            }
            if (!$goodport) {
              $goodport = $x;
              $goodurl = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&topo=$selected".
                    "&enc=".  $sw->name() . ":e $target>".
                    ucfirst($sw->type()) . "-$G->{tests}</a>";
            }
            if ($status->[1] && $status->[1] ne "&nbsp;") {
              $error++;
              push(@L, [$enc, "port$x", $status->[1], $url]);
            }
         } else {
            next if (!$ports->[$x] && (!$status->[1] || $status->[1] eq "&nbsp;") );
            $url = $to->linkName($ports->[$x]);
            push(@L, [$enc, "port$x", $status->[1], $url]);
         }
     }
     if ($TEST && !$error && $goodport && $sw->{info}{class} =~ /^switch/) {
           push(@L, [$enc,  $G->{all_ports}, "", $goodurl]);
     }
  }

  foreach my $st (@$storages) {
     my $portInfo = $st->portInfo();
     my $ports    = $st->port();
     next if ($q->{filter1} && $q->{filter1} ne $st->type());
     my $sname = $st->boxName();
      my $sname0 = $sname;
     $sname0 =~ s/\./. /g;
     #my $enc = "<a href=$Http::WEBPROC?GO=GUI::Graph::get_report&enc=$st->{info}{name}:e&topo=$selected $target>". $st->type() . ": $sname0</a>";
     my $enc = $sname0;
     
     next if ($filter2 && substr($sname,0,length($filter2)) ne $filter2);

# PORTS, one port per line

     for ($x=0; $x <= $#$portInfo; $x++) {
         my $port = $portInfo->[$x];
         next if (!$port);
         my $short = "s" . ($x+1);
         my $url;
         my $status = &getCompStatus($target, $comps, $st->name(), $st->getPortId($x) ) ||
                      &getLinkStatus($target,$comps, $st->name() . ":" . ($x+1)) || [undef, '&nbsp;'];
         if ($TEST) {
            next if ($st->type() =~ /T3/i); #no port Tests for T3's
            my $tests = Tasks->ST_getTestList($af, $st->type(), $st, $short);
            my $htest = $tests->[0];
            next if (!$htest);
            my $cname = "port.$x";
            $htest = $htest->name();
            $url = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&testName=$htest&topo=$selected&enc=".
                     $st->name() . ":$short $target>$htest</a>";
            push(@L, [$enc, "port$x", $status->[1], "$url&nbsp;"]);
         } else {
            $url = $to->linkName($ports->[$x]);
            push(@L, [$enc, "port$x", $status->[1], "$url&nbsp;"]);
         }
     }

# VOLUMES , one volume per line

     if ($TEST) {
       my $vols = $st->volInfo();
       my $v_cnt = 1;
       foreach my $v (sort keys %$vols) {
           my $port = $vols->{$v};
  
           my $short = "v$v_cnt"; 
           my $tests = Tasks->ST_getTestList($af, $st->type(), $st, $short);
           my $htest = $tests->[0];
           next if (!$htest);
           my $cname = "port.$x";
           $htest = $htest->name();
           my $url = "<a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&testName=$htest&topo=$selected&enc=".
                       $st->name() . ":$short $target>$htest</a>";
  
           my $status = [undef, "&nbsp"];
           if ($v_cnt < 5) {
              my $u1 = ($v_cnt > 2) ? 2:1;
              my $v1 = ($v_cnt % 2) + 1;
              $status = &getCompStatus($target, $comps, $st->name(), "volume\..*", 1) || [undef, '&nbsp;'];
           }
           my $v0 = $v; $v0 =~ s/\/dev\/rdsk\///;
           my $ll = length($v0)/2;
           $v0 = substr($v0,0,$ll) . " &nbsp;" . substr($v0,$ll+1) if ($ll > 10);
           push(@L, [$enc, "lpath <small>$v0", $status->[1], "$url&nbsp;"]);
                      # $status->[1], "$url&nbsp;|&nbsp;$url2"]);
           $v_cnt++;
       }
  
  #  DISKS/OOB , all in one line
  
       foreach my $el ("d=$G->{all_disks}","oob=$G->{oob}") {
          my($el1,$el_name) = split(/\=/, $el);
          my $tests = Tasks->ST_getTestList($af, $st->type(), $st, $el1);
          if ($#$tests >= 0) {
            my($x, $url, $list);
            for ($x=0; $x <= $#$tests; $x++) {
              my $htest = $tests->[$x];
              if ($htest) {
                 $list .= ", " if ($list);
                 my $n1 = $htest->name();
                 $list .= " <a href=$Http::WEBPROC?GO=GUI::Test::get_test$from&TAB=1&testName=$n1&topo=$selected&enc="
                      . $st->name() . ":$el1 $target>$n1</a>";
              }
            }
            if ($list) {
               my $status =  &getDiskStatus($target, $comps, $st) if ($el1 eq 'd');
               if ($st->type() =~ /3510/ ) {
                   $el_name = $el_name." /In-band test";
               }
               push(@L, [$enc, $el_name, $status->[1], $list]);
            }
          }
       }
     }
  }
  my $t1 = $TEST? $L->{run} : $L->{link};
  $scr->list ($q, { pageSize => 40, interactive => 1,
        nextLine => ($window eq "B")  },
   [
   [ l => $L->{system}, '+sn' ],
   [ l => $L->{comp}        ],
   [ l => $L->{status}, '-' ],
   [ l => $t1 ],
   ],
    \@L,
    [ 
    [ l => 'FILTER', $goForm ],
    ]);

  print $scr->out();
}

sub details {
  my($q) = @_;
  my $State = State->read();
  print Html->body();
  print Html->header2('diagnose.test.list_test', undef, 'Error', undef, {noTabs => 1, noCrumb => 1});
  print "<table border=0><tr><td></table>";

  my $L = Labels->read('GUI::TopoList')->section('details');

  my ($f1, $f2);

  if ($q->{comp}) {
    my($t, $k, $topic) = split(/\:/, $q->{comp});
    my $comp = $State->components("$t:$k");
    return if (!$comp || !exists $comp->{$topic} );
    my $comp = $comp->{$topic};

    my($gif,$t);
    if ($comp->[0] == 2) {
       $gif = "state_2.gif";
       $t = "$L->{compErr}:";
    } else {
       $gif = "state_1.gif";
       $t = "$L->{compWarn}:";
    }
    $f1 = "&nbsp;<img src=/gif/$gif>&nbsp;$t ";
    $f2 = $comp->[1];
  }
  print "<table border=1 cellpadding=2 cellspacing=0 width=90% bgcolor=white>
   <tr><td bgcolor=navy><font color=white><b>$L->{alert_status}</td>
   <tr><td>$f1</td><tr><td>$f2</table>";

}

sub getLinkStatus {
  my($target, $comps, $port) = @_;
  $target = "";
  my($t, $k, $topic) = split(/\:/, $port);
  my $L = Labels->read('GUI::TopoList')->section('details');
  foreach my $l (keys %$comps) {
     if ($l eq "$t:$k") {
        my $comp = $comps->{$l};
        foreach my $t (keys %$comp) {
            if ($t eq "port.$topic.fc_link") {
               my $c = $comp->{$t};
               if ($c->[0]) { # severity != 0
                  return [$c->[1],"<a href=\"javascript:openwindow('comp=$l:port.$topic.fc_link')\" $target><img src=/gif/state_2.gif alt=$L->{san}\" border=0>&nbsp;link</a>"];
               }
            }
        }
     }
  }
  return undef;
}



sub getDiskStatus {
  my($target, $comps, $st) = @_;
  $target = "";
  my $L = Labels->read('GUI::TopoList')->section('details');

  my $l = $st->getDiskList();
  my $name = $st->name();

  foreach my $d (@$l) {
     my $c = $comps->{"$name:$d"};
     if ($c->[0]) {
        my $gif = ($c->[0] == 2) ? "state_2.gif": "state_1.gif";
        return [$c->[1],
          "<a href=\"javascript:openwindow('comp=$name:$d')\" $target><img src=/gif/$gif alt=\"$L->{disk}\" border=0>&nbsp;comp"];
     } 
  } 
  return undef;
}


sub getCompStatus {
  my($target, $comps, $name, $port, $re) = @_;
  $target = "";
  if ($re) {
     foreach my $c (keys %$comps) {
         my $val = $comps->{$c};
         next if ($val->[0] <= 0);
         my($type, $n1, $n2) = split(/\:/, $c, 3);
         if ("$type:$n1" eq $name && $n2 =~ /^$port/) {
            $port = $n2;
            last;
         }
     }
  }
  my $L = Labels->read('GUI::TopoList')->section('details');

  my $c = $comps->{"$name:$port"};
  return undef if (!$c);
  if ($c->[0]) {
     my $gif = ($c->[0] == 2) ? "state_2.gif": "state_1.gif";
     return [$c->[1],
      "<a href=\"javascript:openwindow('comp=$name:$port')\" $target><img src=/gif/$gif alt=\"$L->{compo}\" border=0>&nbsp;comp"];
  } 
  $c = $comps->{"$name:e"};
  return undef if (!$c);
  if ($c->[0]) {
     my $gif = ($c->[0] == 2) ? "state_2.gif": "state_1.gif";
     return [$c->[1],
    "<a href=\"javascript:openwindow('comp=$name:e')\" $target><img src=/gif/$gif alt=\"$L->{compo}\" border=0>&nbsp;enc"];
  } 
  
  return undef;
}

1;
