
package GUI::UrlLaunch;

use strict;
use System;
use Launch;

use vars qw(@CATS);
@CATS = ('3310','9900','domain','3510','a5k','a3500FC','brocade','d2','inrange','mcdata','switch','switch2','se','se2','t3','tape','v880','5210');

sub update {
  my($q) = @_;

  print Html->body();
  my $G = Labels->read();
  my $L = Labels->read("GUI::UrlLaunch");

  my $urls = Util->deserialize("UrlLaunch.txt") || {};

  print Html->header2("admin.system.url_launch");

  if ($q->{ACTION_update}) {
     foreach my $e (keys %$q) {
         if (substr($e,0,4) eq "url_") {
            my $cat = substr($e,4);
            my $val = $q->{$e};
            my $name = $q->{"name_$cat"};
            my $name2 = $q->{"name2_$cat"};
            my $val2  = $q->{"url2_$cat"};
            $urls->{$cat}[0] = $name;
            $urls->{$cat}[1] = $val;
            $urls->{$cat}[2] = $name2;
            $urls->{$cat}[3] = $val2;
         }
     }
     Util->serialize("UrlLaunch.txt", $urls);
     Launch->clear();
     print Html->info($L->{updated});
  }

  my $save;
  my $UF =  System->get_home() . "/DATA/UrlLaunch.txt";
  if (!-f $UF) {
    open(O, System->get_home() . "/System/UrlLaunch.txt");
    open(W, ">$UF");
    my($l);
    while ($l = <O>) {
       print W $l;
    }
    close(O); close(W);
    $urls = Util->deserialize("UrlLaunch.txt") || {};
  }
  my (@array);
  foreach my $cat (@CATS) {
    my $abb = Util->abb("$cat.medium") || $cat;
    push(@array, [ "<b>$abb</b> 1:", "<input type=text name=name_$cat size=15 value=\"$urls->{$cat}[0]\">",
                  "<input type=text name=url_$cat size=50 value=\"$urls->{$cat}[1]\">" ] );
    push(@array, [ "2:", "<input type=text name=name2_$cat size=15 value=\"$urls->{$cat}[2]\">",
                        "<input type=text name=url2_$cat size=50 value=\"$urls->{$cat}[3]\">" ]);
  }

  my $scr = Html::Screen->new();
  $scr->add(" <form><input type=hidden name=GO value=GUI::UrlLaunch::update>");
  $scr->list( $q, {title => $L->{title}, interactive => 0},
   [
   [ r => $L->{type} ],
   [ l => $L->{name} ],
   [ l => $L->{url} ],
   ],
   \@array,
   [
    [ l => 'ACTION_update', $G->{submit_update} ],
   ]);
  $scr->add("</form>");
  print $scr->out();

}

1;
