package GUIAdmin::6120;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: 6120.pm,v 1.8 2004/01/24 23:01:24 ccadieux Exp $

use PDM;
use Util;
use Html;
use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';
use Logic::T3;
use Discover;

sub isDevice {
   my $renv = System->get_renv();
   return 0 if ($renv->{solution} eq "se2");
   return 1;
}

sub description {'Sun 6120'};

sub ipRequired {1}

sub discoverNU {
  my( $q, $post, $util) = @_;
  $q->{NAME} = "6120";
  GUIAdmin::T3::discover($q);

}


#
# returns the t3 that a slave has.
# response to a http request made by a master rasagent.

sub get_Devices {
  my($q, $post, $util) = @_;
  my($l, $loc, @a, $out, $t);

  my(%F);
  if (open(O, $q->{file})) {
     my($cnt1);
     while ($l = <O>) { 
       @a = split(/ +/, $l);
       last if ($cnt1++ > 20000);
       $loc = $a[3];
       $loc = substr($loc,1) if (substr($loc,0,1) eq "[");
       chop($loc) if (substr($loc,-1) eq "]");
       next if ($loc =~ /^\s*$/);
       next if ($loc =~ /\:/);
       $F{$loc} = 1;
     }
     close(O);
     $out = ""; 
     foreach $t (sort keys %F) {
        
        my($ip) = Util->testIp($t,5);
        my $h =  Agent::T3->getWWN($ip);
        if (!$ip) {
           $out .= "ERR=cannot ping $t\n";
        } elsif (!$h->{key}) {
           $out .= "ERR=No Midplane Serial# for $t\n";
        } elsif (!$h->{wwn}) {
           $out .= "ERR=No wwn for $t, probably not a 6120\n";
        } else {
           $h->{ip} = $t;
           $h->{ipno} = $ip;
           require Data::Dumper;
           $Data::Dumper::Indent = 0;
           my $v = Data::Dumper::Dumper($h);
           $out .= "OK=$v\n";
        }
     }
     print "\nOK $out\n";
  } else {
     print "\nERR $q->{file} $!";
  }
}

sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel, $warn);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::default")->section("add");
  require "GUI/Devices.pm";
  print Html->body();
  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my($err, $dev) = Logic::T3->addToConfig($q);
    if ($err) {
       $info = $err->toHtml();
    } elsif ($dev) {
       print Html->info($G->{device_added});
       GUI::Devices::list($q);
       return;
    }
  }
  print Html->header2("admin.gen_maint.add_device", undef, "Sun 6120"," ", {nocrumb => 1});
  print GUI::Devices::add0($q);


  ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";


  my($phost) = "<select name=host><option value=\"\">[$G->{select}]</option>".
              "<option value=\"\" $sel>$G->{local}</option>";
  foreach $x (@$host) {
    next if($x->{dh} eq "Y");
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  my($phostD) = "<select name=datahost>".  "<option value=\"\" $sel>Same Host</option>";
  my $l1 = {hostname => System->hostname(), ip => System->hostname()};
  foreach $x (@$host, $l1) {
    $sel = ($q->{datahost} eq $x->{ip})? "selected":"";
    $phostD .= "<option value=\"" . $x->{ip} . "\" $sel>" . $x->{hostname} ."</option>";
  }
  $phostD .= "<option value=\"*None\">*None</option></select>";

  my $scr = Html::Screen->new();
  $scr->add(" <form  autocomplete=off method=get> <input type=hidden name=GO value=\"GUIAdmin::6120->addDevice\">
              <input type=hidden name=ADD value=6120> $info");
  
  $scr->table({ title => $L->{enter} },
   [
   [ f => $L->{dev_name}, "<input type=text name=name size=15 maxlength=35 value=\"$q->{name}\">" ],
   [ f => $L->{telnet},   "<input type=password name=telnet size=20 maxlength=30 value=\"$q->{telnet}\">" ],
   [ f => $L->{primary},  $phost ],
   [ f => $L->{ip},       "<input type=text name=ip size=40 maxlength=40 value=\"$q->{ip}\">" ],
   ]);

  my @buttons;
  if (!$deny) {
     push(@buttons, Html::Screen->submitButton("ACTION_add", $L->{submit_add})) ;
  }
  push(@buttons, Html::Screen->submitButton("ACTION_back", $L->{submit_back})); 
  $scr->button(undef, \@buttons);

  $scr->add("</form>");
  print $scr->out();

}

sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);

  print Html->body();
  require "GUI/Devices.pm";
   my $deny = Roles->verifyRole($q, "admin");
   my $L = Labels->read("GUIAdmin::default")->section("update");
  my $G = Labels->read();

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_re}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    my($key, $wwn, $wwn2, $ctrl, $t3name) =  
    my $hash = Agent::T3->getWWN($dev->[$x]{ipno}, $q->{host});

    $dev->[$x]{key}   = $hash->{key};
    $dev->[$x]{units} = $hash->{units};
    $dev->[$x]{wwn}   = $hash->{wwn};
    $dev->[$x]{wwn2}  = $hash->{wwn2};
    $dev->[$x]{ctrl_model} = $hash->{ctrl_model};
    $dev->[$x]{name}  = $hash->{name} if ($hash->{name});

    GUIAdmin->clearSlave($q->{host}, $host);
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->error("Device $name updated!", "green");

  } elsif ($q->{ACTION_upd}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host}   = $q->{host};
    #$dev->[$x]{datahost} = $q->{datahost};
    $dev->[$x]{name}   = $q->{name};
    $dev->[$x]{volVerify}   = $q->{volVerify};

    $dev->[$x]{telnet} = Util->encodeAll($q->{telnet});
    $dev->[$x]{class}  = "storage." . $dev->[$x]{type};
    $dev->[$x]{hba}    = $q->{hba};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->error("Device $name updated!", "green");

  } elsif ($q->{ACTION_del}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    #my($State) = State->read();
    #my $key = $dev->[$x]{key};
    #print "Clearing cache on  $key <br>";
    #$State->clearComponent("t3:$key");
    #$State->write();

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change("Device $name deleted");
    $q->{ERR} = Html->error("Device $name deleted!");
    GUI::Devices::list($q);
    return;
  }
out:

  print Html->header2("admin.gen_maint.maint_device", undef, "Sun 6120"," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";

  $ho = "<select name=host><option value=\"\" $sel>$G->{local}</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $sel = ($h->{datahost})? "":"selected";
  my($dataho) = "<select name=datahost><option value=\"\" $sel>$G->{local}</option>";
  my $l1 = {hostname => System->hostname(), ip => System->hostname()};
  foreach $h1 (@$host, $l1 ) {
       $sel = ($h1->{ip} eq $h->{datahost}) ? "selected":"";
       $dataho .= "<option value=\"$h1->{ip}\" $sel>$h1->{hostname}</option>";
  }
  $sel = ($h->{datahost} eq "*None")? "selected":"";
  $dataho .= "<option value=\"*None\" $sel>*None</option></select>";

  $active = ($h->{active} eq "Y") ? $G->{mode_on}: $G->{mode_off};
  my $telnet = Util->decode($h->{telnet});
  my $verify = Html->makeSelect("volVerify", "=$G->{default}|N=$G->{mode_off}|Y=$G->{mode_on}", $h->{volVerify});

  my $scr = Html::Screen->new();
  $scr->add("<form  autocomplete=off method=get> <input type=hidden name=GO value=\"GUIAdmin::6120->updDevice\">
            <input type=hidden name=no value=$q->{no}>  $err");

  $scr->table({ title => $L->{title} },
   [
   [ f => $L->{type}, $h->{type} ],
   [ f => $L->{monitoring}, $active ],
   [ f => $L->{name} , "<input type=text name=name size=40 maxlength=40 value=\"$h->{name}\">" ],
   [ f => $L->{telnet},"<input type=password name=telnet size=20 maxlength=40 value=\"$telnet\">" ],
   [ f => $L->{ip}, $ip         ],
   [ f => $L->{ipno}, $ipno     ],
   [ f => $L->{key}, $h->{key}  ],
   [ f => $L->{wwn}, "$h->{wwn} / $h->{wwn2}" ],
   [ f => $L->{primary}, $ho    ],
   [ f => $L->{verify}, $verify ],
   ]);
   $scr->add("<input type=hidden name=WIN value=$q->{WIN}>");
   
  my ($del_but, $back_but, @buttons) ;
  if (!$q->{WIN}) {
    $del_but = Html::Screen->submitButton("ACTION_del", $L->{submit_delete});
    $back_but = Html::Screen->submitButton("ACTION_back", $L->{submit_back});
  }
  if (!$deny) {
     push(@buttons, Html::Screen->submitButton("ACTION_upd", $L->{submit_update}));
     push(@buttons,  $del_but);

  }
  push(@buttons, $back_but);
  $scr->button(undef, \@buttons);
  $scr->add("</form>");
  print $scr->out();

}


1;

