package GUIAdmin::Subnet;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Subnet.pm,v 1.6 2004/04/30 15:57:50 ccadieux Exp $

use PDM;

use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Discover;
use base 'GUIAdmin';
use Agent::T3;
use Logic::Subnet;

sub description {'Subnet (background)'}
sub isDevice {0}

sub ipRequired {0}

sub discover {
  my( $q, $post, $util) = @_;
  my($o, $err);
  #print Html->body();
  my $LB = Labels->read("GUIAdmin::Subnet");
  my $G  = Labels->read();

  if ($q->{ACTION_back}) {
       GUI::Discover::run($q);
       return;

  # CALLED BY CLient::Discovery
  } elsif ($q->{ip_list}) { 
     my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
     my $prefix = "-p \"$q->{prefix}\"" if ($q->{prefix});
     my $arg = "-I\"$q->{ip_list}\" $prefix -m";
     # selected_host = local | host | ""
     Discover->ras_admin($q->{selected_host}, 
             "discover_subnetp $arg", 
             $renv, $hosts, "subnet");
     return;

  } elsif ($q->{ACTION_confirm}) {
     my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
     my $pre;
     if ($q->{prefixT}) {
        $pre = System->shortHostname();
     } elsif ($q->{prefix}) {
        $pre = $q->{prefix};
     }
     my $arg = "-m" if ($q->{monitor_on});
     $arg .= " -p $pre" if ($pre);
     my ($x, $subnet);
     for ($x=1; $x <= 6; $x++) {
       $subnet .= $q->{"SUB$x"}.":" if ($q->{"SUB$x"});
     }
     chop($subnet) if ($subnet);
     $arg .= " -s $subnet" if ($subnet);
     Discover->ras_admin($q->{host}, "discover_subnetp $arg", $renv, $hosts, "subnet");
     sleep 2;
     return "DISCO";

  }

  my($h) = Html->header2("admin.gen_maint.discovery", undef, $LB->{subnet}, "discover_subnet");
  my($ip)    = Util->name2ip(System->hostname() );
  my($ix) = rindex($ip, ".");
  $ip = substr($ip, 0, $ix);
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my $hosts = "<select name=host><option value=local>$G->{local}</option>";
  foreach my $d (@$host) {
     next if($d->{dh} eq "Y");
     my $sel;
     if($d->{hostname} eq $q->{select_host}){
        $sel = "selected";
	$ip  = Util->name2ip($d->{hostname} );
        my($ix) = rindex($ip, ".");
        $ip  = substr($ip, 0, $ix);

     }
     $hosts .= "<option $sel VALUE=\"$d->{hostname}\" > $d->{hostname} ($d->{ipno})";

  }
  $hosts .= "</select>";

  my $scr = Html::Screen->new();
  $scr->add(" $h  $err <form autocomplete=off method=get> <input type=hidden name=GO value=GUI::Discover::discover>
             <input type=hidden name=PKG value=GUIAdmin::Subnet::discover>");

  $scr->table( { title => "Select Subnet" },
   [
   [ f => $LB->{run}, $hosts ],
   [ f => $LB->{search}, "$LB->{sub1}:<input type=text name=SUB1 value=$ip>&nbsp;
              $LB->{sub2}:<input type=text name=SUB2><br>
        &nbsp;$LB->{sub3}:<input type=text name=SUB3>&nbsp;
              $LB->{sub4}:<input type=text name=SUB4><br>
        &nbsp;$LB->{sub5}:<input type=text name=SUB5>&nbsp;
              $LB->{sub6}:<input type=text name=SUB6><br>
        " ],
   [ f => $LB->{use}, "<input type=checkbox name=prefixT>" ],
   [ f => $LB->{usecustom}, "<input type=text name=prefix value=\"$q->{prefix}\">" ],
   [ f => $LB->{snmp},"<input type=text name=timeout size=2 value=\"$q->{timeout}\">" ],
   [ l => ""],
   [ f => $LB->{mon_on}, "<input type=checkbox name=monitor_on CHECKED>" ],
   ]);
   $scr->button2([ 
      [ l => 'ACTION_confirm', $LB->{submit_confirm} ],
      [ l => 'ACTION_back',    $LB->{submit_back}    ],
      ]);
   $scr->add("</form>");

   print $scr->out();
  return 0;

}


1;
