package Health::GUI;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: GUI.pm,v 1.15 2004/03/18 20:37:21 ccadieux Exp $

 
#             CREATION
####################################################
 
use Health;
use PDM;
use Carp;
use Data::Dumper;
use Catalog;
use Report;
use strict;
use CIM::Instance;
use Message;
use CIM::Key;
use Events;
use Debug;
  
use base 'Health';
sub revision {'$Revision: 1.15 $'}


sub all_logic {
  my($hm ) = @_;
  my($ev,  $x, $h);
  my($l, $s, $rc, $url, $ed, $VAR1);
  my($sd, $pertains, $type, $name, $key);
  CIM->version("1.1");
  $DB::single = 1;


 my $Config = PDM::ConfigFile->read();
 my $renv = $Config->renv();
 my $ip   = Util->name2ip();
 
 my($rep) = {};
 Agent::addIdentification({renv => $renv}, $rep);
 $rep = ReportContent->new($rep);

 #  find out about removed hosts and removed devices frm the GUI

 my($f) = System->get_home() . "/DATA/gui_events";
 if (-f $f) {
    rename $f, "$f.wrk";
    open(O, "$f.wrk");
    while ($l = <O>) {
      chop($l);    
      my(@a) = split(/\t/, $l);
     
      if (substr($a[0],0,2) eq "AM") {  # Alternate master took over
          my ($sev, $desc);
          if ($a[0] eq "AM+") {
             $desc = "Master on $a[2] is down, Alternate-master on $a[1] taking over";
             $sev = 2;
             Grid->setCode("agent.AlternateMaster.start");
          } else {
             $desc = "Master on $a[2] is back, Alternate-master $a[1] releasing";
             $sev = 1;
             Grid->setCode("agent.AlternateMaster.release");
          }
          $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'agent.AlternateMaster'  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Severity    => $sev  ],
                  [ Caption     => "agent.alternate"],
                  [ Target      => "host:$renv->{hostname}"],
                  [ Description => $desc ],
                   ]);
          $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "D"      ],
                    ]);
          $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_ERROR});
          PDM->saveMessage($ed);

      } elsif (substr($a[0],0,2) eq "PP") { # PATCHPRO automated cron
        my $sev = substr($a[0],2) + 0;
        my $text = $a[1];
        $text =~ s/<NL>/\n/g;
       
        my $solid = $renv->{solution} . ":" .
                           $renv->{solution_model} . "." .
                           System->hostid();

        Grid->setCode("agent.ConfigureEvent.revision_maintenance_cron_list");
        my $desc = "Automatic revision maintenance report of patches required on $renv->{solution_model} system was run\n";
	$desc .= $text;
        $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => "agent.ConfigureEvent.revision_maintenance_cron_list"  ], 
                  [ EventId     => PDM->getEventSequence   ],
                  [ Caption     => "Revision Maintenance"  ],
                  [ Severity    => $sev        ],
                  [ Target      => $solid      ],
                  [ Description => $desc      ],
                  [ Data        => $text      ],
                  ]);
        $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
        $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', 
                  [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "D"      ],
                  ] );
        $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_NORMAL});
        PDM->saveMessage($ed);

      } elsif ($a[0] eq "HR") {  # Host rename Event
          my $desc = "This host was renamed from $a[2] to $a[3]";



      } elsif ($a[0] eq "SR" || $a[0] eq "SL") {  # Reserve System
        my($app, $name0, $desc, $date, $expires, $ip, $name) = split(/\|/, $a[1]);
        my $code  = $a[0] eq "SR" ? "SystemReserve" : "SystemRelease";
        my $desc0;
        
        if ($a[0] eq "SR") {
          $desc0 = "This $renv->{solution_model} System was reserved by $name at $date for $expires minute(s): $desc";
        } else {
          my $d1 = Util->get_today();
          $desc0 = "This $renv->{solution_model} System was released by $name at $d1";
        }
        my $solid = $renv->{solution} . ":" .
                           $renv->{solution_model} . "." .
                           System->hostid();

        Grid->setCode("agent.$code");
        $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => "agent.$code"           ],
                  [ EventId     => PDM->getEventSequence   ],
                  [ Caption     => $code       ],
                  [ Target      => $solid      ],
                  [ Description => $desc0      ],
                  ]);
        $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
        $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', 
                  [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "D"      ],
                  ] );
        $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_NORMAL});
        PDM->saveMessage($ed);

      } elsif ($a[0] eq "HR") {  # Host rename Event
          my $desc = "This host was renamed from $a[2] to $a[3]";

      } elsif ($a[0] eq "DH") {  # AgentDeinstall
          Grid->setCode("agent.AgentDeinstallEvent");
          $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'agent.AgentDeinstallEvent'  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Caption     => "agent.deinstall"],
                  [ Target      => "host:$renv->{hostname}"],
                  [ Description => "Agent '$a[1]' was deleted from the configuration of $renv->{hostname}/$ip"],
                   ]);
          $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "D"      ],
                    ]);
          $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_WARNING});
          PDM->saveMessage($ed);

      } elsif ($a[0] eq "PRO") {  # Provider was activated
          Grid->setCode("agent.ProviderEvent");
          my $act = $a[2] eq "Y" ? "turned on" : "turned off";
          $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'agent.ProviderEvent'  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Severity    => Message::SEVERITY_WARNING ],
                  [ Actionable  => 0     ],
                  [ Caption     => "agent.provider"],
                  [ Target      => "host:$renv->{hostname}"],
                  [ Description => "Provider '$a[1]' was $act at the request of '$a[3]'"],
                   ]);
          $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "A"      ],
                    ]);
          $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });
          PDM->saveMessage($ed);


      } elsif ($a[0] eq "CFG") {  # Solution Comfigure Device
          Grid->setCode("agent.ConfigureEvent");
          $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'agent.ConfigureEvent'  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Severity    => Message::SEVERITY_WARNING ],
                  [ Actionable  => 0     ],
                  [ Caption     => "agent.config"],
                  [ Target      => "host:$renv->{hostname}"],
                  [ Description => "$a[1] $a[2] at $renv->{hostname}"],
                   ]);
          $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "A"      ],
                    ]);
          $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });
          PDM->saveMessage($ed);

      } elsif ($a[0] eq "AH") {  # AgentInstall
          Grid->setCode("agent.AgentInstallEvent");
          $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'agent.AgentInstallEvent'  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Caption     => "agent.install"],
                  [ Target      => "host:$renv->{hostname}"],
                  [ Description => "Agent '$a[2]' was added to the configuration of $renv->{hostname}/$ip"],
                   ]);
          $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "A"      ],
                    ]);
          $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });
          PDM->saveMessage($ed);

      } elsif (substr($a[0],0,1) eq "Q") {
          $type = $a[1]; 
          my $wwn = $a[2];
          my ($reason, $info) = split(/\|/, $a[3]);
          my $dev = $Config->deviceByKey($wwn);
          if ($wwn) {
               my($code);
               if (substr($a[0],1,1) eq "S") {
                  $code = "Start";
                  Grid->setCode(lc($type) . ".QuiesceStartEvent");
               } else {
                  $code = "End";
                  Grid->setCode(lc($type) . ".QuiesceEndEvent");
               }
              
               $ev = CIM::Instance->new('NWS_Event', [
                    [ EventType   => lc($type) . ".Quiesce${code}Event"  ],
                    [ EventId     => PDM->getEventSequence  ],
                    [ Target      => "host:$renv->{hostname}"],
                    [ Caption     => "agent.quiesce"],
                    [ Data        => "Reason:$a[3]" ],
                    [ Description => "Quiesce $code on device " . 
                                      uc($type) . " $wwn / $dev->{name}" ],
                     ]);
               $sd = Events->sourceDetector({ event => $ev });
  
               $key = CIM::Key->new( ['NWS_System',
                     'Name'       => $wwn,
                      CreationClassName => 'NWS_System']);
  
               $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                    [ Event       => $ev  ],
                    [ Element     => $key ],
                      ]);
  
               $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                              instances => [$ev, @$sd, $pertains ],
                              severity  => Message::SEVERITY_NORMAL });

               PDM->saveMessage($ed);
           }

      } elsif ($a[0] eq "DD") {
          my($name) = $a[2];
          $type = $a[1]; 
          my $wwn    = Catalog->deviceRead("",Catalog::Name, $name, Catalog::Key);
          if ($wwn) {
               Grid->setCode(lc($type) . ".RemovalEvent");
               $ev = CIM::Instance->new('NWS_Event', [
                    [ EventType   => lc($type) . ".RemovalEvent"  ],
                    [ EventId     => PDM->getEventSequence  ],
                    [ Target      => "host:$renv->{hostname}"],
                    [ Caption     => "agent.remove"],
                    [ Description => "Monitoring of " . uc($type) . " device ($wwn-$name) ended"],
                     ]);
               $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
  
               $key = CIM::Key->new( ['NWS_System',
                     'Name'       => $wwn,
                      CreationClassName => 'NWS_System']);
  
               my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $key ],
                    ]);
 
               $pertains = CIM::Instance->new('NWS_EventPertainsToMonitor', [
                    [ Event       => $ev  ],
                    [ Association => $monitors ],
                    [ DiscoveryType => "D"],
                      ]) ;
  
               $ed = Message->new( { id        => {deviceName => $renv->{hostname} },
                              instances => [$ev, @$sd, $monitors, $pertains ],
                              severity  => Message::SEVERITY_WARNING});
  
               
#               PDM->deleteLastReport(Report->makeFileKey('t300',$wwn) );  not needed
               PDM->saveMessage($ed);
          }
      }
    }
    close(O);
    unlink "$f.wrk";
 }

#
# grab test events
#
 my($f) = System->get_home() . "/DATA/testInfo.log";
 if (-f $f) {
    rename $f, "$f.wrk";
    open(O, "$f.wrk");
    while ($l = <O>) {
      chop($l);    
      eval "$l";
      my $ifile = $VAR1;
      my $desc;
      my $i = $ifile->{info};
      my $type = $i->{dev_type};
      my $command = $ifile->{command};
      my $host = $ifile->{host};
      if ($i->{target2}) {
        $desc = "$command ($host) between $i->{target} and $i->{target2} ";
      } else {
        $desc = "$command ($host) on $i->{target} ";
      }
      my ($sev, $sign);
      if ($ifile->{rc} =~ /^[0,]+$/) {
         $sev  = 0;
         $sign = "P";
         $desc .= "succeeded";
      } else {
         $sev  = 2;
         $sign = "M";
         $desc .= "failed";
      }
      $desc .= ":";

      my $data .= " #OPTIONS -------------------\n";
      my $clean_opt = $ifile->{opts};
      $clean_opt =~ s/passwd=[^\s\=\|]+//;
      $data    .= $clean_opt;
      $data    .= "\n";
      my $ofile = $ifile->{pfile};
      $ofile    =~ s/\t/\n /g;
      $data    .= " $ofile";

      Grid->setCode("$type.DiagnosticTest");
      $ev = CIM::Instance->new('NWS_DiagnosticTestComplete', [
                  [ EventType   => "$type.DiagnosticTest"  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Severity    => Message::SEVERITY_WARNING ],
                  [ Caption     => "$sign.$command"],
                  [ FailureCode => $ifile->{rc}],
                  [ Target      => "$type:$i->{key}" ],
                  [ Actionable  => 0 ],
                  [ Severity    => $sev ],
                  [ StartDate   => $ifile->{start_date}],
                  [ EndDate     => $ifile->{end_date}],
                  [ Description => $desc ],
                  [ Data        => $data ],
                   ]);

      $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "D"      ],
                    ]);
      $ed = Message->new( { id        => {deviceName => $i->{key} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_ERROR});
      PDM->saveMessage($ed);
      
    }
    close(O);
    unlink "$f.wrk";
 }


}

1;
