package Html::Screen;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Http;
use System;
use Html::List;
use strict;
use bytes;


sub new {
  my($class, $arg) = @_;
  $arg = {} if (!defined $arg);
  bless($arg, "Html::Screen");
  $arg->{out} = "";
  $arg->{isForm} = 0;
  $arg->{width} = $Style::WIDTH if (!$arg->{width});
  my $renv = System->get_renv();
  $arg->{hci2} = 1; # if (substr($renv->{color_scheme},0,3) eq "hci");
  return $arg;
}

sub script {
  my($obj, $script) = @_;
  $obj->{script} .= $script;
}

##############################
#  LIST
##############################
#
#   $arg = { title => "title" rightTitle => "[ link ]",   empty => "No alarm found"
#            topAndBottom => 1,
#            width => "90%",  help => "help", pageInfo => 0 nextLine => 1 }
#  [
#  [ l => label, '+sn', \&func1 ],
#  [ r => label, '-'            ],
#  [ c => label, '-'            ],
#  ], 
#  [ [ row1val1, row1val2 ...],
#    [ row1val1, row1val2 ...],
#  ]

sub report {
  my($obj, $q, $args, @a) = @_;
  $args->{isReport} = 1;
  return $obj->list($q, $args, @a);
}

sub list {
  my($obj, $q, $args, $list, $array, $allbuttons) = @_;
  my($out, $x, $y, $headers, $justify, $sorts, $colDisplay);
  my $max;
  my $renv = System->get_renv();

  my (@headers, @justify, @sorts, @colDisplay, $buttons, $old_buttons, $right_buttons, $bcnt);
  my (@colHide, $isFilter, $top_buttons);
  ($buttons, $top_buttons, $right_buttons, $bcnt, $isFilter) =  $obj->button2($allbuttons, 2);

  foreach my $el (@$list) {
     push(@headers,     $el->[1]);
     push(@justify,     $el->[0]);
     push(@sorts,       $el->[2]);
     push(@colDisplay,  $el->[3]);
     push(@colHide,     $el->[4]);
     $max++;
  }
  my $width = $args->{width} || $obj->{width};
  my $help = $args->{help};

  my $head = $args->{error};
  $head .= "<table border=0 cellpadding=3 bgcolor=white width=$width><tr><td>$help</table>" if ($help);

  if ($obj->{hci2}) {
    $head .= "<table class=Tbl border=1 width=$width cellspacing=0 cellpadding=1 bgcolor=white>";
  } else {
    $head .= "<table border=1 width=$width cellspacing=0 cellpadding=1 bgcolor=white>";
  }
  $head .= "<tr><td class=Thead colspan=$max bgcolor=$Style::DARK>
              <font color=white>&nbsp;<b>$args->{title}</td>" if ( $args->{title});

  $args->{colDisplay} = \@colDisplay;
  $args->{colHide}    = \@colHide;
  $args->{hci2}  = $obj->{hci2}; 

  my($page_info, $out1, $tot_pages, $tot_lines, $many_info, $page_info0) = Html::List->makeList($q, $array, \@headers, \@justify, \@sorts, $args);
  
  $obj->{out} .= $head;
  $page_info = "" if (exists $args->{pageInfo} && !$args->{pageInfo} );

  if ($tot_lines == 0 && $args->{empty}) {
     $out1 .= "<tr><td colspan=$max>&nbsp;$args->{empty}</td>";
  }

  if ($tot_pages > 1 || $bcnt > 0 || $page_info) {
    my $list_bg = $renv->{color_scheme} eq "hci2" ? "bgcolor=$Style::LIST_BG" : "";
    my($al, $tr);
    if ($args->{nextLine}) {
       $tr = "<tr>";  
    }
    my $p = "<tr><td colspan=$max $list_bg>".
            "<table class=Tclear border=0 cellspacing=0 xwidth=100% cellpadding=0>" .
            "<tr><td class=TclearTd xwidth=5%  nowrap>$top_buttons</td>".
                "$tr<td class=TclearTd nowrap $al>|&nbsp;$many_info&nbsp;$page_info0</td>".
                "<td class=TclearTd align=right>$right_buttons</td>".
            "</table></td>";
    my $p2 = "<tr><td colspan=$max $list_bg>".
            "<table class=Tclear border=0 cellspacing=0 xwidth=100% cellpadding=0>" .
            "<tr><td class=TclearTd xwidth=5% nowrap>$buttons</td>".
                "$tr<td class=TclearTd>|&nbsp;</td><td class=TclearTd nowrap $al>$page_info</td>".
                "<td class=TclearTd align=right>$right_buttons</td>".
            "</table></td>";

    if ($args->{bottomButton} && $tot_pages == 1) {
      $obj->{out} .= "$out1<tr><td></td><tr><td></td>$p2";
    } else {
      $obj->{out} .= $p; #   if ($args->{topAndBottom} || $isFilter || $renv->{solution} ne "N");

      $obj->{out} .= "$out1<tr><td></td><tr><td></td>$p2";
    }
  } else {
    $obj->{out} .= $out1;
  }
  $obj->{out} .= "</table>$old_buttons<table border=0><tr><td></table>";
}


###############################
#  TABLE
###############################
#
#   $arg = { title => "title" ,  width=> "90%", labelWidth => "20%", help =>}
#  [
#  [ l => label ]
#  [ i => info  ]  # no special backgroupd color
#  [ f => label, $val, position(1/2/3) ]
#  ]

sub table {
  my($obj, $arg, $list) = @_;
  my($x);
  my $out;
  my $width = $obj->{width};
  my $help = $arg->{help};
  my $labelW = "width=" . ($arg->{labelWidth}|| "40%");
  my $renv = System->get_renv();

  $out .= $arg->{error};
  $out .= "<table border=0 cellpadding=3 bgcolor=white width=$width><tr><td>$help</table>" if ($help);

  $out .= "<table border=1 width=$width cellspacing=0 cellpadding=1 bgcolor=white><tr><td>";
  $out .= "<table class=TblMenu border=0 width=100% cellspacing=1 cellpadding=1 bgcolor=white>";

  my $max = 0;
  for ($x=0; $x <= $#$list; $x++) {
        my $line = $list->[$x];
        next if (!$line);
        my $c = 1;
        $c = $line->[3] if ($line->[3]);
        $max = $c if ($c > $max);
  }
  $out .= "<tr><td colspan=" . ($max*2) ." bgcolor=$Style::DARK><font color=white><b>$arg->{title}</td>" if ($arg->{title});

  my $bg =  "bgcolor=$Style::FORM_LIGHT";
  for ($x=0; $x <= $#$list; $x++) {
        my $line = $list->[$x];
        next if (!$line);
        if ($line->[0] eq 'i') {
           my $cs = $max*2;
           $out .= "<tr><td colspan=$cs>$line->[1]</td>";
        } elsif ($line->[0] eq 'lh') {
           my $cs = $max*2;
           $out .= "<tr><td colspan=$cs $line->[1]</td>";
        } elsif ($line->[0] eq 'l') {
           my $cs = $max*2;
           $out .= "<tr><td colspan=$cs bgcolor=$Style::DARK><table class=Tclear border=0 cellspacing=0><tr><td class=TclearTd><b><font color=white>$line->[1]</table>";
        } else {
           my $cs = "";
           if (!defined($line->[3])) {
              $out .= "<tr>";
              $cs = "colspan=" . ($max*2-1) if ($max > 1);
           } elsif ($line->[3] == 1) {
              $out .= "<tr>";
           }
           my $id = "lb$x";
           $out .= "\n<td $bg $labelW align=right><label for=$id>$line->[1]:</label></td>";
           
           my $nb = "&nbsp;" if (substr($line->[2],0,1) ne "<");
           $line->[2] =~ s/<input /<input id=$id /;
           $out .= "\n<td $cs>$nb$line->[2]</td>";
           $out .= "</td>" if (!defined($line->[3]) || $line->[3] == $max);
        }
        $out .= "\n";
   }
   $out .= "</table></table>";

   $obj->{out} .= $out;
}

#############################
# BUTTON
#############################
sub button {
  my($obj, $left, $center, $right, $return) = @_;

  my $width = $obj->{width};
  $obj->{isForm} = 1;
  my $out;
  if ($obj->{hci2}) {
    my ($left2, $right2);
    foreach my $b (@$left, @$center) {
      $left2 .= "$b ";
    }
    foreach my $b (@$right) {
      $right2 .= "$b ";
    }
    $out = "<table border=0 width=$width cellpadding=0>".
                     "<tr><td>$left2</td><td align=right>$right2</table>";
  } else {
    my ($center2, $left2, $right2);
    foreach my $b (@$left) {
      $left2 .= "$b ";
    }
    foreach my $b (@$center) {
      $center2 .= "$b ";
    }
    foreach my $b (@$right) {
      $right2 .= "$b ";
    }
    $out .= "<table border=0 width=$width cellpadding=0>".
                     "<tr><td>$left2</td><td><center>$center2</td><td align=right>$right2</table>";
  }
  if ($return) {
     return $out;
  } else {
     $obj->{out} .= $out;
  }
}

#############################
# BUTTON2
#############################
#  l=left,c=center,r=right
#  [
#  [ l|c|r => 'ACTION_upd', $G->{submit_update}, $deny ],
#  [ l|c|r => 'ACTION_back', $G->{submit_back}, $deny ],
#  [ l|c|r => 'DATA', "<input type=text ...>", $deny ],
#  [ l|c|r => 'FILTER', "<input type=text ...>", $deny ], # go at the top
#  ]

sub button2 {
  my($obj, $bs, $return) = @_;
  my($left, $top, $right, $out);
  my $width = $obj->{width};
  $obj->{isForm} = 1;
  my $HEAD = "<table class=Tclear border=0 cellspacing=0 cellpadding=1><tr>";
  my $right_flag;
  my ($bcnt, $filter);

  foreach my $b (@$bs) {
     next if ($b->[3] || !$b->[2]);
     my $extra = $b->[4];
     $filter = 1 if ($b->[1] eq "FILTER");
     my $button = (index(",FILTER,DATA,",",$b->[1],") >= 0) ? $b->[2] : $obj->submitButton($b->[1], $b->[2], undef, $extra);
     $bcnt++;
     if ($b->[1] eq "FILTER") {
        $top .= "<td class=TclearTd>$button</td><td></td>";
     } elsif ($b->[0] eq "l" || $b->[0] eq "c") {
        $top  .= "<td class=TclearTd>$button</td><td></td>";
        $left .= "<td class=TclearTd>$button</td><td></td>";
     } else {
        $right .= "<td class=TclearTd>$button</td><td></td>";
     }
  }
  $left  = "$HEAD$left</table>"  if ($left);
  $top   = "$HEAD$top</table>"   if ($top);
  $right = "$HEAD$right</table>" if ($right);

  if ($return == 2) {
     return ($left, $top, $right, $bcnt, $filter);
  } else {
     $out = "<table class=Tclear border=0 width=$width cellpadding=0>".
                 "<tr><td class=TclearTd>$top</td><td class=TclearTd></td><td class=TclearTd align=right>$right</table>";
     $obj->{out} .= $out . "<table border=0><tr><td></table>";
  }

}


# Html::Screen->submitButton("nane","value");
sub submitButton {
  my($class, $name, $value, $title, $args) = @_;
  my $extra = $args->{extra};
  my $confirm = "onclick=\"return confirm('$args->{confirm}')\"" 
                 if ($args->{confirm});
  $title = $value if (!$title);
  if (Http::css_button()) {
    return <<EOF;

  <input name="$name" type="submit" class="Btn1" value="$value" title="$title"
    onmouseover="javascript:this.className='Btn1Hov'"
     onmouseout="javascript:this.className='Btn1'"
         onblur="javascript:this.className='Btn1'"
        onfocus="javascript:this.className='Btn1Hov'"
       $confirm
       $extra
  />
EOF
  } else {
   return 
    "\n<input name=\"$name\" type=submit  value=\"$value\" title=\"$title\"
      $confirm
      $extra >\n";
  }
}


# 
# makes a complete form out of hiddens and data, adds GO at the end
#
sub goForm {
  my($scr, $hiddens, $data) = @_;
  my $G = Labels->read();
  my $out = "<table border=0 class=Tclear cellspacing=0 cellpadding=1><tr><td><form>";
  foreach my $h (@$hiddens) {
    my($n, $v) = split(/\=/, $h, 2);
    $out .= "<input type=hidden name=$n value=\"$v\">";
  }
  $out .= "</td><td class=TclearTd nowrap>$data&nbsp;" . Html::Screen->submitButton("ACTION", $G->{go}) ."</td><td></form></table>";
  return $out;
}


sub out {
   my($obj) = @_;
   my $out;
   $out .= "<script>\n$obj->{script}\n</script>" if ($obj->{script});
   $out .= $obj->{out};
   return $out;
}

sub add {
  my($obj, $text) = @_;
  $obj->{out} .= $text;
}

1;


