package Logic::5210;

use Util;
use strict;
use Agent::5210;
use Logic;

sub addToConfig {
   my($class, $q) = @_;
   my ($err, $active, $x);
   $active = "Y";
   my @nodes;
   my $G = Labels->read();

   while (1) {
     if (!$q->{ip}) {
           $err = Error->error(103);
           last;
     } else {

        my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
        
	my $rc = Agent::5210->getWWN($q->{ip}, $q->{host});
        if (!$rc->{key} || $rc->{error} ) {
           $err = Error->error(no_device => "$q->{ip}</b> $rc->{error}");
           last;
        }

        my $key = $rc->{key};
        if (!$key) {
           $err = Error->warning("cannot_discover",  "$q->{ip}");
           last;
        }
        my %THERE;
        foreach $x (@$devs) {
          if (index("5210", $x->{type}) >= 0) {
             $THERE{$x->{key}} = 1;
          }
        }
        if (!$THERE{$key}) {
           $x = $#$devs + 1;
           PDM::ConfigFile->addDevice($devs, {
           type     => $rc->{type},
           class    => "storage.".$rc->{type},
           key      => $key,
           name     => $q->{name} || $q->{ip},
           active   => $active,
           ip       => $q->{ip},
           ipno     => $rc->{ipno} || $q->{ip},
           host     => $q->{host},
           userLabel => $q->{userLabel},
           });
           Logic->clearSlave($q->{host}, $hosts);
           push(@nodes, $devs->[$x]);

           if (!PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs)) {
             $err = Error->error(101);
           }
        }
     }
     last;
    }
out:
    return ($err, \@nodes);
}
   
1;

