package MaxEvents;
use System;
use Util;
use strict;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#
#  $Id: MaxEvents.pm,v 1.6 2003/12/05 00:56:26 ccadieux Exp $

use vars qw ($MAX $MAX_DB);


sub clean {
  my($object) = @_;
  $MAX_DB = RasDB->new("MAXEVENTS");
  $MAX = $MAX_DB->hash();

  my $today = int(time / 60);
  $MAX_DB->Lock();

  foreach my $el (keys %$MAX) {
     my $val = $MAX->{$el};
     if ($today - $val->[1] > (7 * 24 * 60)) {   # one week old
        delete $MAX->{$el};
     }
  }
  $MAX_DB->UnLock();
}

sub clear {
  my($class, $type) = @_;

  $MAX_DB = RasDB->new("MAXEVENTS");
  $MAX = $MAX_DB->hash();

  $MAX_DB->Lock();
  foreach my $el (keys %$MAX) {
     my($el_type, $rest) = split(/\:/, $el, 2);
     if ($el_type eq $type) {
        delete $MAX->{$el};
     }
  }
  $MAX_DB->UnLock();
}

sub delete {
   unlink System->get_home() . "/DATA/MAXEVENTS.db";
   unlink System->get_home() . "/DATA/MAXEVENTS.db.lock";
}
  


# if actionable ==1 , only count actionable events
sub maxEvents {
  my($object, $type, $ev, $user, $max, $hours) = @_;

  $MAX_DB = RasDB->new("MAXEVENTS");
  $MAX = $MAX_DB->hash();
  my $renv = System->get_renv();
  return (0,0) if ($renv->{send_all_events});

  $user =~ s/\:/_/g if ($user);
  return (0,0) if (System->get_eventMaxOff());

  my $target  = $ev->value('Target');
  my $et      = $ev->value('EventType');
  my $caption = $ev->value('Component') || $ev->value('Caption');
  my $act     = $ev->value('Actionable');

  $hours = 8 if (!$hours);
  my $last_email;

  my $caption0 = $caption;
  if (substr($target,0,5) eq "host:" && index($caption, "lun.") >= 0) {
     $caption0 = "lun";

  } elsif (substr($caption0,0,2) eq "M." ||
           substr($caption0,0,2) eq "P." ||
           substr($caption0,0,2) eq "X.") {
     $caption0 = substr($caption0,2);
  }
  my $email_key = "$type:$user:$target:$caption0:$act"; # separate count for actionable and non-act.

  if ($max) {
    $MAX_DB->Lock();
    my $today = int(time / 60);
    my $max1 = [];
    if ( exists($MAX->{$email_key}) ) {
       $max1 = $MAX->{$email_key};
       if ($today - $max1->[1] > ($hours * 60)) {  # compare to last event
          $max1->[0] = 0;
          $max1->[3] = 0;

       } elsif ($today - $max1->[3] > ($hours * 60) && ($max1->[0] < $max)) {  
          $max1->[0] = 0;                         # compare to first event
          $max1->[3] = 0;

       } elsif ($max1->[0] == $max-1) {
         $last_email = 1;
         $max1->[2] = Util->get_today();             # END OF WINDOW

       } elsif ( $max1->[0] >= $max) {  # INC counter, no DATA change
         $max1->[0]++;
         $MAX->{$email_key} = $max1;
         $MAX_DB->UnLock();
         return (1, $last_email);
       }
    }
    $max1->[1] = $today;                   # DATE OF LAST EVENT
    $max1->[3] = $today if (!$max1->[3]);  # START OF WINDOW
    $max1->[0]++;
    $MAX->{$email_key} = $max1;
    $MAX_DB->UnLock();
  }
  return (0,$last_email);
}


1;
  

