package Message;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Message.pm,v 1.6 2004/03/16 21:15:54 ccadieux Exp $

use Carp;
use Data::Dumper;
use CIM::Instance;
use strict;
use Ilist;
use CIM::Property;
use CIM::GenInstance;

sub SEVERITY_NORMAL  {0}  # 4
sub SEVERITY_GREEN   {0}  # 4
sub SEVERITY_WARNING {1}  # 3
sub SEVERITY_ERROR   {2}  # 2 
sub SEVERITY_DOWN    {3}  # 1

use vars qw (%SEV_MAP);
%SEV_MAP = (0 => 'Information', 1 => 'Major', 2 => 'Critical', 3 => 'Down');


sub TYPE_EVENT      {'E'}
sub TYPE_ALERT      {'A'}

sub STATUS_NEW       {'N'}
sub STATUS_PROCESSED {'P'}
#
#  $ilist = Ilist->new($ARRAYREF);
#  $ed = Message->new({
#		type      => 'E' | 'A'  # Event / Alert
#		id        => $id, 
#		instances => $ilist, 
#		severity  => 1 
#		});
#

sub new {
  my($self, $arg) = @_;
  my($x);
  my $renv = System->get_renv();
  my($ed) = {};
  if (ref($arg->{instances}) eq "Ilist") {
     $ed->{_instances} = $arg->{instances};
  } elsif (ref($arg->{instances}) eq "ARRAY") {
     $ed->{_instances} = Ilist->new($arg->{instances});
  } else {
    croak("instances must be Ilist of ARRAYREF");
  }
  my($il) = $ed->{_instances};

#  my($eid) = $il->[0]->propertyByName('EventId')->value;
#  for ($x = 1; $x <= $#$il; $x++) {
#     my($ins) = $il->[$x];
#     $ins->addProperty(CIM::Property->new(['GroupId',$eid,'string',0]));
#  }
  $ed->{X}{_type}      = $arg->{type} || 'E';
  $ed->{X}{_count}     = $#{$arg->{instances}} + 1;
  $ed->{X}{_id}        = $arg->{id} || croak("Message need id");
  $ed->{X}{_severity}  = $arg->{severity} || 0;
  $ed->{X}{_version}   = $renv->{version};
  $ed->{X}{_sequence}  = $arg->{sequence}; # PDM->getDocSequence;
  $ed->{X}{_status}    = STATUS_NEW;

#   use to call State->saveState, other field from the event ($ed->{instances}[0])
#   ($ev->value('Target'), $ev->value('TargetName'), 
#   use  $ed->{X}{_severity} if present.
#                      [ comp, avail, "type:key", absolute=1]  # use to call saveState
  $ed->{X}{_state}     = $arg->{state};

  bless($ed, "Message");
  return $ed;
}

sub fileNo {
   my($ed, $no) = @_;
   $ed->{X}{_fileNo} = $no if (defined($no));
   return $ed->{X}{_fileNo};
}

#
# $ed->toXML({indent => 0, skipAss => 1});
#
sub toXML {
  my($ed, $args) = @_;
  my($i, $content);

  $Data::Dumper::Indent = 0;
  my($header) = Dumper($ed->{X});
  $header = substr($header, 7);
  my($ilist) = $ed->{_instances};
  #return $header . "\n" . $ed->{_instances}->toXML($args);
  return "<EVENT>" . $ilist->toXML($args) . "</EVENT>";
}



sub toString {
  my($ed, $list) = @_;
  my($i, $content);

  $Data::Dumper::Indent = 0;
    
  my($header) = Dumper($ed->{X});
  $header = substr($header, 7);

  return "==>Message Header\n" . $header . "\n" . $ed->{_instances}->toString;
}

sub toSerial {
  my($ed) = @_;
  my($x, $content, $i);

  my($t) = {};
  $Data::Dumper::Indent = 0;
  my($header) = Dumper($ed->{X});
  my($ins) = $ed->{_instances};
  foreach $i (@$ins) {
     $content .= " " . $i->toSerial;
  }
  return "H" . $header . "\n" . $content;
}

#
#  $ed = Message->fromString($string);
#
sub fromSerial {
  my($class, $string) = @_;
  my($ed, $x, $ins, @ins) ; 

  my(@l) = split(/\n/, $string);
  if (substr($l[0],0,1) ne "H") {
     Debug->err('INVALID_ED');
     return undef;
  } else {
     my($head) = eval substr($l[0],1);
     if ($@) {
        Debug->err('INVALID_ED');
        return undef;
     }
     for ($x = 1; $x <= $#l; $x++) {   
         push(@ins, CIM::Instance->fromSerial($l[$x]));
     }
     $ed->{X} = $head;
     $ed->{_instances} = \@ins;
     bless($ed, "Message");
     return $ed;
  }
}

sub do {
  my($level, $key, $save, $rc, $kname) = @_;
  my($x, $o, $v);
  
  if ($level == 0) {
    $o = $key->className ;
  } else {
    $o = "R" . $$rc . "\treference\t$kname\t" . $key->className ;
  }
  my($keys) = $key->keys;
  for ($x=0; $x<=$#$keys; $x+=2) {
     if (ref($keys->[$x+1])) {
       $$rc = $$rc + 1;
       $v = "R$$rc";    
       &do($level + 1, $keys->[$x+1], $save, $rc, $keys->[$x]);
     } else {
       $v = '"' . $keys->[$x+1];
     }
     $o .= "\t$keys->[$x]\t$v";
  }
  $o .= "\n";
  if ($level == 0) {
    return $o;
  } else {
    push(@$save, $o);
  }
}

#
#  $ed->toC()

sub toC {
   my($ed, $list) = @_;
   my($o, $p, $i, $k, $keys, $x, $v, @save, $rc, $quals, $x1);
   my($ins);
   $Data::Dumper::Indent = 0;
   my($header) = Dumper($ed->{X});
   $header = substr($header, 7);

   return "+E " . $header . "\n". $ed->instances->toC . "-E\n";
}

sub fromC {
   my($class, $s) = @_;
   my($ed);
   my($ix) = index($s, "\n");
   if ($ix < 0) {
      Debug->print2("Invalid Message stream");
      $ed = {};
      bless($ed, "Message");
      return $ed;
   }
   my($head) = eval substr($s,2, $ix -2);
   if (ref($head) ne "HASH") {
     Debug->print2("Message->fromC: Invalid Message header");
     return undef;
   }
   $ed->{X} = $head;
   $ed->{_instances} = Ilist->fromC(substr($s, $ix+1));

   bless($ed, "Message");
   return $ed;
}


sub count {
  my($ed) = @_;
  return $ed->{X}{_count};
}

sub id {
  my($ed, $parm, $value) = @_;
  if (defined($value)) {
     $ed->{X}{_id}{$parm} = $value;

  } elsif ($parm) {
    return $ed->{X}{_id}{$parm};
  } else {
    return $ed->{X}{_id};
  }
}

sub type {
  my($ed) = @_;
  return $ed->{X}{_type};
}

sub status {
  my($ed) = @_;
  return $ed->{X}{_status};
}

#
# className of the first instance
sub className {
  my($ed) = @_;
  my($d);
  eval {
   $d = $ed->instances()->[0]->className;
  };
  return $d;
}

# returns the adjusted severity if present

sub severity2 {
  my($ed) = @_;
  if ($ed->{X}{_severity}) {
     return $ed->{X}{_severity};
  } else {
      my $ev = $ed->instances()->[0];
      return $ev->value("Severity");
  }
}

# description of eventDoc is description of event which is first instance.
sub description {
  my($ed) = @_;
  my($d, $ev) ;
  eval {
    $ev = $ed->instances()->[0];
    $d  = $ev->propertyByName('Description')->value;
  } ;
  return $d;
}

sub eventData {
  my($ed, $prop) = @_;
  my($d, $ev) ;
  eval {
    $ev = $ed->instances(0);
    $d  = $ev->propertyByName($prop)->value;
  } ;
  return $d;
}

sub eventTime {
  my($ed, $prop) = @_;

  my $time = $ed->eventData("EventTime");
  return Message->eventTime0($time) if ($time);
}

sub eventTime0 {
  my($class, $time) = @_;
  return substr($time, 0,4) . "/" . substr($time,4,2) . "/" . 
            substr($time,6,2) . " " . 
            substr($time,8,2) .":" .
            substr($time,10,2) .":" .
            substr($time,12,2) ;
}

sub instances {
  my($ed, $cnt) = @_;
  if (defined($cnt)) {
    my($i) = $ed->{_instances}[$cnt];
    if ($i) {
      return $i;
    } else {
      return CIM::GenInstance->new('EmptyInstance', 'O', []);
    }
  } else {
    return $ed->{_instances};
  }
}

sub sequence {
  my($ed) = @_;
  return $ed->{X}{_sequence};
}

sub state {
  my($ed) = @_;
  return $ed->{X}{_state};
}

sub severity {
  my($ed) = @_;
  return $ed->{X}{_severity};
}

# Verify that all instances are referred to.
# with complete=1, all references must have an instance to point to.
# returns 'undef' if everything requested is ok.
# print $ed->verify(1);

sub verify {
  my($ed, $complete) = @_;
  my($x, $i, $p, $r1);
  my(%X); 
  my($out);
  return $ed->{_instances}->verify;
}

#
#  $ins_array_ref = $ed->nextInstances($start_ins, { association => 'className'});
#  $ins_array_ref = $ed->nextInstances($start_ins);  # over all associations
#  $ins_array_ref = [[$ins, $ass], [$ins2, $ass2] ... ]
#
sub nextInstances {
  my($ed, $start, $arg) = @_;
  my(%X , $x, $i, $follow, $r1, @found, $p);
  my($k) = $start->key->shortString;
  my($ins) = $ed->{_instances};

  for ($x = 0; $x <= $#$ins; $x++) {
      $i = $ins->[$x];
      $X{$i->key->shortString} = $i;
  }
  for ($x = 0; $x <= $#$ins; $x++) {
      $i = $ins->[$x];
      if ($i->instanceType eq "A") {
         next if ($arg->{association} && $i->className() eq $arg->{association});
         $follow = 0;
         foreach $p (@{$i->properties()}) {
            if ($p->isReference) {
               $r1 = $p->value->shortString;
               if ($r1 eq $k) {
                  $follow =1 ; last;
               }
            }
         }
         if ($follow) {
            foreach $p (@{$i->properties()}) {
               if ($p->isReference) {
                  $r1 = $p->value->shortString;
                  if ($r1 ne $k) {
                     push(@found, [$X{$r1},$i] ) if ($X{$r1});
                  }
               }
            }
         }
      }
   }
   return \@found;
}



  

1;

# 1;
#


__END__

=head1 NAME

Message.pm - EventDocument: set of instances with header


=head3 SYNOPSIS

 use Message;

 $ed = Message->new({id       => { ... }
                      severity => $sev,
                      instances => [ list of instances ]});


=head3 DESCRIPTION

This module contains a complete NWS Event including an Instance List and
identification information: DeviceId, Severity, Status etc..
These objects are generated by the healthMonitors and are consumed by
the Providers: Email, shuttle etc..

=head3 CONSTRUCTOR

=over

=item new( { ... });

 $ed = Message->new({id       => { .. },
                      severity => $sev,
                      instances => [ list of instances ]});

=back

=head3 METHODS

=over 4

=item toString();

return the Message as readable text for debugging purposes.

=item toSerial();

Serialize the Message for transmission.

=item fromSerial();

Unserialize the Message for transmission.


=item toC();

Convert the Message into a newline delimited list of tab delimited fieds that
can represent instances, qualifiers, associations, properties .... 
Very easy to parse.

=item count();

returns the number of instances in the Object.

=item id();

returns the ReportId data structure

=item status();

returns the status

=item className();

returns  className of the first instance (the event itself).

=item description();

returns description of the first instance (the event itself).

=item sequence();

returns the sequence of that eventDoc

=item severity();

returns the severity.

=item verify();

Verifies that all instances are referred to. with verify(1), verifies that
all associations point to something that is present. Can be called statically.

 Example:
    $err = $ed->verify(1);  # method of an existing Message
    print $err if ($err);
    Message->verify($instance_list,1); # called as a static method against an inst-list.

=item tree();

Generates a traditional tree structure from the instance list. Tree structures 
are easier to traverse since each instance node containst a list of all other
nodes that are accessible from that node. In CIM instances do not have references
to other instances, other nodes (associations) contain that information. 
Can be called statically

 Example:
    $tree = $ed->tree();  # method of an existing Message
    eventDoc->tree($instance_list); # called as a static method against an inst-list.

=back 4

=head3 SEE ALSO




=head3 AUTHOR

 Christian Cadieux (ccadieux@central.sun)



=head3 COPYRIGHT

Copyright (c) 2000 Sun Microsystems

=cut
