package Modules;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Modules.pm,v 1.2 2004/01/13 17:05:45 ccadieux Exp $

use System;
use Debug;
sub revision {'$Revision: 1.2 $'}


#
#  read and load modules from a directory
#  STATIC call
#  Modules->load("Agent");
#
sub load {
  my($pdm, $dir, $skip, $prefix) = @_;
  my($mod, @admins);
  my $mods = $pdm->read($dir, $skip, $prefix);

  foreach $mod (@$mods) {
     my $pm = "$dir/${mod}.pm";
     $pm =~ /(.+)/;  # TAINT
     if (eval "require \"$1\"") {

     } else {
        Debug->err(LOAD_MODULE => "Error in load_$dir: $@ ");
        print "Error in Modules::load $dir/$mod: $@ <br>";
     }
  }
  return $mods;
}

sub loadOne {
  my($class, $file) = @_;
  $file =~ s/::/\//g;
  $file .= ".pm" if (substr($file,-3) ne ".pm");
  my $F = System->get_home() . "/lib/$file";
  if (-f $F) {
    if (eval "require \"$file\"") {
       return undef;
    } else {
       return "Cannot load $F: $@";
    }
  } else {
    return "Cannot load $F: $!";
  }
}


# reads packages in a dir, return a list of file names without the '.pm'
# called by rasagent load_agents

sub read {
  my($pdm, $dir, $skip, $prefix) = @_;
  my($d0, @mods, $d);
  my $home = System->get_home();
  if (!$home) {
     my($local_p) = $INC[$#INC];
     my($ix) = rindex($local_p, "/");
     $home = substr($local_p,0,$ix);
  }
  
  if (opendir(O, "$home/lib/$dir")) {
    while ($d0 = readdir(O)) {
       next if (substr($d0,-3) ne ".pm");
       $d = substr($d0, 0, -3);
       next if ($skip && $d eq $skip);
       next if ($prefix && substr($d,0,length($prefix)) ne $prefix);
       push(@mods, $d);
    }
    closedir(O);
    return \@mods;
  } else {
    return undef;
  }
}

# traverse the class field from end, find a module in $dir/ , load it and return
# the dir::module name
sub findFromClass {
  my($mod, $dir, $class) = @_;
  my $x;
  $class = uc($class);
  my @l = split(/\./, $class);
  my($D) = System->get_home() . "/lib/$dir";

  for ($x= $#l; $x >= 0; $x--) {
     my $mod = $l[$x];
     if (-f "$D/$mod.pm") {
        require "$dir/$mod.pm";
        return $dir . "::$mod";
     }
  }
  return undef;
}




1;
