package NWS::A5K;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: A5K.pm,v 1.4 2004/05/19 20:22:20 mckenney Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.4 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j);
  my($CTRL);

  my $FRU_count = 0;

  $FRU_count = 10; 
  # 3 power supplies,2 fans,2 backplanes,2 IB's,1 interconnect assembly
  
  foreach $i ('disk_front','disk_rear') {
    for ($j=0; $j < 30; $j++) {
      next if (!$rep->get("$i.$j.product_id"));

      $FRU_count++;
    }
  }

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 				  => $rep->get('id.wwn')],
                    [WWN  		  => $rep->get('id.wwn')],
                    [SystemName           => $rep->get('id.name')],
                    [OtherIdentifyingInfo => "wwn=".$rep->get('id.wwn')],
                    [SysRevision          => $rep->get('revision.value')],
                    [Fan0Revision         => $rep->get('fan.0.rev')],
                    [Fan0Status           => $rep->get('fan.0.status')],
                    [Fan1Revision         => $rep->get('fan.1.rev')],
                    [Fan1Status           => $rep->get('fan.1.status')],
		    [FruPowerCount 	  => 3],
		    [FruCount             => $FRU_count  ],
                    [InterconnectRevision => $rep->get('interconnect.rev')],
                    [InterconnectStatus   => $rep->get('interconnect.status')],
                    [Caption              => "A5K"],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 					=> $rep->get("id.wwn")],
                  [Manufacturer 		=> 'SUN'],
                  [Model 				=> 'A5K'],
                  [Name  				=> $rep->get("id.wwn")],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element 				=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  for ($j = 0; $j <= 2 ; $j++) {
      $dd = $class->newPowerUnit($rep,"power.$j");
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "pcu$j"],
                   ]);

      push (@pil, @$dd);
      push (@pil, $a);
  }

  foreach $j ('A','B') {
      $dd = $class->newLoopCard($rep,"interface_board.$j");
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "l$j"], 
                   ]);

      push (@pil, @$dd);
      push (@pil, $a);
  }


  
  foreach $i ('disk_front','disk_rear') {
    for ($j=0; $j < 30; $j++) {
      next if (!$rep->get("$i.$j.product_id"));
      $dd = $class->newDiskDrive($rep,"$i.$j");
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "$i.$j"],
                   ]);
 
      push (@pil, @$dd);
      push (@pil, $a);
    }
  }
  return Ilist->new(\@pil);

}

sub newLoopCard {
  my($class, $rep, $cd) = @_;
  my(@il, $a1, $c1, $p1);

  my($serial_no) = $rep->get('id.wwn') . ".$cd";
  
  my($map) = PDM->getDeviceStateMap("a5.availability");
  my($state) = $map->get("status." . $rep->get("$cd.status"));

  $p1 = CIM::Instance->new('NWS_LoopCard', [
               [SystemName        => $cd       ],
               [DeviceID          => $serial_no],
               [StatusInfo        => $rep->get("$cd.status")],
               [Status            => $state ],
               [Revision          => $rep->get("$cd.rev")],
                    ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_Card', [
               [Removable           => ""],
               [Tag                 => $serial_no],
               [SerialNumber        => $serial_no],
               [WWN                 => $rep->get('id.wwn') ],
               [Manufacturer        => ""],
               [Model               => ""],
               [Version             => $rep->get("$cd.rev")],
                    ]);
  push(@il, $c1);

  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent     => $c1],
                [Dependent      => $p1],
                    ]);
  push(@il,$a1);

  return Ilist->new(\@il);
}


sub newPowerUnit {
  my($class, $rep, $cd) = @_;
  my(@il, $p1 ,$c1, $a1);

  my($serial_no) = $rep->get('id.wwn') . ".$cd";

  my($map) = PDM->getDeviceStateMap("a5.availability");
  my($state) = $map->get("status." . $rep->get("$cd.status"));

  $p1 = CIM::Instance->new('NWS_PowerUnit', [
               [SystemName   => $cd],
               [DeviceID     => $serial_no],
               [StatusInfo   => $rep->get("$cd.status")],
               [Status       => $state ],
               [Revision     => $rep->get("$cd.rev")],
                    ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
               [Removable       => "Yes"],
               [Tag             => $serial_no],
               [SerialNumber    => $serial_no],
               [Manufacturer    => ""],
               [Model           => ""],
               [Version         =>  $rep->get("$cd.rev")],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
               [Antecedent      => $c1],
               [Dependent       => $p1],
                    ]);

  push(@il,$a1);

  return Ilist->new(\@il);
}

# create instances of NWS_DiskDrive, CIM_Realizes, CIM_PhysicalPackage, 
# CIM_MediaPresent and CIM_StorageExtent, CIM_SoftwareElement, CIM_DeviceSoftware
#  $disk = NWS::TA5000->newDiskDrive($rep, "u1d1");

sub newDiskDrive {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1, $c2, $a2);
  
  my($status) = $rep->get("${cd}.status") . "-" . $rep->get("${cd}.state") ;

  my($map) = PDM->getDeviceStateMap("a5.availability");
  my($state) = $map->get("disk.status." . $rep->get("$cd.status")) . 
               $map->get("disk.state."  . $rep->get("$cd.state"));
  $state = ($state eq "11")? 1:0;

  $p1 = CIM::Instance->new('NWS_DiskDrive', [
                [SystemName 		=> $cd],
                [DeviceID 			=> $rep->get("${cd}.wwn")],
                [Wwn                => $rep->get("${cd}.wwn")],
                [Port1State         => $rep->get("${cd}.portA.status")],
                [Port2State         => $rep->get("${cd}.portB.status")],
                [StatusInfo         => $status],
                [Status             => $state],
                [FruDiskCapacity    => $rep->get("${cd}.u_capacity")],
                 ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
                [Removable 				=> "Yes"],
                [Replaceable 			=> ""],
                [Tag 					=> $rep->get("${cd}.wwn")],
                [SerialNumber 			=> $rep->get("${cd}.serial_no")],
                [Manufacturer 			=> $rep->get("${cd}.vendor")],  
                [Model 					=> $rep->get("${cd}.product_id")],  
                [Version 				=> $rep->get("${cd}.revision")],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                    [Antecedent => $c1],
                    [Dependent  => $p1],
                    ]);
  push(@il, $a1);

  return Ilist->new(\@il);

}

1;
